/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;

public class NetworkAdminHTTPTester
implements NetworkAdminProtocolTester {
    private AzureusCore core;
    private NetworkAdminProgressListener listener;

    protected NetworkAdminHTTPTester(AzureusCore azureusCore, NetworkAdminProgressListener networkAdminProgressListener) {
        this.core = azureusCore;
        this.listener = networkAdminProgressListener;
    }

    @Override
    public InetAddress testOutbound(InetAddress inetAddress, int n) throws NetworkAdminException {
        if (inetAddress != null || n != 0) {
            throw new NetworkAdminException("HTTP tester doesn't support local bind options");
        }
        try {
            return VersionCheckClient.getSingleton().getExternalIpAddressHTTP(false);
        }
        catch (Throwable throwable) {
            try {
                URL uRL = new URL("http://www.google.com/");
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(10000);
                uRLConnection.connect();
                return null;
            }
            catch (Throwable throwable2) {
                throw new NetworkAdminException("Outbound test failed", throwable);
            }
        }
    }

    @Override
    public InetAddress testInbound(InetAddress inetAddress, int n) throws NetworkAdminException {
        NatChecker natChecker = new NatChecker(this.core, inetAddress, n, true);
        if (natChecker.getResult() == 1) {
            return natChecker.getExternalAddress();
        }
        throw new NetworkAdminException("NAT check failed: " + natChecker.getAdditionalInfo());
    }
}

