/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualChannelSelectorImpl;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class VirtualChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    public static final int OP_ACCEPT = 16;
    public static final int OP_CONNECT = 8;
    public static final int OP_READ = 1;
    public static final int OP_WRITE = 4;
    private boolean SAFE_SELECTOR_MODE_ENABLED = COConfigurationManager.getBooleanParameter("network.tcp.enable_safe_selector_mode");
    private static final boolean TEST_SAFE_MODE = false;
    private static final int MAX_CHANNELS_PER_SAFE_SELECTOR = COConfigurationManager.getIntParameter("network.tcp.safe_selector_mode.chunk_size");
    private static final int MAX_SAFEMODE_SELECTORS = 20000 / MAX_CHANNELS_PER_SAFE_SELECTOR;
    private String name;
    private VirtualChannelSelectorImpl selector_impl;
    private volatile boolean destroyed;
    private HashMap<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> selectors;
    private HashSet<VirtualChannelSelectorImpl> selectors_keyset_cow;
    private AEMonitor selectors_mon;
    private final int op;
    private final boolean pause;
    private boolean randomise_keys;

    public VirtualChannelSelector(String string, int n, boolean bl) {
        this.name = string;
        this.op = n;
        this.pause = bl;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            this.initSafeMode();
        } else {
            this.selector_impl = new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys);
            this.selectors = null;
            this.selectors_keyset_cow = null;
            this.selectors_mon = null;
        }
    }

    public String getName() {
        return this.name;
    }

    private void initSafeMode() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "***************** SAFE SOCKET SELECTOR MODE ENABLED *****************"));
        }
        this.selector_impl = null;
        this.selectors = new HashMap();
        this.selectors_mon = new AEMonitor("VirtualChannelSelector:FM");
        this.selectors.put(new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys), new ArrayList());
        this.selectors_keyset_cow = new HashSet<VirtualChannelSelectorImpl>(this.selectors.keySet());
    }

    public void register(SocketChannel socketChannel, VirtualSelectorListener virtualSelectorListener, Object object) {
        this.registerSupport(socketChannel, virtualSelectorListener, object);
    }

    public void register(ServerSocketChannel serverSocketChannel, VirtualAcceptSelectorListener virtualAcceptSelectorListener, Object object) {
        this.registerSupport(serverSocketChannel, virtualAcceptSelectorListener, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSupport(AbstractSelectableChannel abstractSelectableChannel, VirtualAbstractSelectorListener virtualAbstractSelectorListener, Object object) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                Object object2;
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> object32 : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl virtualChannelSelectorImpl = object32.getKey();
                    ArrayList<AbstractSelectableChannel> arrayList = object32.getValue();
                    if (arrayList.size() >= MAX_CHANNELS_PER_SAFE_SELECTOR) {
                        Iterator<AbstractSelectableChannel> iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            AbstractSelectableChannel abstractSelectableChannel2 = iterator.next();
                            if (abstractSelectableChannel2.isOpen()) continue;
                            Debug.out("Selector '" + this.getName() + "' - removing orphaned safe channel registration");
                            iterator.remove();
                        }
                    }
                    if (arrayList.size() >= MAX_CHANNELS_PER_SAFE_SELECTOR) continue;
                    virtualChannelSelectorImpl.register(abstractSelectableChannel, virtualAbstractSelectorListener, object);
                    arrayList.add(abstractSelectableChannel);
                    return;
                }
                if (this.selectors.size() >= MAX_SAFEMODE_SELECTORS) {
                    object2 = "Error: MAX_SAFEMODE_SELECTORS reached [" + this.selectors.size() + "], no more socket channels can be registered. Too many peer connections.";
                    Debug.out((String)object2);
                    this.selectFailure(virtualAbstractSelectorListener, abstractSelectableChannel, object, new Throwable((String)object2));
                    return;
                }
                if (this.destroyed) {
                    object2 = "socket registered after controller destroyed";
                    Debug.out((String)object2);
                    this.selectFailure(virtualAbstractSelectorListener, abstractSelectableChannel, object, new Throwable((String)object2));
                    return;
                }
                object2 = new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys);
                ArrayList<AbstractSelectableChannel> arrayList = new ArrayList<AbstractSelectableChannel>();
                this.selectors.put((VirtualChannelSelectorImpl)object2, arrayList);
                ((VirtualChannelSelectorImpl)object2).register(abstractSelectableChannel, virtualAbstractSelectorListener, object);
                arrayList.add(abstractSelectableChannel);
                this.selectors_keyset_cow = new HashSet<VirtualChannelSelectorImpl>(this.selectors.keySet());
            }
            finally {
                this.selectors_mon.exit();
            }
        }
        this.selector_impl.register(abstractSelectableChannel, virtualAbstractSelectorListener, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelects(AbstractSelectableChannel abstractSelectableChannel) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                    ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                    if (!arrayList.contains(abstractSelectableChannel)) continue;
                    virtualChannelSelectorImpl.pauseSelects(abstractSelectableChannel);
                    return;
                }
                Debug.out("pauseSelects():: channel not found!");
            }
            finally {
                this.selectors_mon.exit();
            }
        }
        this.selector_impl.pauseSelects(abstractSelectableChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelects(AbstractSelectableChannel abstractSelectableChannel) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                    ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                    if (!arrayList.contains(abstractSelectableChannel)) continue;
                    virtualChannelSelectorImpl.resumeSelects(abstractSelectableChannel);
                    return;
                }
                Debug.out("resumeSelects():: channel not found!");
            }
            finally {
                this.selectors_mon.exit();
            }
        }
        this.selector_impl.resumeSelects(abstractSelectableChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AbstractSelectableChannel abstractSelectableChannel) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl virtualChannelSelectorImpl = entry.getKey();
                    ArrayList<AbstractSelectableChannel> arrayList = entry.getValue();
                    if (!arrayList.remove(abstractSelectableChannel)) continue;
                    virtualChannelSelectorImpl.cancel(abstractSelectableChannel);
                    return;
                }
            }
            finally {
                this.selectors_mon.exit();
            }
        }
        if (this.selector_impl != null) {
            this.selector_impl.cancel(abstractSelectableChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomiseKeys(boolean bl) {
        this.randomise_keys = bl;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (VirtualChannelSelectorImpl virtualChannelSelectorImpl : this.selectors.keySet()) {
                    virtualChannelSelectorImpl.setRandomiseKeys(this.randomise_keys);
                }
            }
            finally {
                this.selectors_mon.exit();
            }
        } else if (this.selector_impl != null) {
            this.selector_impl.setRandomiseKeys(this.randomise_keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long l) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            boolean bl = this.destroyed;
            try {
                int n = 0;
                for (VirtualChannelSelectorImpl virtualChannelSelectorImpl : this.selectors_keyset_cow) {
                    n += virtualChannelSelectorImpl.select(l);
                }
                int n2 = n;
                return n2;
            }
            finally {
                if (bl) {
                    try {
                        this.selectors_mon.enter();
                        this.selectors.clear();
                        this.selectors_keyset_cow = new HashSet();
                    }
                    finally {
                        this.selectors_mon.exit();
                    }
                }
            }
        }
        return this.selector_impl.select(l);
    }

    public void destroy() {
        this.destroyed = true;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            for (VirtualChannelSelectorImpl virtualChannelSelectorImpl : this.selectors_keyset_cow) {
                virtualChannelSelectorImpl.destroy();
            }
        } else {
            this.selector_impl.destroy();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isSafeSelectionModeEnabled() {
        return this.SAFE_SELECTOR_MODE_ENABLED;
    }

    public void enableSafeSelectionMode() {
        if (!this.SAFE_SELECTOR_MODE_ENABLED) {
            this.SAFE_SELECTOR_MODE_ENABLED = true;
            COConfigurationManager.setParameter("network.tcp.enable_safe_selector_mode", true);
            this.initSafeMode();
        }
    }

    public boolean selectSuccess(VirtualAbstractSelectorListener virtualAbstractSelectorListener, AbstractSelectableChannel abstractSelectableChannel, Object object) {
        if (this.op == 16) {
            return ((VirtualAcceptSelectorListener)virtualAbstractSelectorListener).selectSuccess(this, (ServerSocketChannel)abstractSelectableChannel, object);
        }
        return ((VirtualSelectorListener)virtualAbstractSelectorListener).selectSuccess(this, (SocketChannel)abstractSelectableChannel, object);
    }

    public void selectFailure(VirtualAbstractSelectorListener virtualAbstractSelectorListener, AbstractSelectableChannel abstractSelectableChannel, Object object, Throwable throwable) {
        if (this.op == 16) {
            ((VirtualAcceptSelectorListener)virtualAbstractSelectorListener).selectFailure(this, (ServerSocketChannel)abstractSelectableChannel, object, throwable);
        } else {
            ((VirtualSelectorListener)virtualAbstractSelectorListener).selectFailure(this, (SocketChannel)abstractSelectableChannel, object, throwable);
        }
    }

    public static interface VirtualAcceptSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3, Throwable var4);
    }

    public static interface VirtualSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, SocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, SocketChannel var2, Object var3, Throwable var4);
    }

    public static interface VirtualAbstractSelectorListener {
    }
}

