/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectionAttempt;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AddressUtils;

public class ConnectionEndpoint {
    private InetSocketAddress notional_address;
    private ProtocolEndpoint[] protocols;

    public ConnectionEndpoint(InetSocketAddress inetSocketAddress) {
        this.notional_address = inetSocketAddress;
    }

    public InetSocketAddress getNotionalAddress() {
        return this.notional_address;
    }

    public boolean matchIP(String string) {
        if (this.matchIP(string, this.notional_address)) {
            return true;
        }
        ProtocolEndpoint[] protocolEndpointArray = this.getProtocols();
        for (int i = 0; i < protocolEndpointArray.length; ++i) {
            ProtocolEndpoint protocolEndpoint;
            ProtocolEndpoint protocolEndpoint2 = protocolEndpointArray[i];
            if (!(protocolEndpoint2.getType() == 1 ? this.matchIP(string, ((ProtocolEndpointTCP)(protocolEndpoint = (ProtocolEndpointTCP)protocolEndpoint2)).getAddress()) : this.matchIP(string, ((ProtocolEndpointUDP)(protocolEndpoint = (ProtocolEndpointUDP)protocolEndpoint2)).getAddress()))) continue;
            return true;
        }
        return false;
    }

    protected boolean matchIP(String string, InetSocketAddress inetSocketAddress) {
        return string.equals(inetSocketAddress.getAddress().getHostAddress());
    }

    public ProtocolEndpoint[] getProtocols() {
        if (this.protocols == null) {
            return new ProtocolEndpoint[0];
        }
        return this.protocols;
    }

    public void addProtocol(ProtocolEndpoint protocolEndpoint) {
        if (this.protocols == null) {
            this.protocols = new ProtocolEndpoint[]{protocolEndpoint};
        } else {
            for (int i = 0; i < this.protocols.length; ++i) {
                if (this.protocols[i] != protocolEndpoint) continue;
                return;
            }
            ProtocolEndpoint[] protocolEndpointArray = new ProtocolEndpoint[this.protocols.length + 1];
            System.arraycopy(this.protocols, 0, protocolEndpointArray, 0, this.protocols.length);
            protocolEndpointArray[this.protocols.length] = protocolEndpoint;
            this.protocols = protocolEndpointArray;
        }
        protocolEndpoint.setConnectionEndpoint(this);
    }

    public ConnectionEndpoint getLANAdjustedEndpoint() {
        ConnectionEndpoint connectionEndpoint = new ConnectionEndpoint(this.notional_address);
        for (int i = 0; i < this.protocols.length; ++i) {
            InetSocketAddress inetSocketAddress;
            ProtocolEndpoint protocolEndpoint;
            ProtocolEndpoint protocolEndpoint2 = this.protocols[i];
            if (protocolEndpoint2.getType() == 1) {
                protocolEndpoint = (ProtocolEndpointTCP)protocolEndpoint2;
                inetSocketAddress = AddressUtils.adjustTCPAddress(((ProtocolEndpointTCP)protocolEndpoint).getAddress(), true);
                new ProtocolEndpointTCP(connectionEndpoint, inetSocketAddress);
                continue;
            }
            if (protocolEndpoint2.getType() == 2) {
                protocolEndpoint = (ProtocolEndpointUDP)protocolEndpoint2;
                inetSocketAddress = AddressUtils.adjustUDPAddress(((ProtocolEndpointUDP)protocolEndpoint).getAddress(), true);
                new ProtocolEndpointUDP(connectionEndpoint, inetSocketAddress);
                continue;
            }
            connectionEndpoint.addProtocol(protocolEndpoint2);
        }
        return connectionEndpoint;
    }

    public ConnectionAttempt connectOutbound(boolean bl, boolean bl2, byte[][] byArray, ByteBuffer byteBuffer, int n, Transport.ConnectListener connectListener) {
        ProtocolEndpoint protocolEndpoint = this.protocols[0];
        final Transport transport = protocolEndpoint.connectOutbound(bl, bl2, byArray, byteBuffer, n, connectListener);
        return new ConnectionAttempt(){

            @Override
            public void abandon() {
                if (transport != null) {
                    transport.close("Connection attempt abandoned");
                }
            }
        };
    }

    public String getDescription() {
        String string = "[";
        for (int i = 0; i < this.protocols.length; ++i) {
            string = string + (i == 0 ? "" : ",") + this.protocols[i].getDescription();
        }
        return string + "]";
    }
}

