/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchException;
import com.aelitis.azureus.core.metasearch.MetaSearchListener;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchManagerImpl;
import com.aelitis.azureus.core.metasearch.impl.SearchExecuter;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.metasearch.impl.web.rss.RSSEngine;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;

public class MetaSearchImpl
implements MetaSearch {
    private static final String CONFIG_FILE = "metasearch.config";
    private MetaSearchManagerImpl manager;
    private CopyOnWriteList<EngineImpl> engines = new CopyOnWriteList();
    private Map<String, Long> plugin_map = new HashMap<String, Long>();
    private boolean config_dirty;
    private CopyOnWriteList<MetaSearchListener> listeners = new CopyOnWriteList();
    private TimerEventPeriodic update_check_timer;
    private static final int UPDATE_CHECK_PERIOD = 900000;
    private static final int MIN_UPDATE_CHECK_SECS = 600;
    private Object MS_UPDATE_CONSEC_FAIL_KEY = new Object();

    protected MetaSearchImpl(MetaSearchManagerImpl metaSearchManagerImpl) {
        this.manager = metaSearchManagerImpl;
        this.loadConfig();
    }

    protected MetaSearchManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public Engine importFromBEncodedMap(Map<String, Object> map) throws IOException {
        return EngineImpl.importFromBEncodedMap(this, map);
    }

    public Engine importFromJSONString(int n, long l, long l2, float f, String string, String string2) throws IOException {
        return EngineImpl.importFromJSONString(this, n, l, l2, f, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineImpl importFromPlugin(String string, SearchProvider searchProvider) throws IOException {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            long l;
            Long l2 = this.plugin_map.get(string);
            if (l2 == null) {
                l = this.manager.getLocalTemplateID();
                this.plugin_map.put(string, new Long(l));
                this.configDirty();
            } else {
                l = l2;
            }
            EngineImpl engineImpl = (EngineImpl)this.getEngine(l);
            if (engineImpl == null) {
                engineImpl = new PluginEngine(this, l, searchProvider);
                engineImpl.setSource(2);
                engineImpl.setSelectionState(2);
                this.addEngine(engineImpl);
            } else if (engineImpl instanceof PluginEngine) {
                ((PluginEngine)engineImpl).setProvider(searchProvider);
            } else {
                Debug.out("Inconsistent: plugin must be a PluginEngine!");
                this.plugin_map.remove(string);
                this.removeEngine(engineImpl);
                throw new IOException("Inconsistent");
            }
            return engineImpl;
        }
    }

    @Override
    public Engine createRSSEngine(String string, URL uRL) throws MetaSearchException {
        RSSEngine rSSEngine = new RSSEngine(this, this.manager.getLocalTemplateID(), SystemTime.getCurrentTime(), 1.0f, string, uRL.toExternalForm(), false, "transparent", null, new String[0]);
        rSSEngine.setSource(3);
        this.addEngine(rSSEngine, false);
        this.log("Created RSS engine '" + uRL + "'");
        return rSSEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdateChecks() {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            if (this.update_check_timer == null) {
                this.update_check_timer = SimpleTimer.addPeriodicEvent("MS:updater", 900000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent timerEvent2) {
                        MetaSearchImpl.this.checkUpdates();
                    }
                });
            }
        }
    }

    protected void checkUpdates() {
        for (EngineImpl engineImpl : this.engines) {
            int n;
            long l;
            String string = engineImpl.getUpdateURL();
            if (string == null) continue;
            long l2 = SystemTime.getCurrentTime();
            long l3 = engineImpl.getLastUpdateCheck();
            if (l3 > l2) {
                l3 = l2;
                engineImpl.setLastUpdateCheck(l2);
            }
            if ((l = (long)engineImpl.getUpdateCheckSecs()) < 600L) {
                this.log("Engine '" + engineImpl.getName() + "': Update check period too small (" + l + " secs) adjusting to " + 600 + ": " + engineImpl.getName());
                l = 600L;
            }
            long l4 = l * 1000L;
            long l5 = l3 + l4;
            Object object = engineImpl.getUserData(this.MS_UPDATE_CONSEC_FAIL_KEY);
            int n2 = n = object == null ? 0 : (Integer)object;
            if (n > 0) {
                l5 += (long)(900000 << n);
            }
            if (l5 >= l2) continue;
            if (this.updateEngine(engineImpl)) {
                n = 0;
                engineImpl.setLastUpdateCheck(l2);
            } else if (++n > 3) {
                n = 0;
                engineImpl.setLastUpdateCheck(l2);
            }
            engineImpl.setUserData(this.MS_UPDATE_CONSEC_FAIL_KEY, n == 0 ? null : new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateEngine(EngineImpl engineImpl) {
        String string = engineImpl.getUpdateURL();
        int n = string.indexOf(63);
        string = n == -1 ? string + "?" : string + "&";
        string = string + "az_template_uid=" + engineImpl.getUID() + "&az_template_version=" + engineImpl.getVersion() + "&az_version=" + "4.5.0.4" + "&az_locale=" + MessageText.getCurrentLocale().toString() + "&az_rand=" + Math.abs(new Random().nextLong());
        this.log("Engine " + engineImpl.getName() + ": auto-update check via " + string);
        try {
            ResourceDownloaderFactory resourceDownloaderFactory = StaticUtilities.getResourceDownloaderFactory();
            ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(new URL(string));
            ResourceDownloader resourceDownloader2 = resourceDownloaderFactory.getMetaRefreshDownloader(resourceDownloader);
            try (InputStream inputStream = resourceDownloader2.download();){
                Map map = BDecoder.decode(new BufferedInputStream(inputStream));
                this.log("    update check reply: " + map);
                Map map2 = (Map)map.get("response");
                if (map2 != null) {
                    int n2;
                    Long l = (Long)map2.get("update_url_check_secs");
                    if (l == null) {
                        engineImpl.setLocalUpdateCheckSecs(0);
                    } else {
                        n2 = l.intValue();
                        if (n2 < 600) {
                            this.log("    update check secs for to small, min is 600");
                            n2 = 600;
                        }
                        engineImpl.setLocalUpdateCheckSecs(n2);
                    }
                    n2 = 1;
                    return n2 != 0;
                }
                VuzeFile vuzeFile = VuzeFileHandler.getSingleton().loadVuzeFile(map);
                if (vuzeFile == null) {
                    this.log("    failed to decode vuze file");
                    boolean bl = false;
                    return bl;
                }
                Engine[] engineArray = this.manager.loadFromVuzeFile(vuzeFile);
                if (engineArray.length <= 0) {
                    this.log("    no engines found in vuze file");
                } else {
                    String string2 = engineImpl.getUID();
                    boolean bl = false;
                    String string3 = "";
                    for (int i = 0; i < engineArray.length; ++i) {
                        Engine engine = engineArray[i];
                        string3 = string3 + (i == 0 ? "" : ",") + engine.getName() + ": uid=" + engine.getUID() + ",version=" + engine.getVersion();
                        if (!engine.getUID().equals(string2)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        this.log("    existing engine not found in updated set, deleting");
                        engineImpl.delete();
                    }
                    this.log("    update complete: new engines=" + string3);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
            this.log("    update check failed", throwable);
            return false;
        }
    }

    @Override
    public void addEngine(Engine engine) {
        this.addEngine((EngineImpl)engine, false);
    }

    @Override
    public Engine addEngine(long l) throws MetaSearchException {
        try {
            PlatformMetaSearchMessenger.templateDetails templateDetails2 = PlatformMetaSearchMessenger.getTemplate(this.manager.getExtensionKey(), l);
            this.log("Downloading definition of template " + l);
            this.log(templateDetails2.getValue());
            if (templateDetails2.isVisible()) {
                Engine engine = this.importFromJSONString(templateDetails2.getType() == 1 ? 2 : 1, templateDetails2.getId(), templateDetails2.getModifiedDate(), templateDetails2.getRankBias(), templateDetails2.getName(), templateDetails2.getValue());
                engine.setSource(1);
                engine.setSelectionState(0);
                this.addEngine(engine);
                return engine;
            }
            throw new MetaSearchException("Search template is not visible");
        }
        catch (MetaSearchException metaSearchException) {
            throw metaSearchException;
        }
        catch (Throwable throwable) {
            throw new MetaSearchException("Template load failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngine(EngineImpl engineImpl, boolean bl) {
        boolean bl2 = true;
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            Iterator<EngineImpl> object = this.engines.iterator();
            while (object.hasNext()) {
                Engine engine = object.next();
                if (engine.getId() == engineImpl.getId()) {
                    this.log("Updating engine with same ID " + engine.getId() + ": " + engine.getName() + "/" + engine.getUID());
                    object.remove();
                    engineImpl.setUID(engine.getUID());
                    if (engine.sameLogicAs(engineImpl)) {
                        engineImpl.setVersion(engine.getVersion());
                    } else {
                        engineImpl.setVersion(engine.getVersion() + 1);
                        this.log("    new version=" + engineImpl.getVersion());
                    }
                    bl2 = false;
                    continue;
                }
                if (!engine.getUID().equals(engineImpl.getUID())) continue;
                this.log("Removing engine with same UID " + engine.getUID() + "(" + engine.getName() + ")");
                object.remove();
            }
            this.engines.add(engineImpl);
        }
        if (engineImpl.getUpdateURL() != null) {
            this.enableUpdateChecks();
        }
        if (!bl) {
            this.log("Engine '" + engineImpl.getName() + "' added");
            this.saveConfig();
            for (MetaSearchListener metaSearchListener : this.listeners) {
                try {
                    if (bl2) {
                        metaSearchListener.engineAdded(engineImpl);
                        continue;
                    }
                    metaSearchListener.engineUpdated(engineImpl);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public void removeEngine(Engine engine) {
        if (this.engines.remove((EngineImpl)engine)) {
            this.log("Engine '" + engine.getName() + "' removed");
            this.saveConfig();
            Iterator<MetaSearchListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().engineRemoved(engine);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public Engine[] getEngines(boolean bl, boolean bl2) {
        List<EngineImpl> list;
        if (bl2) {
            this.manager.ensureEnginesUpToDate();
        }
        List<EngineImpl> list2 = this.engines.getList();
        if (bl) {
            list = new ArrayList<EngineImpl>();
            for (int i = 0; i < list2.size(); ++i) {
                EngineImpl engineImpl = list2.get(i);
                if (!engineImpl.isActive()) continue;
                list.add(engineImpl);
            }
        } else {
            list = list2;
        }
        return list.toArray(new Engine[list.size()]);
    }

    @Override
    public Engine getEngine(long l) {
        List<EngineImpl> list = this.engines.getList();
        for (int i = 0; i < list.size(); ++i) {
            Engine engine = list.get(i);
            if (engine.getId() != l) continue;
            return engine;
        }
        return null;
    }

    @Override
    public Engine getEngineByUID(String string) {
        List<EngineImpl> list = this.engines.getList();
        for (int i = 0; i < list.size(); ++i) {
            Engine engine = list.get(i);
            if (!engine.getUID().equals(string)) continue;
            return engine;
        }
        return null;
    }

    @Override
    public int getEngineCount() {
        return this.engines.size();
    }

    @Override
    public Engine[] search(ResultListener resultListener, SearchParameter[] searchParameterArray, String string, int n) {
        return this.search(resultListener, searchParameterArray, string, new HashMap<String, String>(), n);
    }

    @Override
    public Engine[] search(ResultListener resultListener, SearchParameter[] searchParameterArray, String string, Map<String, String> map, int n) {
        return this.search(null, resultListener, searchParameterArray, string, map, n);
    }

    @Override
    public Engine[] search(Engine[] engineArray, ResultListener resultListener, SearchParameter[] searchParameterArray, String string, int n) {
        return this.search(engineArray, resultListener, searchParameterArray, string, new HashMap<String, String>(), n);
    }

    @Override
    public void enginePreferred(Engine engine) {
        Engine[] engineArray = this.getEngines(true, false);
        int n = 0;
        for (Engine engine2 : engineArray) {
            if (engine2.getId() == engine.getId()) {
                engine2.setPreferredDelta(1.0f);
                continue;
            }
            if (!(engine2.getPreferredWeighting() > 0.0f)) continue;
            ++n;
        }
        if (n > 0) {
            float f = -1 / n;
            for (Engine engine3 : engineArray) {
                if (engine3.getId() == engine.getId() || !(engine3.getPreferredWeighting() > 0.0f)) continue;
                engine3.setPreferredDelta(f);
            }
        }
    }

    @Override
    public Engine[] search(Engine[] engineArray, final ResultListener resultListener, SearchParameter[] searchParameterArray, String string, Map<String, String> map, final int n) {
        int n2;
        String string2 = map.get("batch_millis");
        final long l = string2 == null ? 0L : Long.parseLong(string2);
        String string3 = map.get("remove_dup_hash");
        final boolean bl = string3 == null ? false : string3.equalsIgnoreCase("true");
        ResultListener resultListener2 = new ResultListener(){
            private AsyncDispatcher dispatcher = new AsyncDispatcher(5000);
            private final Map<Engine, List<Result[]>> pending_results = new HashMap<Engine, List<Result[]>>();
            private final Map<Engine, Set<String>> result_hashes = new HashMap<Engine, Set<String>>();

            @Override
            public void contentReceived(final Engine engine, final String string) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        resultListener.contentReceived(engine, string);
                    }
                });
            }

            @Override
            public void matchFound(final Engine engine, final String[] stringArray) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        resultListener.matchFound(engine, stringArray);
                    }
                });
            }

            @Override
            public void resultsReceived(final Engine engine, final Result[] resultArray) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        Result[] resultArray2 = null;
                        if (l > 0L) {
                            List list = (List)pending_results.get(engine);
                            if (list == null) {
                                resultArray2 = resultArray;
                                pending_results.put(engine, new ArrayList());
                                new DelayedEvent("SearchBatcher", l, new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        dispatcher.dispatch(new AERunnable(){

                                            @Override
                                            public void runSupport() {
                                                this.batchResultsComplete(engine);
                                            }
                                        });
                                    }
                                });
                            } else {
                                list.add(resultArray);
                            }
                        } else {
                            resultArray2 = resultArray;
                        }
                        if (resultArray2 != null) {
                            resultArray2 = this.truncateResults(engine, resultArray2, n);
                            resultListener.resultsReceived(engine, resultArray2);
                        }
                    }
                });
            }

            @Override
            public void resultsComplete(final Engine engine) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (l > 0L) {
                            this.batchResultsComplete(engine);
                        }
                        resultListener.resultsComplete(engine);
                    }
                });
            }

            protected void batchResultsComplete(Engine engine) {
                List<Result[]> list = this.pending_results.remove(engine);
                if (list != null) {
                    ArrayList<Result> arrayList = new ArrayList<Result>();
                    for (Result[] resultArray : list) {
                        arrayList.addAll(Arrays.asList(resultArray));
                    }
                    Result[] resultArray = arrayList.toArray(new Result[arrayList.size()]);
                    resultArray = this.truncateResults(engine, resultArray, n);
                    resultListener.resultsReceived(engine, resultArray);
                }
            }

            protected Result[] truncateResults(Engine engine, Result[] resultArray, int n2) {
                Set<String> set = this.result_hashes.get(engine);
                if (set == null) {
                    set = new HashSet<String>();
                    this.result_hashes.put(engine, set);
                }
                ArrayList<Result> arrayList = new ArrayList<Result>(resultArray.length);
                for (Result result : resultArray) {
                    String string = result.getName();
                    if (string == null || string.trim().length() == 0) continue;
                    if (bl) {
                        String string2 = result.getHash();
                        if (string2 == null || string2.length() == 0) {
                            arrayList.add(result);
                            continue;
                        }
                        if (set.contains(string2)) continue;
                        arrayList.add(result);
                        set.add(string2);
                        continue;
                    }
                    arrayList.add(result);
                }
                if (n2 < arrayList.size()) {
                    MetaSearchImpl.this.log("Truncating search results for " + engine.getName() + " from " + arrayList.size() + " to " + n2);
                    Collections.sort(arrayList, new Comparator<Result>(){
                        Map<Result, Float> ranks = new HashMap<Result, Float>();

                        @Override
                        public int compare(Result result, Result result2) {
                            Float f;
                            Float f2 = this.ranks.get(result);
                            if (f2 == null) {
                                f2 = new Float(result.getRank());
                                this.ranks.put(result, f2);
                            }
                            if ((f = this.ranks.get(result2)) == null) {
                                f = new Float(result2.getRank());
                                this.ranks.put(result2, f);
                            }
                            return -f2.compareTo(f);
                        }
                    });
                    Result[] resultArray2 = new Result[n2];
                    for (int i = 0; i < n2; ++i) {
                        resultArray2[i] = (Result)arrayList.get(i);
                    }
                    return resultArray2;
                }
                return arrayList.toArray(new Result[arrayList.size()]);
            }

            @Override
            public void engineFailed(final Engine engine, final Throwable throwable) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        resultListener.engineFailed(engine, throwable);
                    }
                });
            }

            @Override
            public void engineRequiresLogin(final Engine engine, final Throwable throwable) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        resultListener.engineRequiresLogin(engine, throwable);
                    }
                });
            }
        };
        SearchExecuter searchExecuter = new SearchExecuter(map, resultListener2);
        if (engineArray == null) {
            engineArray = this.getEngines(true, true);
        }
        String string4 = "";
        for (n2 = 0; n2 < engineArray.length; ++n2) {
            string4 = string4 + (n2 == 0 ? "" : ",") + engineArray[n2].getId();
        }
        this.log("Search: engines=" + string4);
        for (n2 = 0; n2 < engineArray.length; ++n2) {
            searchExecuter.search(engineArray[n2], searchParameterArray, string, n);
        }
        return engineArray;
    }

    @Override
    public void addListener(MetaSearchListener metaSearchListener) {
        this.listeners.add(metaSearchListener);
    }

    @Override
    public void removeListener(MetaSearchListener metaSearchListener) {
        this.listeners.remove(metaSearchListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        this.log("Loading configuration");
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            Map map;
            Map map2 = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List list = (List)map2.get("engines");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Map map3 = (Map)list.get(i);
                    try {
                        Engine engine = this.importFromBEncodedMap(map3);
                        this.addEngine((EngineImpl)engine, true);
                        this.log("    loaded " + engine.getString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to import engine from " + map3, throwable);
                    }
                }
            }
            if ((map = (Map)map2.get("plugin_map")) != null) {
                this.plugin_map = map;
            }
        }
        if (this.update_check_timer != null) {
            new AsyncDispatcher().dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    MetaSearchImpl.this.checkUpdates();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("MetaSearch:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        if (!MetaSearchImpl.this.config_dirty) {
                            return;
                        }
                        MetaSearchImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            this.config_dirty = false;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            hashMap.put("engines", arrayList);
            for (Engine engine : this.engines) {
                try {
                    arrayList.add(engine.exportToBencodedMap());
                }
                catch (Throwable throwable) {
                    this.log("Failed to export engine " + engine.getName(), throwable);
                }
            }
            if (this.plugin_map != null) {
                hashMap.put("plugin_map", this.plugin_map);
            }
            FileUtil.writeResilientConfigFile(CONFIG_FILE, hashMap);
        }
    }

    protected void log(String string) {
        this.manager.log("search :" + string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log("search :" + string, throwable);
    }

    protected void generate(IndentWriter indentWriter) {
        for (EngineImpl engineImpl : this.engines) {
            indentWriter.println(engineImpl.getString(true));
        }
    }
}

