/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class PlatformMetaSearchMessenger {
    private static final int MAX_TEMPLATE_LIST = 512;
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("searchtemplate", true);
    private static final String OP_GET_TEMPLATE = "get-template";
    private static final String OP_GET_TEMPLATES = "get-templates";
    private static final String OP_LIST_POPULAR_TEMPLATES = "list-popular";
    private static final String OP_LIST_FEATURED_TEMPLATES = "list-featured";
    private static final String OP_TEMPLATE_SELECTED = "template-selected";

    public static templateDetails getTemplate(String string, long l) throws PlatformMessengerException {
        int n;
        Map map;
        templateInfo templateInfo2;
        Map map2 = PlatformMetaSearchMessenger.getParameter(l);
        if (string != null) {
            map2.put("extension_key", string);
        }
        if ((templateInfo2 = PlatformMetaSearchMessenger.getTemplateInfo(map = dispatcher.syncInvoke(OP_GET_TEMPLATE, map2))) == null) {
            throw new PlatformMessengerException("Invalid reply: " + map);
        }
        String string2 = (String)map.get("name");
        String string3 = (String)map.get("value");
        String string4 = (String)map.get("engine_id");
        if (string2 == null || string3 == null || string4 == null) {
            throw new PlatformMessengerException("Invalid reply; field missing: " + map);
        }
        if (string4.equals("json")) {
            n = 1;
        } else if (string4.equals("regexp")) {
            n = 2;
        } else {
            throw new PlatformMessengerException("Invalid type '" + string4 + ": " + map);
        }
        return new templateDetails(templateInfo2, n, string2, string3);
    }

    public static templateInfo[] getTemplateDetails(String string, long[] lArray) throws PlatformMessengerException {
        if (lArray.length == 0) {
            return new templateInfo[0];
        }
        String string2 = "";
        for (int i = 0; i < lArray.length; ++i) {
            string2 = string2 + (i == 0 ? "" : ",") + lArray[i];
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            hashMap.put("extension_key", string);
        }
        hashMap.put("templateIds", string2);
        Map map = dispatcher.syncInvoke(OP_GET_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    public static templateInfo[] listTopPopularTemplates(String string) throws PlatformMessengerException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            hashMap.put("extension_key", string);
        }
        Map map = dispatcher.syncInvoke(OP_LIST_POPULAR_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    public static templateInfo[] listAllPopularTemplates(String string) throws PlatformMessengerException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string != null) {
            hashMap.put("extension_key", string);
        }
        hashMap.put("page-num", new Long(1L));
        hashMap.put("items-per-page", new Long(512L));
        Map map = dispatcher.syncInvoke(OP_LIST_POPULAR_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    public static templateInfo[] listFeaturedTemplates(String string) throws PlatformMessengerException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string != null) {
            hashMap.put("extension_key", string);
        }
        hashMap.put("page-num", new Long(1L));
        hashMap.put("items-per-page", new Long(512L));
        Map map = dispatcher.syncInvoke(OP_LIST_FEATURED_TEMPLATES, hashMap);
        return PlatformMetaSearchMessenger.getTemplatesInfo(map);
    }

    protected static templateInfo[] getTemplatesInfo(Map map) {
        List list = (List)map.get("templates");
        ArrayList<templateInfo> arrayList = new ArrayList<templateInfo>();
        for (int i = 0; i < list.size(); ++i) {
            Map map2 = (Map)list.get(i);
            templateInfo templateInfo2 = PlatformMetaSearchMessenger.getTemplateInfo(map2);
            if (templateInfo2 == null) continue;
            arrayList.add(templateInfo2);
        }
        templateInfo[] templateInfoArray = new templateInfo[arrayList.size()];
        arrayList.toArray(templateInfoArray);
        return templateInfoArray;
    }

    protected static templateInfo getTemplateInfo(Map map) {
        Long l = (Long)map.get("id");
        Boolean bl = (Boolean)map.get("show");
        Long l2 = (Long)map.get("modified_dt");
        float f = 1.0f;
        try {
            String string = (String)map.get("rank_bias");
            if (string != null) {
                f = Float.parseFloat(string);
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        if (bl == null) {
            bl = new Boolean(true);
        }
        if (l != null && bl != null && l2 != null) {
            return new templateInfo(l, l2, bl, f);
        }
        PlatformMessenger.debug("field missing from template info (" + map + ")");
        return null;
    }

    public static void setTemplatetSelected(String string, long l, String string2, boolean bl) throws PlatformMessengerException {
        Map map = PlatformMetaSearchMessenger.getParameter(l);
        if (string != null) {
            map.put("extension_key", string);
        }
        map.put("userId", string2);
        map.put("selected", new Boolean(bl));
        dispatcher.syncInvoke(OP_TEMPLATE_SELECTED, map);
    }

    protected static Map getParameter(long l) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("templateId", new Long(l));
        return hashMap;
    }

    public static class templateDetails {
        public static final int ENGINE_TYPE_JSON = 1;
        public static final int ENGINE_TYPE_REGEXP = 2;
        private templateInfo info;
        private int type;
        private String name;
        private String value;

        protected templateDetails(templateInfo templateInfo2, int n, String string, String string2) {
            this.info = templateInfo2;
            this.type = n;
            this.name = string;
            this.value = string2;
        }

        public int getType() {
            return this.type;
        }

        public long getId() {
            return this.info.getId();
        }

        public long getModifiedDate() {
            return this.info.getModifiedDate();
        }

        public float getRankBias() {
            return this.info.getRankBias();
        }

        public boolean isVisible() {
            return this.info.isVisible();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class templateInfo {
        private long id;
        private long date;
        private boolean visible;
        private float rank_bias;

        protected templateInfo(long l, long l2, boolean bl, float f) {
            this.id = l;
            this.date = l2;
            this.visible = bl;
            this.rank_bias = f;
        }

        public long getId() {
            return this.id;
        }

        public long getModifiedDate() {
            return this.date;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public float getRankBias() {
            return this.rank_bias;
        }
    }
}

