/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class LWSTorrent
extends LogRelation
implements TOTorrent {
    private static TOTorrentAnnounceURLGroup announce_group = new TOTorrentAnnounceURLGroup(){
        private TOTorrentAnnounceURLSet[] sets = new TOTorrentAnnounceURLSet[0];

        @Override
        public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
            return this.sets;
        }

        @Override
        public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
            this.sets = tOTorrentAnnounceURLSetArray;
        }

        @Override
        public TOTorrentAnnounceURLSet createAnnounceURLSet(final URL[] uRLArray) {
            return new TOTorrentAnnounceURLSet(){
                private URL[] urls;
                {
                    this.urls = uRLArray;
                }

                @Override
                public URL[] getAnnounceURLs() {
                    return this.urls;
                }

                @Override
                public void setAnnounceURLs(URL[] uRLArray2) {
                    this.urls = uRLArray2;
                }
            };
        }
    };
    private LightWeightSeed lws;

    private static void notSupported() {
        Debug.out("Not Supported");
    }

    protected LWSTorrent(LightWeightSeed lightWeightSeed) {
        this.lws = lightWeightSeed;
    }

    protected TOTorrent getDelegate() {
        return this.lws.getTOTorrent(true);
    }

    @Override
    public byte[] getName() {
        return this.lws.getName().getBytes();
    }

    @Override
    public String getUTF8Name() {
        return this.lws.getName();
    }

    @Override
    public boolean isSimpleTorrent() {
        return this.getDelegate().isSimpleTorrent();
    }

    @Override
    public byte[] getComment() {
        return this.getDelegate().getComment();
    }

    @Override
    public void setComment(String string) {
        this.getDelegate().setComment(string);
    }

    @Override
    public long getCreationDate() {
        return this.getDelegate().getCreationDate();
    }

    @Override
    public void setCreationDate(long l) {
        this.getDelegate().setCreationDate(l);
    }

    @Override
    public byte[] getCreatedBy() {
        return this.getDelegate().getCreatedBy();
    }

    @Override
    public void setCreatedBy(byte[] byArray) {
        this.getDelegate().setCreatedBy(byArray);
    }

    @Override
    public boolean isCreated() {
        return true;
    }

    @Override
    public URL getAnnounceURL() {
        return this.lws.getAnnounceURL();
    }

    @Override
    public boolean setAnnounceURL(URL uRL) {
        LWSTorrent.notSupported();
        return false;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return announce_group;
    }

    @Override
    public byte[][] getPieces() throws TOTorrentException {
        return this.getDelegate().getPieces();
    }

    @Override
    public void setPieces(byte[][] byArray) throws TOTorrentException {
        this.getDelegate().setPieces(byArray);
    }

    @Override
    public long getPieceLength() {
        return this.getDelegate().getPieceLength();
    }

    @Override
    public int getNumberOfPieces() {
        return this.getDelegate().getNumberOfPieces();
    }

    @Override
    public long getSize() {
        return this.lws.getSize();
    }

    @Override
    public TOTorrentFile[] getFiles() {
        return this.getDelegate().getFiles();
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        return this.lws.getHash().getBytes();
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.lws.getHash();
    }

    @Override
    public void setHashOverride(byte[] byArray) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    @Override
    public boolean hasSameHashAs(TOTorrent tOTorrent) {
        try {
            byte[] byArray = tOTorrent.getHash();
            return Arrays.equals(this.getHash(), byArray);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return false;
        }
    }

    @Override
    public boolean getPrivate() {
        return false;
    }

    @Override
    public void setPrivate(boolean bl) throws TOTorrentException {
        LWSTorrent.notSupported();
    }

    @Override
    public void setAdditionalStringProperty(String string, String string2) {
        this.getDelegate().setAdditionalStringProperty(string, string2);
    }

    @Override
    public String getAdditionalStringProperty(String string) {
        return this.getDelegate().getAdditionalStringProperty(string);
    }

    @Override
    public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
        this.getDelegate().setAdditionalByteArrayProperty(string, byArray);
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String string) {
        return this.getDelegate().getAdditionalByteArrayProperty(string);
    }

    @Override
    public void setAdditionalLongProperty(String string, Long l) {
        this.getDelegate().setAdditionalLongProperty(string, l);
    }

    @Override
    public Long getAdditionalLongProperty(String string) {
        return this.getDelegate().getAdditionalLongProperty(string);
    }

    @Override
    public void setAdditionalListProperty(String string, List list) {
        this.getDelegate().setAdditionalListProperty(string, list);
    }

    @Override
    public List getAdditionalListProperty(String string) {
        return this.getDelegate().getAdditionalListProperty(string);
    }

    @Override
    public void setAdditionalMapProperty(String string, Map map) {
        this.getDelegate().setAdditionalMapProperty(string, map);
    }

    @Override
    public Map getAdditionalMapProperty(String string) {
        return this.getDelegate().getAdditionalMapProperty(string);
    }

    @Override
    public Object getAdditionalProperty(String string) {
        if (string.equals("url-list") || string.equals("httpseeds")) {
            return null;
        }
        return this.getDelegate().getAdditionalProperty(string);
    }

    @Override
    public void setAdditionalProperty(String string, Object object) {
        this.getDelegate().setAdditionalProperty(string, object);
    }

    @Override
    public void removeAdditionalProperty(String string) {
        this.getDelegate().removeAdditionalProperty(string);
    }

    @Override
    public void removeAdditionalProperties() {
        this.getDelegate().removeAdditionalProperties();
    }

    @Override
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        this.getDelegate().serialiseToBEncodedFile(file);
    }

    @Override
    public void addListener(TOTorrentListener tOTorrentListener) {
        this.getDelegate().addListener(tOTorrentListener);
    }

    @Override
    public void removeListener(TOTorrentListener tOTorrentListener) {
        this.getDelegate().removeListener(tOTorrentListener);
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        return this.getDelegate().serialiseToMap();
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
        this.getDelegate().serialiseToXMLFile(file);
    }

    @Override
    public AEMonitor getMonitor() {
        return this.getDelegate().getMonitor();
    }

    @Override
    public void print() {
        this.getDelegate().print();
    }

    @Override
    public String getRelationText() {
        return "LWTorrent: '" + new String(this.getName()) + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.lws};
    }
}

