/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskAccessControllerInstance {
    private final int aggregation_request_limit;
    private final int aggregation_byte_limit;
    private String name;
    private boolean enable_aggregation;
    private boolean invert_threads = !COConfigurationManager.getBooleanParameter("diskmanager.perf.queue.torrent.bias");
    private int max_threads;
    private int max_mb_queued;
    private groupSemaphore max_mb_sem;
    private long request_bytes_queued;
    private long requests_queued;
    private long total_requests;
    private long total_single_requests_made;
    private long total_aggregated_requests_made;
    private long total_bytes;
    private long total_single_bytes;
    private long total_aggregated_bytes;
    private long io_time;
    private long io_count;
    private requestDispatcher[] dispatchers;
    private long last_check = 0L;
    private Map torrent_dispatcher_map = new HashMap();
    private static final int REQUEST_NUM_LOG_CHUNK = 100;
    private static final int REQUEST_BYTE_LOG_CHUNK = 0x100000;
    private int next_request_num_log = 100;
    private long next_request_byte_log = 0x100000L;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return null;
        }
    };

    public DiskAccessControllerInstance(String string, boolean bl, int n, int n2, int n3, int n4) {
        this.name = string;
        this.enable_aggregation = bl;
        this.aggregation_request_limit = n;
        this.aggregation_byte_limit = n2;
        this.max_mb_queued = n4;
        this.max_mb_sem = new groupSemaphore(this.max_mb_queued);
        this.max_threads = n3;
        this.dispatchers = new requestDispatcher[this.invert_threads ? 1 : this.max_threads];
        for (int i = 0; i < this.dispatchers.length; ++i) {
            this.dispatchers[i] = new requestDispatcher(i);
        }
    }

    protected String getName() {
        return this.name;
    }

    protected long getBlockCount() {
        return this.max_mb_sem.getBlockCount();
    }

    protected long getQueueSize() {
        return this.requests_queued;
    }

    protected long getQueuedBytes() {
        return this.request_bytes_queued;
    }

    protected long getTotalRequests() {
        return this.total_requests;
    }

    protected long getTotalSingleRequests() {
        return this.total_single_requests_made;
    }

    protected long getTotalAggregatedRequests() {
        return this.total_aggregated_requests_made;
    }

    public long getTotalBytes() {
        return this.total_bytes;
    }

    public long getTotalSingleBytes() {
        return this.total_single_bytes;
    }

    public long getTotalAggregatedBytes() {
        return this.total_aggregated_bytes;
    }

    public long getIOTime() {
        return this.io_time;
    }

    public long getIOCount() {
        return this.io_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueRequest(DiskAccessRequestImpl diskAccessRequestImpl) {
        requestDispatcher requestDispatcher2;
        if (this.dispatchers.length == 1) {
            requestDispatcher2 = this.dispatchers[0];
        } else {
            Map map = this.torrent_dispatcher_map;
            synchronized (map) {
                Object object;
                long l = System.currentTimeMillis();
                boolean bl = false;
                if (l - this.last_check > 60000L || l < this.last_check) {
                    bl = true;
                    this.last_check = l;
                }
                if (bl) {
                    object = this.torrent_dispatcher_map.values().iterator();
                    while (object.hasNext()) {
                        requestDispatcher requestDispatcher3 = (requestDispatcher)object.next();
                        long l2 = requestDispatcher3.getLastRequestTime();
                        if (l - l2 > 60000L) {
                            object.remove();
                            continue;
                        }
                        if (l >= l2) continue;
                        requestDispatcher3.setLastRequestTime(l);
                    }
                }
                if ((requestDispatcher2 = (requestDispatcher)this.torrent_dispatcher_map.get(object = diskAccessRequestImpl.getFile().getTorrentFile().getTorrent())) == null) {
                    int n = 0;
                    int n2 = Integer.MAX_VALUE;
                    for (int i = 0; i < this.dispatchers.length; ++i) {
                        int n3 = this.dispatchers[i].size();
                        if (n3 == 0) {
                            n = i;
                            break;
                        }
                        if (n3 >= n2) continue;
                        n2 = n3;
                        n = i;
                    }
                    requestDispatcher2 = this.dispatchers[n];
                    this.torrent_dispatcher_map.put(object, requestDispatcher2);
                }
                requestDispatcher2.setLastRequestTime(l);
            }
        }
        requestDispatcher2.queue(diskAccessRequestImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSpaceAllowance(DiskAccessRequestImpl diskAccessRequestImpl) {
        int n;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int n2 = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued += (long)diskAccessRequestImpl.getSize();
            int n3 = (int)(this.request_bytes_queued / 0x100000L);
            n = n3 - n2;
            if (n > this.max_mb_queued) {
                this.max_mb_sem.releaseGroup(n - this.max_mb_queued);
                this.max_mb_queued = n;
            }
            ++this.requests_queued;
            if (this.requests_queued >= (long)this.next_request_num_log) {
                this.next_request_num_log += 100;
            }
            if (this.request_bytes_queued >= this.next_request_byte_log) {
                this.next_request_byte_log += 0x100000L;
            }
        }
        if (n > 0) {
            this.max_mb_sem.reserveGroup(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSpaceAllowance(DiskAccessRequestImpl diskAccessRequestImpl) {
        int n;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int n2 = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued -= (long)diskAccessRequestImpl.getSize();
            int n3 = (int)(this.request_bytes_queued / 0x100000L);
            n = n2 - n3;
            --this.requests_queued;
        }
        if (n > 0) {
            this.max_mb_sem.releaseGroup(n);
        }
    }

    protected String getString() {
        return this.name + ",agg=" + this.enable_aggregation + ",max_t=" + this.max_threads + ",max_mb=" + this.max_mb_queued + ",q_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.request_bytes_queued) + ",q_req=" + this.requests_queued + ",t_req=" + this.total_requests + ",t_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.total_bytes) + ",io=" + this.io_count;
    }

    public static void main(String[] stringArray) {
        final groupSemaphore groupSemaphore2 = new groupSemaphore(9);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                @Override
                public void run() {
                    int n = 0;
                    while (true) {
                        int n2 = RandomUtils.generateRandomIntUpto(10);
                        System.out.println(Thread.currentThread().getName() + " reserving " + n2);
                        groupSemaphore2.reserveGroup(n2);
                        try {
                            Thread.sleep(5 + RandomUtils.generateRandomIntUpto(5));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        groupSemaphore2.releaseGroup(n2);
                        if (++n % 100 != 0) continue;
                        System.out.println(Thread.currentThread().getName() + ": " + n + " ops");
                    }
                }
            }.start();
        }
    }

    protected static class groupSemaphore {
        private int value;
        private List waiters = new LinkedList();
        private long blocks;

        protected groupSemaphore(int n) {
            this.value = n;
        }

        protected long getBlockCount() {
            return this.blocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reserveGroup(int n) {
            mutableInteger mutableInteger2;
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (n <= this.value && this.waiters.size() == 0) {
                    this.value -= n;
                    return;
                }
                ++this.blocks;
                mutableInteger2 = new mutableInteger(n - this.value);
                this.value = 0;
                this.waiters.add(mutableInteger2);
            }
            mutableInteger2.reserve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseGroup(int n) {
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (this.waiters.size() == 0) {
                    this.value += n;
                } else {
                    while (this.waiters.size() > 0) {
                        mutableInteger mutableInteger2 = (mutableInteger)this.waiters.get(0);
                        int n2 = mutableInteger2.getValue();
                        if (n2 <= n) {
                            mutableInteger2.release();
                            this.waiters.remove(0);
                            n -= n2;
                            continue;
                        }
                        mutableInteger2.setValue(n2 - n);
                        n = 0;
                        break;
                    }
                    this.value = n;
                }
            }
        }

        protected static class mutableInteger {
            private int i;
            private boolean released;

            protected mutableInteger(int n) {
                this.i = n;
            }

            protected int getValue() {
                return this.i;
            }

            protected void setValue(int n) {
                this.i = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void release() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    this.released = true;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void reserve() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    if (this.released) {
                        return;
                    }
                    try {
                        int n = 0;
                        while (true) {
                            this.wait();
                            if (!this.released) {
                                if (++n > 1024) {
                                    Debug.out("DAC::mutableInteger: spurious wakeup limit exceeded");
                                    throw new RuntimeException("die die die");
                                }
                                Debug.out("DAC::mutableInteger: spurious wakeup, ignoring");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException("Semaphore: operation interrupted");
                    }
                }
            }
        }
    }

    protected class requestDispatcher {
        private int index;
        private AEThread2[] threads;
        private int active_threads;
        private LinkedList requests;
        private Map request_map;
        private long last_request_map_tidy;
        private AESemaphore request_sem;
        private AESemaphore schedule_sem;
        private long last_request_time;

        protected requestDispatcher(int n) {
            this.threads = new AEThread2[DiskAccessControllerInstance.this.invert_threads ? DiskAccessControllerInstance.this.max_threads : 1];
            this.requests = new LinkedList();
            this.request_map = new HashMap();
            this.request_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:request");
            this.schedule_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:schedule", 1);
            this.index = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void queue(DiskAccessRequestImpl diskAccessRequestImpl) {
            if (tls.get() != null) {
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    DiskAccessControllerInstance.this.total_requests++;
                    DiskAccessControllerInstance.this.total_single_requests_made++;
                    DiskAccessControllerInstance.this.total_bytes += diskAccessRequestImpl.getSize();
                    DiskAccessControllerInstance.this.total_single_bytes += diskAccessRequestImpl.getSize();
                }
                try {
                    diskAccessRequestImpl.runRequest();
                }
                catch (Throwable throwable) {
                    DiskAccessControllerInstance.this.io_count++;
                    Debug.printStackTrace(throwable);
                }
            } else {
                DiskAccessControllerInstance.this.getSpaceAllowance(diskAccessRequestImpl);
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    DiskAccessControllerInstance.this.total_requests++;
                    DiskAccessControllerInstance.this.total_bytes += diskAccessRequestImpl.getSize();
                    boolean bl = false;
                    int n = diskAccessRequestImpl.getPriority();
                    if (n >= 0) {
                        int n2 = 0;
                        for (DiskAccessRequestImpl diskAccessRequestImpl2 : this.requests) {
                            if (diskAccessRequestImpl2.getPriority() < n) {
                                this.requests.add(n2, diskAccessRequestImpl);
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!bl) {
                        this.requests.add(diskAccessRequestImpl);
                    }
                    if (DiskAccessControllerInstance.this.enable_aggregation) {
                        HashMap<Long, DiskAccessRequestImpl> hashMap = (HashMap<Long, DiskAccessRequestImpl>)this.request_map.get(diskAccessRequestImpl.getFile());
                        if (hashMap == null) {
                            hashMap = new HashMap<Long, DiskAccessRequestImpl>();
                            this.request_map.put(diskAccessRequestImpl.getFile(), hashMap);
                        }
                        hashMap.put(new Long(diskAccessRequestImpl.getOffset()), diskAccessRequestImpl);
                        long l = SystemTime.getCurrentTime();
                        if (l < this.last_request_map_tidy || l - this.last_request_map_tidy > 30000L) {
                            this.last_request_map_tidy = l;
                            Iterator iterator = this.request_map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                if (((HashMap)entry.getValue()).size() != 0 || ((CacheFile)entry.getKey()).isOpen()) continue;
                                iterator.remove();
                            }
                        }
                    }
                    this.request_sem.release();
                    this.requestQueued();
                }
            }
        }

        protected long getLastRequestTime() {
            return this.last_request_time;
        }

        protected void setLastRequestTime(long l) {
            this.last_request_time = l;
        }

        protected int size() {
            return this.requests.size();
        }

        protected void requestQueued() {
            if (this.active_threads < this.threads.length && (this.active_threads == 0 || this.requests.size() > 32)) {
                for (int i = 0; i < this.threads.length; ++i) {
                    if (this.threads[i] != null) continue;
                    ++this.active_threads;
                    final int n = i;
                    this.threads[n] = new AEThread2("DiskAccessController:dispatch(" + DiskAccessControllerInstance.this.getName() + ")[" + this.index + "/" + n + "]", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            tls.set(this);
                            block20: while (true) {
                                Object object;
                                ArrayList<DiskAccessRequestImpl> arrayList;
                                DiskAccessRequestImpl diskAccessRequestImpl;
                                block37: {
                                    diskAccessRequestImpl = null;
                                    arrayList = null;
                                    try {
                                        if (DiskAccessControllerInstance.this.invert_threads) {
                                            requestDispatcher.this.schedule_sem.reserve();
                                        }
                                        if (!requestDispatcher.this.request_sem.reserve(30000L)) break block37;
                                        LinkedList linkedList = requestDispatcher.this.requests;
                                        synchronized (linkedList) {
                                            diskAccessRequestImpl = (DiskAccessRequestImpl)requestDispatcher.this.requests.remove(0);
                                            if (DiskAccessControllerInstance.this.enable_aggregation) {
                                                CacheFile cacheFile = diskAccessRequestImpl.getFile();
                                                object = (Map)requestDispatcher.this.request_map.get(cacheFile);
                                                if (object == null) {
                                                    object = new HashMap();
                                                }
                                                object.remove(new Long(diskAccessRequestImpl.getOffset()));
                                                if (diskAccessRequestImpl.getPriority() < 0 && !diskAccessRequestImpl.isCancelled()) {
                                                    DiskAccessRequestImpl diskAccessRequestImpl2 = diskAccessRequestImpl;
                                                    long l = 0L;
                                                    try {
                                                        while (true) {
                                                            int n2 = diskAccessRequestImpl2.getSize();
                                                            long l2 = diskAccessRequestImpl2.getOffset() + (long)n2;
                                                            DiskAccessRequestImpl diskAccessRequestImpl3 = (DiskAccessRequestImpl)object.remove(new Long(l2));
                                                            if (diskAccessRequestImpl3 == null || diskAccessRequestImpl3.isCancelled()) break;
                                                            if (!diskAccessRequestImpl3.canBeAggregatedWith(diskAccessRequestImpl)) {
                                                                break;
                                                            }
                                                            requestDispatcher.this.requests.remove(diskAccessRequestImpl3);
                                                            if (!requestDispatcher.this.request_sem.reserve(30000L)) {
                                                                Debug.out("shouldn't happen");
                                                            }
                                                            if (arrayList == null) {
                                                                arrayList = new ArrayList<DiskAccessRequestImpl>(8);
                                                                arrayList.add(diskAccessRequestImpl2);
                                                                l += (long)n2;
                                                            }
                                                            arrayList.add(diskAccessRequestImpl3);
                                                            l += (long)diskAccessRequestImpl3.getSize();
                                                            if (arrayList.size() > DiskAccessControllerInstance.this.aggregation_request_limit) break;
                                                            if (l >= (long)DiskAccessControllerInstance.this.aggregation_byte_limit) {
                                                                break;
                                                            }
                                                            diskAccessRequestImpl2 = diskAccessRequestImpl3;
                                                        }
                                                    }
                                                    finally {
                                                        if (arrayList != null) {
                                                            DiskAccessControllerInstance.this.total_aggregated_requests_made++;
                                                        } else {
                                                            DiskAccessControllerInstance.this.total_single_requests_made++;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        if (DiskAccessControllerInstance.this.invert_threads) {
                                            requestDispatcher.this.schedule_sem.release();
                                        }
                                    }
                                }
                                try {
                                    long l = SystemTime.getHighPrecisionCounter();
                                    if (arrayList != null) {
                                        object = arrayList.toArray(new DiskAccessRequestImpl[arrayList.size()]);
                                        try {
                                            DiskAccessRequestImpl.runAggregated(diskAccessRequestImpl, (DiskAccessRequestImpl[])object);
                                        }
                                        finally {
                                            long l3 = SystemTime.getHighPrecisionCounter();
                                            DiskAccessControllerInstance.this.io_time += l3 - l;
                                            DiskAccessControllerInstance.this.io_count++;
                                            int n3 = 0;
                                            while (true) {
                                                if (n3 >= ((DiskAccessRequestImpl[])object).length) continue block20;
                                                DiskAccessRequestImpl diskAccessRequestImpl4 = object[n3];
                                                DiskAccessControllerInstance.this.total_aggregated_bytes += diskAccessRequestImpl4.getSize();
                                                DiskAccessControllerInstance.this.releaseSpaceAllowance(diskAccessRequestImpl4);
                                                ++n3;
                                            }
                                        }
                                    }
                                    if (diskAccessRequestImpl != null) {
                                        try {
                                            diskAccessRequestImpl.runRequest();
                                            continue;
                                        }
                                        finally {
                                            long l4 = SystemTime.getHighPrecisionCounter();
                                            DiskAccessControllerInstance.this.io_time += l4 - l;
                                            DiskAccessControllerInstance.this.io_count++;
                                            DiskAccessControllerInstance.this.total_single_bytes += diskAccessRequestImpl.getSize();
                                            DiskAccessControllerInstance.this.releaseSpaceAllowance(diskAccessRequestImpl);
                                            continue;
                                        }
                                    }
                                    object = requestDispatcher.this.requests;
                                    synchronized (object) {
                                        if (requestDispatcher.this.requests.size() == 0) {
                                            ((requestDispatcher)requestDispatcher.this).threads[n] = null;
                                            requestDispatcher.this.active_threads--;
                                            break;
                                        }
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                    continue;
                                }
                                break;
                            }
                        }
                    };
                    this.threads[n].start();
                    break;
                }
            }
        }
    }
}

