/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeManagerListener;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeProviderVuze;
import com.aelitis.azureus.core.devices.impl.TranscodeQueueImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class TranscodeManagerImpl
implements TranscodeManager {
    private DeviceManagerImpl device_manager;
    private AzureusCore azureus_core;
    private TranscodeProviderVuze vuzexcode_provider;
    private CopyOnWriteList<TranscodeManagerListener> listeners = new CopyOnWriteList();
    private TranscodeQueueImpl queue = new TranscodeQueueImpl(this);
    private AESemaphore init_sem = new AESemaphore("TM:init");
    private boolean hooked_categories;
    private Map<Category, Object[]> category_map = new HashMap<Category, Object[]>();
    private CategoryListener category_listener;
    private TorrentAttribute category_ta;

    protected TranscodeManagerImpl(DeviceManagerImpl deviceManagerImpl) {
        this.device_manager = deviceManagerImpl;
        this.azureus_core = AzureusCoreFactory.getSingleton();
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        this.category_ta = pluginInterface.getTorrentManager().getPluginAttribute("xcode.cat.done");
        pluginInterface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                PluginInterface[] pluginInterfaceArray;
                PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
                pluginInterface.addEventListener(new PluginEventListener(){

                    @Override
                    public void handleEvent(PluginEvent pluginEvent) {
                        int n = pluginEvent.getType();
                        if (n == 8) {
                            TranscodeManagerImpl.this.pluginAdded((PluginInterface)pluginEvent.getValue());
                        }
                        if (n == 9) {
                            TranscodeManagerImpl.this.pluginRemoved((PluginInterface)pluginEvent.getValue());
                        }
                    }
                });
                for (PluginInterface pluginInterface2 : pluginInterfaceArray = pluginInterface.getPluginManager().getPlugins()) {
                    if (!pluginInterface2.getPluginState().isOperational()) continue;
                    TranscodeManagerImpl.this.pluginAdded(pluginInterface2);
                }
                TranscodeManagerImpl.this.queue.initialise();
                TranscodeManagerImpl.this.init_sem.releaseForever();
            }

            @Override
            public void closedownInitiated() {
                TranscodeManagerImpl.this.init_sem.releaseForever();
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pluginInterface) {
        block13: {
            TranscodeProviderVuze transcodeProviderVuze;
            boolean bl;
            block14: {
                if (pluginInterface.getPluginState().isBuiltIn()) {
                    return;
                }
                String string = pluginInterface.getPluginID();
                if (!string.equals("vuzexcode")) break block13;
                boolean bl2 = false;
                bl = false;
                transcodeProviderVuze = null;
                Iterator<TranscodeManagerListener> iterator = this;
                synchronized (iterator) {
                    if (this.vuzexcode_provider == null) {
                        transcodeProviderVuze = this.vuzexcode_provider = new TranscodeProviderVuze(this, pluginInterface);
                        bl2 = true;
                    } else if (pluginInterface != this.vuzexcode_provider) {
                        transcodeProviderVuze = this.vuzexcode_provider;
                        this.vuzexcode_provider.update(pluginInterface);
                        bl = true;
                    }
                }
                if (!bl2) break block14;
                for (TranscodeManagerListener transcodeManagerListener : this.listeners) {
                    try {
                        transcodeManagerListener.providerAdded(transcodeProviderVuze);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
                break block13;
            }
            if (!bl) break block13;
            for (TranscodeManagerListener transcodeManagerListener : this.listeners) {
                try {
                    transcodeManagerListener.providerUpdated(transcodeProviderVuze);
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pluginInterface) {
        String string = pluginInterface.getPluginID();
        if (string.equals("vuzexcode")) {
            TranscodeProviderVuze transcodeProviderVuze = null;
            TranscodeManagerImpl transcodeManagerImpl = this;
            synchronized (transcodeManagerImpl) {
                if (this.vuzexcode_provider != null) {
                    transcodeProviderVuze = this.vuzexcode_provider;
                    this.vuzexcode_provider.destroy();
                    this.vuzexcode_provider = null;
                }
            }
            if (transcodeProviderVuze != null) {
                for (TranscodeManagerListener transcodeManagerListener : this.listeners) {
                    try {
                        transcodeManagerListener.providerRemoved(transcodeProviderVuze);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
            }
        }
    }

    protected void updateStatus(int n) {
        if (this.queue != null) {
            this.queue.updateStatus(n);
            if (!this.hooked_categories) {
                this.hooked_categories = true;
                CategoryManager.addCategoryManagerListener(new CategoryManagerListener(){

                    @Override
                    public void categoryAdded(Category category) {
                    }

                    @Override
                    public void categoryRemoved(Category category) {
                    }

                    @Override
                    public void categoryChanged(Category category) {
                        TranscodeManagerImpl.this.checkCategories();
                    }
                });
                this.checkCategories();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCategories() {
        Object object;
        Object object2;
        Object[] objectArray;
        Object object32;
        Category[] categoryArray = CategoryManager.getCategories();
        HashMap<Category, Object[]> hashMap = new HashMap<Category, Object[]>();
        for (Category object4 : categoryArray) {
            object32 = object4.getStringAttribute("at_att");
            if (object32 == null) continue;
            objectArray = null;
            if (((String)object32).endsWith("/blank")) {
                objectArray = ((String)object32).substring(0, ((String)object32).length() - 6);
            }
            object2 = null;
            object = null;
            block4: for (DeviceImpl deviceImpl : this.device_manager.getDevices()) {
                TranscodeProfile[] transcodeProfileArray;
                if (!(deviceImpl instanceof DeviceMediaRenderer)) continue;
                DeviceMediaRenderer deviceMediaRenderer = (DeviceMediaRenderer)((Object)deviceImpl);
                if (objectArray != null) {
                    if (!deviceImpl.getID().equals(objectArray)) continue;
                    object2 = deviceMediaRenderer;
                    object = deviceImpl.getBlankProfile();
                    break;
                }
                for (TranscodeProfile transcodeProfile : transcodeProfileArray = deviceImpl.getTranscodeProfiles()) {
                    if (!transcodeProfile.getUID().equals(object32)) continue;
                    object2 = deviceMediaRenderer;
                    object = transcodeProfile;
                    continue block4;
                }
            }
            if (object2 == null) continue;
            hashMap.put(object4, new Object[]{object2, object});
        }
        HashMap hashMap2 = new HashMap();
        Object object5 = this.category_map;
        synchronized (object5) {
            if (this.category_listener == null) {
                this.category_listener = new CategoryListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadManagerAdded(Category category, DownloadManager downloadManager) {
                        Object[] objectArray;
                        Map map = TranscodeManagerImpl.this.category_map;
                        synchronized (map) {
                            objectArray = (Object[])TranscodeManagerImpl.this.category_map.get(category);
                        }
                        if (objectArray != null) {
                            TranscodeManagerImpl.this.processCategory(category, objectArray, downloadManager);
                        }
                    }

                    @Override
                    public void downloadManagerRemoved(Category category, DownloadManager downloadManager) {
                    }
                };
            }
            Iterator<Object> iterator = this.category_map.keySet().iterator();
            while (iterator.hasNext()) {
                Category category = iterator.next();
                if (hashMap.containsKey(category)) continue;
                category.removeCategoryListener(this.category_listener);
                iterator.remove();
            }
            for (Object object32 : hashMap.keySet()) {
                if (this.category_map.containsKey(object32)) continue;
                hashMap2.put(object32, hashMap.get(object32));
                object32.addCategoryListener(this.category_listener);
                this.category_map.put((Category)object32, (Object[])hashMap.get(object32));
            }
        }
        if (hashMap2.size() > 0) {
            object5 = this.azureus_core.getGlobalManager().getDownloadManagers();
            for (Map.Entry entry : hashMap2.entrySet()) {
                object32 = (Category)entry.getKey();
                objectArray = (Object[])entry.getValue();
                object2 = object32.getDownloadManagers((List)object5);
                object = object2.iterator();
                while (object.hasNext()) {
                    DownloadManager downloadManager = (DownloadManager)object.next();
                    this.processCategory((Category)object32, objectArray, downloadManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCategory(Category category, Object[] objectArray, DownloadManager downloadManager) {
        Download download = PluginCoreUtils.wrap(downloadManager);
        String string = download.getAttribute(this.category_ta);
        String string2 = category.getName();
        if (category.getType() == 2) {
            string2 = "<none>";
        }
        String string3 = string2 + ";";
        if (string != null && string.contains(string3)) {
            return;
        }
        try {
            DeviceMediaRenderer deviceMediaRenderer = (DeviceMediaRenderer)objectArray[0];
            TranscodeProfile transcodeProfile = (TranscodeProfile)objectArray[1];
            this.log("Category " + string2 + " - adding " + download.getName() + " to " + deviceMediaRenderer.getName() + "/" + transcodeProfile.getName());
            DiskManagerFileInfo[] diskManagerFileInfoArray = download.getDiskManagerFileInfo();
            int n = 0;
            for (DiskManagerFileInfo diskManagerFileInfo : diskManagerFileInfoArray) {
                if (n > 64) break;
                if (diskManagerFileInfoArray.length != 1 && diskManagerFileInfo.getLength() < 131072L) continue;
                try {
                    this.queue.add(deviceMediaRenderer, transcodeProfile, diskManagerFileInfo, false);
                    ++n;
                }
                catch (Throwable throwable) {
                    this.log("    add failed", throwable);
                }
            }
            download.setAttribute(this.category_ta, string == null ? string3 : string + string3);
        }
        catch (Throwable throwable) {
            download.setAttribute(this.category_ta, string == null ? string3 : string + string3);
            throw throwable;
        }
    }

    @Override
    public TranscodeProvider[] getProviders() {
        TranscodeProviderVuze transcodeProviderVuze = this.vuzexcode_provider;
        if (transcodeProviderVuze == null) {
            return new TranscodeProvider[0];
        }
        return new TranscodeProvider[]{transcodeProviderVuze};
    }

    protected TranscodeProfile getProfileFromUID(String string) {
        for (TranscodeProvider transcodeProvider : this.getProviders()) {
            TranscodeProfile transcodeProfile = transcodeProvider.getProfile(string);
            if (transcodeProfile == null) continue;
            return transcodeProfile;
        }
        return null;
    }

    @Override
    public TranscodeQueueImpl getQueue() {
        if (!this.init_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
        return this.queue;
    }

    protected DeviceManagerImpl getManager() {
        return this.device_manager;
    }

    protected TranscodeTarget lookupTarget(String string) throws TranscodeException {
        DeviceImpl deviceImpl = this.device_manager.getDevice(string);
        if (deviceImpl instanceof TranscodeTarget) {
            return (TranscodeTarget)((Object)deviceImpl);
        }
        throw new TranscodeException("Transcode target with id " + string + " not found");
    }

    protected DiskManagerFileInfo lookupFile(byte[] byArray, int n) throws TranscodeException {
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(byArray);
            if (download == null) {
                throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(byArray) + " not found");
            }
            return download.getDiskManagerFileInfo()[n];
        }
        catch (Throwable throwable) {
            throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(byArray) + " not found", throwable);
        }
    }

    protected void close() {
        this.queue.close();
    }

    @Override
    public void addListener(TranscodeManagerListener transcodeManagerListener) {
        this.listeners.add(transcodeManagerListener);
    }

    @Override
    public void removeListener(TranscodeManagerListener transcodeManagerListener) {
        this.listeners.remove(transcodeManagerListener);
    }

    protected void log(String string) {
        this.device_manager.log("Trans: " + string);
    }

    protected void log(String string, Throwable throwable) {
        this.device_manager.log("Trans: " + string, throwable);
    }

    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Transcode Manager: vuze provider=" + this.vuzexcode_provider);
        this.queue.generate(indentWriter);
    }
}

