/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class TranscodeJobOutputLeecher
implements DiskManagerFileInfo {
    private TranscodeJobImpl job;
    private TranscodeFileImpl file;
    private File save_to;
    private byte[] hash;

    public TranscodeJobOutputLeecher(TranscodeJobImpl transcodeJobImpl, TranscodeFileImpl transcodeFileImpl) throws TranscodeException {
        this.job = transcodeJobImpl;
        this.file = transcodeFileImpl;
        this.save_to = this.file.getCacheFile();
        try {
            this.hash = new SHA1Simple().calculateHash(this.save_to.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    @Override
    public void setPriority(boolean bl) {
    }

    @Override
    public int getNumericPriorty() {
        return 0;
    }

    @Override
    public void setNumericPriority(int n) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setSkipped(boolean bl) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setDeleted(boolean bl) {
    }

    @Override
    public void setLink(File file) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public File getLink() {
        return null;
    }

    @Override
    public int getAccessMode() {
        return 1;
    }

    @Override
    public long getDownloaded() {
        return this.getLength();
    }

    @Override
    public long getLength() {
        if (this.file.isComplete()) {
            try {
                return this.file.getTargetFile().getLength();
            }
            catch (Throwable throwable) {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public File getFile() {
        return this.save_to;
    }

    @Override
    public File getFile(boolean bl) {
        return this.save_to;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getFirstPieceNumber() {
        return 0;
    }

    @Override
    public long getPieceSize() {
        return 32768L;
    }

    @Override
    public int getNumPieces() {
        return -1;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public boolean isSkipped() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public byte[] getDownloadHash() throws DownloadException {
        return this.hash;
    }

    @Override
    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        return new Channel();
    }

    protected class Channel
    implements DiskManagerChannel {
        private volatile boolean channel_destroyed;
        private volatile long channel_position;
        private RandomAccessFile raf;

        protected Channel() {
        }

        @Override
        public DiskManagerRequest createRequest() {
            return new request();
        }

        @Override
        public DiskManagerFileInfo getFile() {
            return TranscodeJobOutputLeecher.this;
        }

        @Override
        public long getPosition() {
            return this.channel_position;
        }

        @Override
        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            Channel channel2 = this;
            synchronized (channel2) {
                this.channel_destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.raf = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int read(byte[] byArray, long l, int n) throws IOException {
            Channel channel2 = this;
            synchronized (channel2) {
                if (this.channel_destroyed) {
                    throw new IOException("Channel destroyed");
                }
                if (this.raf == null) {
                    if (TranscodeJobOutputLeecher.this.save_to.exists()) {
                        this.raf = new RandomAccessFile(TranscodeJobOutputLeecher.this.save_to, "r");
                    } else {
                        int n2 = TranscodeJobOutputLeecher.this.job.getState();
                        if (n2 == 7) {
                            throw new IOException("Job has been removed");
                        }
                        if (n2 == 5 || n2 == 4) {
                            throw new IOException("Job has failed or been cancelled");
                        }
                        if (n2 == 3) {
                            throw new IOException("Job is complete but file missing");
                        }
                    }
                }
                if (this.raf != null) {
                    if (this.raf.length() > l) {
                        this.raf.seek(l);
                        return this.raf.read(byArray, 0, n);
                    }
                    if (TranscodeJobOutputLeecher.this.file.isComplete()) {
                        return -1;
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                throw new IOException("Interrupted");
            }
            return 0;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean request_cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            @Override
            public void setType(int n) {
                if (n != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            @Override
            public void setOffset(long l) {
                this.offset = l;
            }

            @Override
            public void setLength(long l) {
                this.length = l == -1L ? Long.MAX_VALUE : l;
            }

            @Override
            public void setMaximumReadChunkSize(int n) {
                if (n > 16384) {
                    this.max_read_chunk = n;
                }
            }

            @Override
            public long getAvailableBytes() {
                return this.getRemaining();
            }

            @Override
            public long getRemaining() {
                return this.length == Long.MAX_VALUE ? this.length : this.offset + this.length - this.position;
            }

            @Override
            public void run() {
                try {
                    byte[] byArray = new byte[this.max_read_chunk];
                    long l = this.length;
                    long l2 = this.offset;
                    while (l > 0L) {
                        if (this.request_cancelled) {
                            throw new Exception("Cancelled");
                        }
                        if (Channel.this.channel_destroyed) {
                            throw new Exception("Destroyed");
                        }
                        int n = (int)Math.min(l, (long)this.max_read_chunk);
                        int n2 = Channel.this.read(byArray, l2, n);
                        if (n2 == -1) {
                            if (this.length != Long.MAX_VALUE) {
                                throw new Exception("Premature end of stream (complete)");
                            }
                            break;
                        }
                        if (n2 == 0) {
                            this.sendEvent(new event(l2));
                            continue;
                        }
                        this.sendEvent(new event(new PooledByteBufferImpl(byArray, 0, n2), l2, n2));
                        l -= (long)n2;
                        l2 += (long)n2;
                    }
                }
                catch (Throwable throwable) {
                    this.sendEvent(new event(throwable));
                }
            }

            @Override
            public void cancel() {
                this.request_cancelled = true;
            }

            @Override
            public void setUserAgent(String string) {
            }

            protected void sendEvent(event event2) {
                for (DiskManagerListener diskManagerListener : this.listeners) {
                    diskManagerListener.eventOccurred(event2);
                }
            }

            @Override
            public void addListener(DiskManagerListener diskManagerListener) {
                this.listeners.add(diskManagerListener);
            }

            @Override
            public void removeListener(DiskManagerListener diskManagerListener) {
                this.listeners.remove(diskManagerListener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable throwable) {
                    this.event_type = 2;
                    this.error = throwable;
                }

                protected event(long l) {
                    this.event_type = 3;
                    this.event_offset = l;
                    Channel.this.channel_position = l;
                }

                protected event(PooledByteBuffer pooledByteBuffer, long l, int n) {
                    this.event_type = 1;
                    this.buffer = pooledByteBuffer;
                    this.event_offset = l;
                    this.event_length = n;
                    Channel.this.channel_position = l + (long)n - 1L;
                }

                @Override
                public int getType() {
                    return this.event_type;
                }

                @Override
                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                @Override
                public long getOffset() {
                    return this.event_offset;
                }

                @Override
                public int getLength() {
                    return this.event_length;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                @Override
                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

