/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerUPnPImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobOutputLeecher;
import com.aelitis.azureus.core.download.DiskManagerFileInfoStream;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.UUIDGenerator;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public abstract class DeviceUPnPImpl
extends DeviceImpl
implements TranscodeTargetListener,
DownloadManagerListener {
    private static final Object UPNPAV_FILE_KEY = new Object();
    private static final Map<String, AzureusContentFile> acf_map = new WeakHashMap<String, AzureusContentFile>();
    private final String MY_ACF_KEY;
    private final DeviceManagerUPnPImpl upnp_manager;
    private volatile UPnPDevice device_may_be_null;
    private IPCInterface upnpav_ipc;
    private TranscodeProfile dynamic_transcode_profile;
    private Map<String, AzureusContentFile> dynamic_xcode_map;

    protected static String getDisplayName(UPnPDevice uPnPDevice) {
        String string;
        UPnPDevice uPnPDevice2 = uPnPDevice.getRootDevice().getDevice();
        String string2 = uPnPDevice2.getFriendlyName();
        if (string2 == null || string2.length() == 0) {
            string2 = uPnPDevice.getFriendlyName();
        }
        if ((string = uPnPDevice2.getModelName()) == null || string.length() == 0) {
            string = uPnPDevice.getModelName();
        }
        if (!(string == null || string.length() <= 0 || string2.contains(string) || string.contains("Azureus") && !string.contains("Vuze"))) {
            string2 = string2 + " (" + string + ")";
        }
        return string2;
    }

    protected DeviceUPnPImpl(DeviceManagerImpl deviceManagerImpl, UPnPDevice uPnPDevice, int n) {
        super(deviceManagerImpl, n, n + "/" + uPnPDevice.getRootDevice().getUSN(), DeviceUPnPImpl.getDisplayName(uPnPDevice), false);
        this.upnp_manager = deviceManagerImpl.getUPnPManager();
        this.device_may_be_null = uPnPDevice;
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl deviceManagerImpl, int n, String string) {
        super(deviceManagerImpl, n, UUIDGenerator.generateUUIDString(), string, true);
        this.upnp_manager = deviceManagerImpl.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl deviceManagerImpl, int n, String string, String string2, boolean bl, String string3) {
        super(deviceManagerImpl, n, string == null ? UUIDGenerator.generateUUIDString() : string, string2, bl, string3);
        this.upnp_manager = deviceManagerImpl.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl deviceManagerImpl, int n, String string, String string2, boolean bl) {
        super(deviceManagerImpl, n, string, string2, bl);
        this.upnp_manager = deviceManagerImpl.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        super(deviceManagerImpl, map);
        this.upnp_manager = deviceManagerImpl.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected String getACFKey() {
        return "DeviceUPnPImpl:device:" + this.getID();
    }

    @Override
    protected boolean updateFrom(DeviceImpl deviceImpl, boolean bl) {
        if (!super.updateFrom(deviceImpl, bl)) {
            return false;
        }
        if (!(deviceImpl instanceof DeviceUPnPImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceUPnPImpl deviceUPnPImpl = (DeviceUPnPImpl)deviceImpl;
        this.device_may_be_null = deviceUPnPImpl.device_may_be_null;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    protected void UPnPInitialised() {
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    protected DeviceManagerUPnPImpl getUPnPDeviceManager() {
        return this.upnp_manager;
    }

    protected UPnPDevice getUPnPDevice() {
        return this.device_may_be_null;
    }

    @Override
    public boolean isBrowsable() {
        return true;
    }

    @Override
    public Device.browseLocation[] getBrowseLocations() {
        ArrayList<DeviceImpl.browseLocationImpl> arrayList = new ArrayList<DeviceImpl.browseLocationImpl>();
        UPnPDevice uPnPDevice = this.device_may_be_null;
        if (uPnPDevice != null) {
            int n;
            URL uRL = this.getPresentationURL(uPnPDevice);
            if (uRL != null) {
                arrayList.add(new DeviceImpl.browseLocationImpl("device.upnp.present_url", uRL));
            }
            if ((n = COConfigurationManager.getIntParameter("User Mode")) > 1) {
                arrayList.add(new DeviceImpl.browseLocationImpl("device.upnp.desc_url", uPnPDevice.getRootDevice().getLocation()));
            }
        }
        return arrayList.toArray(new Device.browseLocation[arrayList.size()]);
    }

    public boolean canFilterFilesView() {
        return true;
    }

    public void setFilterFilesView(boolean bl) {
        boolean bl2 = this.getFilterFilesView();
        if (bl2 != bl) {
            this.setPersistentBooleanProperty("rend_filter", bl);
            IPCInterface iPCInterface = this.upnpav_ipc;
            if (iPCInterface != null) {
                try {
                    iPCInterface.invoke("invalidateDirectory", new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getFilterFilesView() {
        return this.getPersistentBooleanProperty("rend_filter", true);
    }

    @Override
    public boolean isLivenessDetectable() {
        return true;
    }

    protected URL getLocation() {
        UPnPDevice uPnPDevice = this.device_may_be_null;
        if (uPnPDevice != null) {
            UPnPRootDevice uPnPRootDevice = uPnPDevice.getRootDevice();
            return uPnPRootDevice.getLocation();
        }
        return null;
    }

    public boolean canAssociate() {
        return true;
    }

    public void associate(DeviceManager.UnassociatedDevice unassociatedDevice) {
        if (this.isAlive()) {
            return;
        }
        this.setAddress(unassociatedDevice.getAddress());
        this.alive();
    }

    public InetAddress getAddress() {
        try {
            UPnPDevice uPnPDevice = this.device_may_be_null;
            if (uPnPDevice != null) {
                UPnPRootDevice uPnPRootDevice = uPnPDevice.getRootDevice();
                URL uRL = uPnPRootDevice.getLocation();
                return InetAddress.getByName(uRL.getHost());
            }
            InetAddress inetAddress = (InetAddress)this.getTransientProperty("DeviceUPnPImpl:ip");
            if (inetAddress != null) {
                return inetAddress;
            }
            String string = this.getPersistentStringProperty("rend_ip");
            if (string != null && string.length() > 0) {
                return InetAddress.getByName(string);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return null;
    }

    protected void setAddress(InetAddress inetAddress) {
        this.setTransientProperty("DeviceUPnPImpl:ip", inetAddress);
        this.setPersistentStringProperty("rend_ip", inetAddress.getHostAddress());
    }

    protected URL getStreamURL(TranscodeFileImpl transcodeFileImpl) {
        this.browseReceived();
        return super.getStreamURL(transcodeFileImpl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void browseReceived() {
        Object object;
        IPCInterface iPCInterface = this.upnp_manager.getUPnPAVIPC();
        if (iPCInterface == null) {
            return;
        }
        TranscodeProfile transcodeProfile = this.getDefaultTranscodeProfile();
        if (transcodeProfile == null) {
            for (TranscodeProfile transcodeProfile2 : object = this.getTranscodeProfiles()) {
                if (!transcodeProfile2.isStreamable()) continue;
                transcodeProfile = transcodeProfile2;
                break;
            }
        }
        object = this;
        synchronized (object) {
            if (this.upnpav_ipc != null) {
                return;
            }
            this.upnpav_ipc = iPCInterface;
            if (transcodeProfile != null && transcodeProfile.isStreamable()) {
                this.dynamic_transcode_profile = transcodeProfile;
            }
        }
        if (this.dynamic_transcode_profile != null && this instanceof TranscodeTarget) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                @Override
                public void azureusCoreRunning(AzureusCore azureusCore) {
                    DownloadManager downloadManager = PluginInitializer.getDefaultInterface().getDownloadManager();
                    downloadManager.addListener(DeviceUPnPImpl.this, true);
                }
            });
        }
        this.addListener(this);
        for (TranscodeProfile transcodeProfile2 : object = this.getFiles()) {
            this.fileAdded((TranscodeFile)((Object)transcodeProfile2), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUPNPAV() {
        DeviceUPnPImpl deviceUPnPImpl = this;
        synchronized (deviceUPnPImpl) {
            TranscodeFileImpl[] transcodeFileImplArray;
            if (this.upnpav_ipc == null) {
                return;
            }
            this.upnpav_ipc = null;
            this.dynamic_transcode_profile = null;
            this.dynamic_xcode_map = null;
            DownloadManager downloadManager = PluginInitializer.getDefaultInterface().getDownloadManager();
            downloadManager.removeListener(this);
            this.removeListener(this);
            for (TranscodeFileImpl transcodeFileImpl : transcodeFileImplArray = this.getFiles()) {
                transcodeFileImpl.setTransientProperty(UPNPAV_FILE_KEY, null);
            }
        }
    }

    @Override
    public void downloadAdded(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && PlatformTorrentUtils.isContent(torrent, false)) {
            this.addDynamicXCode(download.getDiskManagerFileInfo()[0]);
        }
    }

    @Override
    public void downloadRemoved(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && PlatformTorrentUtils.isContent(torrent, false)) {
            this.removeDynamicXCode(download.getDiskManagerFileInfo()[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDynamicXCode(final DiskManagerFileInfo diskManagerFileInfo) {
        final TranscodeProfile transcodeProfile = this.dynamic_transcode_profile;
        IPCInterface iPCInterface = this.upnpav_ipc;
        if (transcodeProfile == null || iPCInterface == null) {
            return;
        }
        try {
            TranscodeFileImpl transcodeFileImpl = this.allocateFile(transcodeProfile, false, diskManagerFileInfo, false);
            AzureusContentFile azureusContentFile = (AzureusContentFile)transcodeFileImpl.getTransientProperty(UPNPAV_FILE_KEY);
            if (azureusContentFile != null) {
                return;
            }
            String string = transcodeFileImpl.getKey();
            Object object = acf_map;
            synchronized (object) {
                azureusContentFile = acf_map.get(string);
            }
            if (azureusContentFile != null) {
                return;
            }
            object = new DiskManagerFileInfoStream(new DiskManagerFileInfoStream.StreamFactory(){
                private List<Object> current_requests = new ArrayList<Object>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public DiskManagerFileInfoStream.StreamFactory.StreamDetails getStream(Object object) throws IOException {
                    2 var5_8;
                    StreamWrapper streamWrapper;
                    try {
                        TranscodeJobImpl transcodeJobImpl = DeviceUPnPImpl.this.getManager().getTranscodeManager().getQueue().add((TranscodeTarget)((Object)DeviceUPnPImpl.this), transcodeProfile, diskManagerFileInfo, false, true, -1);
                        Object object2 = this;
                        synchronized (object2) {
                            this.current_requests.add(object);
                        }
                        while (true) {
                            if ((object2 = transcodeJobImpl.getStream(1000)) != null) {
                                streamWrapper = new StreamWrapper((InputStream)object2, transcodeJobImpl);
                                var5_8 = this;
                                break;
                            }
                            int n = transcodeJobImpl.getState();
                            if (n == 5) {
                                throw new IOException("Transcode failed: " + transcodeJobImpl.getError());
                            }
                            if (n == 4) {
                                throw new IOException("Transcode failed: job cancelled");
                            }
                            if (n == 3) {
                                throw new IOException("Job complete but no stream!");
                            }
                            var5_8 = this;
                            synchronized (var5_8) {
                                if (!this.current_requests.contains(object)) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 4, 10, 14, 15] lbl24 : MonitorExitStatement: MONITOREXIT : var5_8
                                    object2 = new IOException("Stream request cancelled");
                                    transcodeJobImpl.failed((Throwable)object2);
                                    throw object2;
                                }
                            }
                            System.out.println("waiting for stream");
                            continue;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Failed to add transcode job: " + Debug.getNestedExceptionMessage(throwable));
                    }
                    catch (Throwable throwable) {
                        2 var9_10 = this;
                        synchronized (var9_10) {
                            this.current_requests.remove(object);
                            throw throwable;
                        }
                    }
                    synchronized (var5_8) {
                        this.current_requests.remove(object);
                        return streamWrapper;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void destroyed(Object object) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.current_requests.remove(object);
                    }
                }
            }, transcodeFileImpl.getCacheFile());
            azureusContentFile = new AzureusContentFile((DiskManagerFileInfo)object, string){
                final /* synthetic */ DiskManagerFileInfo val$stream_file;
                final /* synthetic */ String val$tf_key;
                {
                    this.val$stream_file = diskManagerFileInfo;
                    this.val$tf_key = string;
                }

                @Override
                public DiskManagerFileInfo getFile() {
                    return this.val$stream_file;
                }

                @Override
                public Object getProperty(String string) {
                    if (string.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                        return new Object[]{DeviceUPnPImpl.this, this.val$tf_key};
                    }
                    if (string.equals("percent")) {
                        return new Long(1000L);
                    }
                    if (string.equals("eta")) {
                        return new Long(0L);
                    }
                    return null;
                }
            };
            Object object2 = acf_map;
            synchronized (object2) {
                acf_map.put(string, azureusContentFile);
            }
            transcodeFileImpl.setTransientProperty(UPNPAV_FILE_KEY, azureusContentFile);
            this.syncCategories(transcodeFileImpl, true);
            object2 = this;
            synchronized (object2) {
                if (this.dynamic_xcode_map == null) {
                    this.dynamic_xcode_map = new HashMap<String, AzureusContentFile>();
                }
                this.dynamic_xcode_map.put(string, azureusContentFile);
            }
            iPCInterface.invoke("addContent", new Object[]{azureusContentFile});
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDynamicXCode(DiskManagerFileInfo diskManagerFileInfo) {
        block11: {
            TranscodeProfile transcodeProfile = this.dynamic_transcode_profile;
            IPCInterface iPCInterface = this.upnpav_ipc;
            if (transcodeProfile == null || iPCInterface == null) {
                return;
            }
            try {
                TranscodeFileImpl transcodeFileImpl = this.lookupFile(transcodeProfile, diskManagerFileInfo);
                if (transcodeFileImpl == null || transcodeFileImpl.isComplete()) break block11;
                AzureusContentFile azureusContentFile = null;
                Object object = this;
                synchronized (object) {
                    if (this.dynamic_xcode_map != null) {
                        azureusContentFile = this.dynamic_xcode_map.get(transcodeFileImpl.getKey());
                    }
                }
                transcodeFileImpl.delete(true);
                if (azureusContentFile != null) {
                    iPCInterface.invoke("removeContent", new Object[]{azureusContentFile});
                }
                object = acf_map;
                synchronized (object) {
                    acf_map.remove(transcodeFileImpl.getKey());
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setupStreamXCode(TranscodeFileImpl transcodeFileImpl) {
        AzureusContentFile azureusContentFile;
        TranscodeJobImpl transcodeJobImpl = transcodeFileImpl.getJob();
        if (transcodeJobImpl == null) {
            return transcodeFileImpl.isComplete();
        }
        final String string = transcodeFileImpl.getKey();
        Object object = acf_map;
        synchronized (object) {
            azureusContentFile = acf_map.get(string);
        }
        if (azureusContentFile != null) {
            return true;
        }
        object = this.upnpav_ipc;
        if (object == null) {
            return false;
        }
        if (transcodeFileImpl.getDurationMillis() == 0L) {
            return false;
        }
        try {
            final TranscodeJobOutputLeecher transcodeJobOutputLeecher = new TranscodeJobOutputLeecher(transcodeJobImpl, transcodeFileImpl);
            azureusContentFile = new AzureusContentFile(){

                @Override
                public DiskManagerFileInfo getFile() {
                    return transcodeJobOutputLeecher;
                }

                @Override
                public Object getProperty(String string2) {
                    if (string2.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                        return new Object[]{DeviceUPnPImpl.this, string};
                    }
                    if (string2.equals("percent")) {
                        return new Long(1000L);
                    }
                    if (string2.equals("eta")) {
                        return new Long(0L);
                    }
                    return null;
                }
            };
            Map<String, AzureusContentFile> map = acf_map;
            synchronized (map) {
                acf_map.put(string, azureusContentFile);
            }
            object.invoke("addContent", new Object[]{azureusContentFile});
            this.log("Set up stream-xcode for " + transcodeFileImpl.getName());
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isVisible(AzureusContentDownload azureusContentDownload) {
        return !this.getFilterFilesView();
    }

    protected boolean isVisible(AzureusContentFile azureusContentFile) {
        String string;
        Object[] objectArray;
        boolean bl = this.getFilterFilesView() ? ((objectArray = (Object[])azureusContentFile.getProperty(this.MY_ACF_KEY)) != null && objectArray[0] == this ? this.getTranscodeFile(string = (String)objectArray[1]) != null : false) : true;
        return bl;
    }

    @Override
    public void fileAdded(TranscodeFile transcodeFile) {
        this.fileAdded(transcodeFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileAdded(TranscodeFile transcodeFile, boolean bl) {
        TranscodeFileImpl transcodeFileImpl = (TranscodeFileImpl)transcodeFile;
        IPCInterface iPCInterface = this.upnpav_ipc;
        DeviceUPnPImpl deviceUPnPImpl = this;
        synchronized (deviceUPnPImpl) {
            if (iPCInterface == null) {
                return;
            }
            if (!transcodeFileImpl.isComplete()) {
                this.syncCategories(transcodeFileImpl, bl);
                return;
            }
            AzureusContentFile azureusContentFile = (AzureusContentFile)transcodeFileImpl.getTransientProperty(UPNPAV_FILE_KEY);
            if (azureusContentFile != null) {
                return;
            }
            String string = transcodeFileImpl.getKey();
            Object object = acf_map;
            synchronized (object) {
                azureusContentFile = acf_map.get(string);
            }
            if (azureusContentFile != null) {
                return;
            }
            try {
                object = transcodeFileImpl.getTargetFile();
                azureusContentFile = new AzureusContentFile((DiskManagerFileInfo)object, string){
                    final /* synthetic */ DiskManagerFileInfo val$f;
                    final /* synthetic */ String val$tf_key;
                    {
                        this.val$f = diskManagerFileInfo;
                        this.val$tf_key = string;
                    }

                    @Override
                    public DiskManagerFileInfo getFile() {
                        return this.val$f;
                    }

                    @Override
                    public Object getProperty(String string) {
                        if (string.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                            return new Object[]{DeviceUPnPImpl.this, this.val$tf_key};
                        }
                        if (string.equals("cats")) {
                            TranscodeFileImpl transcodeFileImpl = DeviceUPnPImpl.this.getTranscodeFile(this.val$tf_key);
                            if (transcodeFileImpl != null) {
                                return transcodeFileImpl.getCategories();
                            }
                            return new String[0];
                        }
                        TranscodeFileImpl transcodeFileImpl = DeviceUPnPImpl.this.getTranscodeFile(this.val$tf_key);
                        if (transcodeFileImpl != null) {
                            long l = 0L;
                            if (string.equals("duration")) {
                                l = transcodeFileImpl.getDurationMillis();
                            } else if (string.equals("video_width")) {
                                l = transcodeFileImpl.getVideoWidth();
                            } else if (string.equals("video_height")) {
                                l = transcodeFileImpl.getVideoHeight();
                            } else if (string.equals("date")) {
                                l = transcodeFileImpl.getCreationDateMillis();
                            } else {
                                if (string.equals("percent")) {
                                    TranscodeJobImpl transcodeJobImpl;
                                    l = transcodeFileImpl.isComplete() ? 1000L : ((transcodeJobImpl = transcodeFileImpl.getJob()) == null ? 0L : (long)(10 * transcodeJobImpl.getPercentComplete()));
                                    return l;
                                }
                                if (string.equals("eta")) {
                                    TranscodeJobImpl transcodeJobImpl;
                                    l = transcodeFileImpl.isComplete() ? 0L : ((transcodeJobImpl = transcodeFileImpl.getJob()) == null ? Long.MAX_VALUE : transcodeJobImpl.getETASecs());
                                    return l;
                                }
                            }
                            if (l > 0L) {
                                return new Long(l);
                            }
                        }
                        return null;
                    }
                };
                transcodeFileImpl.setTransientProperty(UPNPAV_FILE_KEY, azureusContentFile);
                Map<String, AzureusContentFile> map = acf_map;
                synchronized (map) {
                    acf_map.put(string, azureusContentFile);
                }
                this.syncCategories(transcodeFileImpl, bl);
                try {
                    iPCInterface.invoke("addContent", new Object[]{azureusContentFile});
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
            catch (TranscodeException transcodeException) {
                // empty catch block
            }
        }
    }

    protected void syncCategories(TranscodeFileImpl transcodeFileImpl, boolean bl) {
        try {
            Download download = transcodeFileImpl.getSourceFile().getDownload();
            if (download != null) {
                if (bl) {
                    this.setCategories(transcodeFileImpl, download);
                }
                final String string = transcodeFileImpl.getKey();
                download.addAttributeListener(new DownloadAttributeListener(){

                    @Override
                    public void attributeEventOccurred(Download download, TorrentAttribute torrentAttribute, int n) {
                        TranscodeFileImpl transcodeFileImpl = DeviceUPnPImpl.this.getTranscodeFile(string);
                        if (transcodeFileImpl != null) {
                            DeviceUPnPImpl.this.setCategories(transcodeFileImpl, download);
                        }
                    }
                }, this.upnp_manager.getCategoryAttibute(), 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setCategories(TranscodeFileImpl transcodeFileImpl, Download download) {
        String string = download.getCategoryName();
        if (string != null && string.length() > 0 && !string.equals("Categories.uncategorized")) {
            transcodeFileImpl.setCategories(new String[]{string});
        } else {
            transcodeFileImpl.setCategories(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(TranscodeFile transcodeFile, int n, Object object) {
        if (transcodeFile.isComplete()) {
            this.fileAdded(transcodeFile, false);
        }
        if (n == 1 && object == "cat") {
            AzureusContentFile azureusContentFile;
            Map<String, AzureusContentFile> map = acf_map;
            synchronized (map) {
                azureusContentFile = acf_map.get(((TranscodeFileImpl)transcodeFile).getKey());
            }
            if (azureusContentFile != null) {
                AzureusPlatformContentDirectory.fireChanged(azureusContentFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileRemoved(TranscodeFile transcodeFile) {
        IPCInterface iPCInterface = this.upnp_manager.getUPnPAVIPC();
        if (iPCInterface == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            AzureusContentFile azureusContentFile = (AzureusContentFile)transcodeFile.getTransientProperty(UPNPAV_FILE_KEY);
            if (azureusContentFile == null) {
                return;
            }
            transcodeFile.setTransientProperty(UPNPAV_FILE_KEY, null);
            try {
                iPCInterface.invoke("removeContent", new Object[]{azureusContentFile});
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        object = acf_map;
        synchronized (object) {
            acf_map.remove(((TranscodeFileImpl)transcodeFile).getKey());
        }
    }

    protected URL getPresentationURL(UPnPDevice uPnPDevice) {
        String string = uPnPDevice.getRootDevice().getDevice().getPresentation();
        if (string != null) {
            try {
                URL uRL = new URL(string);
                return uRL;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected void getDisplayProperties(List<String[]> list) {
        super.getDisplayProperties(list);
        UPnPDevice uPnPDevice = this.device_may_be_null;
        if (uPnPDevice != null) {
            UPnPRootDevice uPnPRootDevice = uPnPDevice.getRootDevice();
            URL uRL = uPnPRootDevice.getLocation();
            this.addDP(list, "dht.reseed.ip", uRL.getHost() + ":" + uRL.getPort());
            String string = uPnPDevice.getModelName();
            String string2 = uPnPDevice.getModelURL();
            if (string2 != null && string2.length() > 0) {
                string = string + " (" + string2 + ")";
            }
            String string3 = uPnPDevice.getManufacturer();
            String string4 = uPnPDevice.getManufacturerURL();
            if (string4 != null && string4.length() > 0) {
                string3 = string3 + " (" + string4 + ")";
            }
            this.addDP(list, "device.model.desc", uPnPDevice.getModelDescription());
            this.addDP(list, "device.model.name", string);
            this.addDP(list, "device.model.num", uPnPDevice.getModelNumber());
            this.addDP(list, "device.manu.desc", string3);
        } else {
            InetAddress inetAddress = this.getAddress();
            if (inetAddress != null) {
                this.addDP(list, "dht.reseed.ip", inetAddress.getHostAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        super.generate(indentWriter);
        try {
            indentWriter.indent();
            UPnPDevice uPnPDevice = this.device_may_be_null;
            if (uPnPDevice == null) {
                indentWriter.println("upnp_device=null");
            } else {
                indentWriter.println("upnp_device=" + uPnPDevice.getFriendlyName());
            }
            indentWriter.println("dyn_xcode=" + (this.dynamic_transcode_profile == null ? "null" : this.dynamic_transcode_profile.getName()));
        }
        finally {
            indentWriter.exdent();
        }
    }

    protected static class StreamWrapper
    implements DiskManagerFileInfoStream.StreamFactory.StreamDetails {
        private InputStream is;
        private TranscodeJob job;

        protected StreamWrapper(InputStream inputStream, TranscodeJob transcodeJob) {
            this.is = inputStream;
            this.job = transcodeJob;
        }

        @Override
        public InputStream getStream() {
            return this.is;
        }

        @Override
        public boolean hasFailed() {
            long l = SystemTime.getMonotonousTime();
            while (true) {
                int n;
                if ((n = this.job.getState()) == 1) {
                    if (SystemTime.getMonotonousTime() - l > 5000L) {
                        return true;
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Throwable throwable) {
                        return true;
                    }
                }
                if (n == 5 || n == 4 || n == 7 || n == 6) break;
            }
            return true;
        }
    }
}

