/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;

public class DeviceMediaRendererManual
extends DeviceMediaRendererImpl {
    private static final Object COPY_ERROR_KEY = new Object();
    private static final Object COPY_PENDING_KEY = new Object();
    private boolean can_copy_to_folder = true;
    private boolean copy_outstanding;
    private boolean copy_outstanding_set;
    private AEThread2 copy_thread;
    private AESemaphore copy_sem = new AESemaphore("Device:copy");
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);

    protected DeviceMediaRendererManual(DeviceManagerImpl deviceManagerImpl, String string, String string2, boolean bl, String string3) {
        super(deviceManagerImpl, string, string2, bl, string3);
    }

    protected DeviceMediaRendererManual(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        super(deviceManagerImpl, map);
    }

    @Override
    protected void initialise() {
        super.initialise();
        if (this.getPersistentBooleanProperty("copy_outstanding", false)) {
            this.setCopyOutstanding();
        }
        this.addListener(new TranscodeTargetListener(){

            @Override
            public void fileAdded(TranscodeFile transcodeFile) {
                this.updateStatus(transcodeFile);
            }

            @Override
            public void fileChanged(TranscodeFile transcodeFile, int n, Object object) {
                this.updateStatus(transcodeFile);
            }

            @Override
            public void fileRemoved(TranscodeFile transcodeFile) {
                DeviceMediaRendererManual.this.setCopyOutstanding();
            }

            private void updateStatus(TranscodeFile transcodeFile) {
                if (transcodeFile.isComplete() && !transcodeFile.isCopiedToDevice()) {
                    DeviceMediaRendererManual.this.setCopyOutstanding();
                }
            }
        });
    }

    @Override
    public boolean canAssociate() {
        return false;
    }

    @Override
    public boolean canFilterFilesView() {
        return false;
    }

    @Override
    public boolean isBrowsable() {
        return false;
    }

    @Override
    public boolean canCopyToFolder() {
        return this.can_copy_to_folder;
    }

    @Override
    public void setCanCopyToFolder(boolean bl) {
        this.can_copy_to_folder = bl;
        if (!bl) {
            this.setPersistentBooleanProperty("copy_outstanding", false);
            this.copy_outstanding = false;
            this.copy_outstanding_set = false;
        }
    }

    @Override
    public File getCopyToFolder() {
        String string = this.getPersistentStringProperty("copy_to_folder", null);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    @Override
    public void setCopyToFolder(File file) {
        this.setPersistentStringProperty("copy_to_folder", file == null ? null : file.getAbsolutePath());
        if (this.getAutoCopyToFolder()) {
            this.setCopyOutstanding();
        }
    }

    @Override
    public boolean isLivenessDetectable() {
        return this.getPersistentBooleanProperty("live_det", false);
    }

    public void setLivenessDetectable(boolean bl) {
        this.setPersistentBooleanProperty("live_det", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCopyToFolderPending() {
        if (!this.can_copy_to_folder) {
            return 0;
        }
        TranscodeFileImpl[] transcodeFileImplArray = this;
        synchronized (this) {
            if (!this.copy_outstanding) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            transcodeFileImplArray = this.getFiles();
            int n = 0;
            for (TranscodeFileImpl transcodeFileImpl : transcodeFileImplArray) {
                if (!transcodeFileImpl.isComplete() || transcodeFileImpl.isCopiedToDevice()) continue;
                ++n;
            }
            return n;
        }
    }

    @Override
    public boolean getAutoCopyToFolder() {
        return this.getPersistentBooleanProperty("auto_copy", false);
    }

    @Override
    public void setAutoCopyToFolder(boolean bl) {
        this.setPersistentBooleanProperty("auto_copy", bl);
        this.setCopyOutstanding();
    }

    @Override
    public void manualCopy() throws DeviceManagerException {
        if (this.getAutoCopyToFolder()) {
            throw new DeviceManagerException("Operation prohibited - auto copy enabled");
        }
        this.doCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCopyOutstanding() {
        if (!this.can_copy_to_folder) {
            return;
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            this.copy_outstanding_set = true;
            if (this.copy_thread == null) {
                this.copy_thread = new AEThread2("Device:copier", true){

                    @Override
                    public void run() {
                        DeviceMediaRendererManual.this.performCopy();
                    }
                };
                this.copy_thread.start();
            }
            this.copy_sem.release();
        }
    }

    @Override
    public boolean isAudioCompatible(TranscodeFile transcodeFile) {
        if (this.getDeviceClassification().equals("sony.PSP")) {
            try {
                String string;
                File file = transcodeFile.getSourceFile().getFile();
                if (file.exists() && ((string = file.getName().toLowerCase()).endsWith(".mp3") || string.endsWith(".wma"))) {
                    ((TranscodeFileImpl)transcodeFile).setCopyToFolderOverride(".." + File.separator + "MUSIC");
                    return true;
                }
            }
            catch (Throwable throwable) {
                this.log("audio compatible check failed", throwable);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performCopy() {
        if (!this.can_copy_to_folder) {
            return;
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            this.copy_outstanding = true;
            this.async_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    DeviceMediaRendererManual.this.setPersistentBooleanProperty("copy_outstanding", true);
                }
            });
        }
        do {
            if (this.copy_sem.reserve(10000L)) {
                while (this.copy_sem.reserveIfAvailable()) {
                }
            }
            boolean bl = this.getAutoCopyToFolder();
            boolean bl2 = false;
            DeviceMediaRendererManual deviceMediaRendererManual2 = this;
            synchronized (deviceMediaRendererManual2) {
                if (!bl) {
                    this.copy_thread = null;
                    bl2 = true;
                } else {
                    this.copy_outstanding_set = false;
                }
            }
            if (!bl2) continue;
            this.setError(COPY_ERROR_KEY, null);
            int n = this.getCopyToFolderPending();
            if (n == 0) {
                this.setInfo(COPY_PENDING_KEY, null);
            } else {
                String string = MessageText.getString("devices.info.copypending", new String[]{String.valueOf(n)});
                this.setInfo(COPY_PENDING_KEY, string);
            }
            return;
        } while (!this.doCopy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCopy() {
        Object object;
        if (!this.can_copy_to_folder) {
            return true;
        }
        this.setInfo(COPY_PENDING_KEY, null);
        File file = this.getCopyToFolder();
        ArrayList<TranscodeFileImpl> arrayList = new ArrayList<TranscodeFileImpl>();
        int n = 0;
        TranscodeFileImpl[] transcodeFileImplArray = this.getFiles();
        int n2 = 0;
        for (TranscodeFileImpl object2 : transcodeFileImplArray) {
            if (!object2.isComplete() || object2.isCopiedToDevice()) continue;
            ++n2;
            if (object2.getCopyToDeviceFails() < 3L) {
                arrayList.add(object2);
                continue;
            }
            object = (String)object2.getTransientProperty(COPY_ERROR_KEY);
            this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copyfail") + (object == null ? "" : " - " + (String)object));
            n = 1;
        }
        boolean bl = false;
        if (arrayList.size() > 0) {
            if (!(!this.isLivenessDetectable() || this.isAlive() || file != null && file.exists())) {
                String string = MessageText.getString("devices.info.copypending2", new String[]{String.valueOf(n2)});
                this.setInfo(COPY_PENDING_KEY, string);
                n = 1;
            } else {
                int n3 = 0;
                if (file == null) {
                    this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copytonotset"));
                    n3 = 1;
                } else if (!file.exists()) {
                    if (this.getDeviceClassification().startsWith("android")) {
                        File file2 = file.getParentFile();
                        if (file2 != null && file2.canWrite()) {
                            file.mkdir();
                        }
                        if (!file.exists()) {
                            this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.mountrequired", new String[]{file.getAbsolutePath()}));
                            n3 = 1;
                        }
                    } else {
                        this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copytomissing", new String[]{file.getAbsolutePath()}));
                        n3 = 1;
                    }
                }
                if (n3 == 0) {
                    if (!file.canWrite()) {
                        this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copytonowrite", new String[]{file.getAbsolutePath()}));
                        n3 = 1;
                    } else {
                        bl = true;
                        this.setError(COPY_ERROR_KEY, null);
                    }
                }
                n |= n3;
            }
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            if (arrayList.size() == 0 && !this.copy_outstanding_set && n == 0) {
                this.copy_outstanding = false;
                this.async_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        DeviceMediaRendererManual.this.setError(COPY_ERROR_KEY, null);
                        DeviceMediaRendererManual.this.setPersistentBooleanProperty("copy_outstanding", false);
                    }
                });
                this.copy_thread = null;
                return true;
            }
        }
        if (bl) {
            try {
                this.setBusy(true);
                for (TranscodeFileImpl transcodeFileImpl : arrayList) {
                    try {
                        File file2;
                        File file3 = transcodeFileImpl.getTargetFile().getFile();
                        object = new File(file, file3.getName());
                        String string = transcodeFileImpl.getCopyToFolderOverride();
                        if (string != null && (file2 = new File(file, string)).exists()) {
                            object = new File(file2, file3.getName());
                        }
                        try {
                            FileUtil.copyFileWithException(file3, (File)object);
                            this.log("Copied file '" + file3 + ": to " + file);
                            transcodeFileImpl.setCopiedToDevice(true);
                        }
                        catch (Throwable throwable) {
                            file.delete();
                            transcodeFileImpl.setCopyToDeviceFailed();
                            transcodeFileImpl.setTransientProperty(COPY_ERROR_KEY, Debug.getNestedExceptionMessage(throwable));
                            this.log("Failed to copy file " + file3, throwable);
                        }
                    }
                    catch (TranscodeException transcodeException) {}
                }
            }
            finally {
                this.setBusy(false);
            }
        }
        return false;
    }

    @Override
    protected void getDisplayProperties(List<String[]> list) {
        super.getDisplayProperties(list);
        this.addDP(list, "devices.copy.pending", this.copy_outstanding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        super.generate(indentWriter);
        try {
            indentWriter.indent();
            indentWriter.println("auto_copy=" + this.getAutoCopyToFolder() + ", copy_to=" + this.getCopyToFolder() + ", copy_os=" + this.copy_outstanding);
        }
        finally {
            indentWriter.exdent();
        }
    }
}

