/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.PackedInts;

public class GrowableWriter
implements PackedInts.Mutable {
    private long currentMaxValue;
    private PackedInts.Mutable current;
    private final boolean roundFixedSize;

    public GrowableWriter(int n, int n2, boolean bl) {
        this.roundFixedSize = bl;
        this.current = PackedInts.getMutable(n2, this.getSize(n));
        this.currentMaxValue = PackedInts.maxValue(this.current.getBitsPerValue());
    }

    private final int getSize(int n) {
        if (this.roundFixedSize) {
            return PackedInts.getNextFixedSize(n);
        }
        return n;
    }

    @Override
    public long get(int n) {
        return this.current.get(n);
    }

    @Override
    public int size() {
        return this.current.size();
    }

    @Override
    public int getBitsPerValue() {
        return this.current.getBitsPerValue();
    }

    public PackedInts.Mutable getMutable() {
        return this.current;
    }

    @Override
    public Object getArray() {
        return this.current.getArray();
    }

    @Override
    public boolean hasArray() {
        return this.current.hasArray();
    }

    @Override
    public void set(int n, long l) {
        if (l >= this.currentMaxValue) {
            int n2 = this.getBitsPerValue();
            while (this.currentMaxValue <= l && this.currentMaxValue != Long.MAX_VALUE) {
                ++n2;
                this.currentMaxValue *= 2L;
            }
            int n3 = this.size();
            PackedInts.Mutable mutable = PackedInts.getMutable(n3, this.getSize(n2));
            for (int i = 0; i < n3; ++i) {
                mutable.set(i, this.current.get(i));
            }
            this.current = mutable;
            this.currentMaxValue = PackedInts.maxValue(this.current.getBitsPerValue());
        }
        this.current.set(n, l);
    }

    @Override
    public void clear() {
        this.current.clear();
    }

    public GrowableWriter resize(int n) {
        GrowableWriter growableWriter = new GrowableWriter(this.getBitsPerValue(), n, this.roundFixedSize);
        int n2 = Math.min(this.size(), n);
        for (int i = 0; i < n2; ++i) {
            growableWriter.set(i, this.get(i));
        }
        return growableWriter;
    }
}

