/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct32
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private int[] values;
    private static final int BITS_PER_VALUE = 32;

    public Direct32(int n) {
        super(n, 32);
        this.values = new int[n];
    }

    public Direct32(DataInput dataInput, int n) throws IOException {
        super(n, 32);
        int n2;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = dataInput.readInt();
        }
        n2 = n % 2;
        if (n2 != 0) {
            dataInput.readInt();
        }
        this.values = nArray;
    }

    public Direct32(int[] nArray) {
        super(nArray.length, 32);
        this.values = nArray;
    }

    @Override
    public long get(int n) {
        return 0xFFFFFFFFL & (long)this.values[n];
    }

    @Override
    public void set(int n, long l) {
        this.values[n] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.length * 4;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0);
    }

    public int[] getArray() {
        return this.values;
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

