/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.fst.Outputs;

public final class UpToTwoPositiveIntOutputs
extends Outputs<Object> {
    private static final Long NO_OUTPUT = new Long(0L);
    private final boolean doShare;
    private static final UpToTwoPositiveIntOutputs singletonShare = new UpToTwoPositiveIntOutputs(true);
    private static final UpToTwoPositiveIntOutputs singletonNoShare = new UpToTwoPositiveIntOutputs(false);

    private UpToTwoPositiveIntOutputs(boolean bl) {
        this.doShare = bl;
    }

    public static UpToTwoPositiveIntOutputs getSingleton(boolean bl) {
        return bl ? singletonShare : singletonNoShare;
    }

    public Long get(long l) {
        if (l == 0L) {
            return NO_OUTPUT;
        }
        return l;
    }

    public TwoLongs get(long l, long l2) {
        return new TwoLongs(l, l2);
    }

    @Override
    public Long common(Object object, Object object2) {
        assert (this.valid(object, false));
        assert (this.valid(object2, false));
        Long l = (Long)object;
        Long l2 = (Long)object2;
        if (l == NO_OUTPUT || l2 == NO_OUTPUT) {
            return NO_OUTPUT;
        }
        if (this.doShare) {
            assert (l > 0L);
            assert (l2 > 0L);
            return Math.min(l, l2);
        }
        if (l.equals(l2)) {
            return l;
        }
        return NO_OUTPUT;
    }

    @Override
    public Long subtract(Object object, Object object2) {
        assert (this.valid(object, false));
        assert (this.valid(object2, false));
        Long l = (Long)object;
        Long l2 = (Long)object2;
        assert (l >= l2);
        if (l2 == NO_OUTPUT) {
            return l;
        }
        if (l.equals(l2)) {
            return NO_OUTPUT;
        }
        return l - l2;
    }

    @Override
    public Object add(Object object, Object object2) {
        assert (this.valid(object, false));
        assert (this.valid(object2, true));
        Long l = (Long)object;
        if (object2 instanceof Long) {
            Long l2 = (Long)object2;
            if (l == NO_OUTPUT) {
                return l2;
            }
            if (l2 == NO_OUTPUT) {
                return l;
            }
            return l + l2;
        }
        TwoLongs twoLongs = (TwoLongs)object2;
        long l3 = l;
        return new TwoLongs(twoLongs.first + l3, twoLongs.second + l3);
    }

    @Override
    public void write(Object object, DataOutput dataOutput) throws IOException {
        assert (this.valid(object, true));
        if (object instanceof Long) {
            Long l = (Long)object;
            dataOutput.writeVLong(l << 1);
        } else {
            TwoLongs twoLongs = (TwoLongs)object;
            dataOutput.writeVLong(twoLongs.first << 1 | 1L);
            dataOutput.writeVLong(twoLongs.second);
        }
    }

    @Override
    public Object read(DataInput dataInput) throws IOException {
        long l = dataInput.readVLong();
        if ((l & 1L) == 0L) {
            long l2 = l >>> 1;
            if (l2 == 0L) {
                return NO_OUTPUT;
            }
            return l2;
        }
        long l3 = l >>> 1;
        long l4 = dataInput.readVLong();
        return new TwoLongs(l3, l4);
    }

    private boolean valid(Long l) {
        assert (l != null);
        assert (l instanceof Long);
        assert (l == NO_OUTPUT || l > 0L);
        return true;
    }

    private boolean valid(Object object, boolean bl) {
        if (!bl) {
            assert (object instanceof Long);
            return this.valid((Long)object);
        }
        if (object instanceof TwoLongs) {
            return true;
        }
        return this.valid((Long)object);
    }

    @Override
    public Object getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    public String outputToString(Object object) {
        return object.toString();
    }

    @Override
    public Object merge(Object object, Object object2) {
        assert (this.valid(object, false));
        assert (this.valid(object2, false));
        return new TwoLongs((Long)object, (Long)object2);
    }

    public static final class TwoLongs {
        final long first;
        final long second;

        public TwoLongs(long l, long l2) {
            this.first = l;
            this.second = l2;
            assert (l >= 0L);
            assert (l2 >= 0L);
        }

        public String toString() {
            return "TwoLongs:" + this.first + "," + this.second;
        }

        public boolean equals(Object object) {
            if (object instanceof TwoLongs) {
                TwoLongs twoLongs = (TwoLongs)object;
                return this.first == twoLongs.first && this.second == twoLongs.second;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.first ^ this.first >>> 32 ^ (this.second ^ this.second >> 32));
        }
    }
}

