/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.fst.Outputs;

public class PairOutputs<A, B>
extends Outputs<Pair<A, B>> {
    private final Pair<A, B> NO_OUTPUT;
    private final Outputs<A> outputs1;
    private final Outputs<B> outputs2;

    public PairOutputs(Outputs<A> outputs, Outputs<B> outputs2) {
        this.outputs1 = outputs;
        this.outputs2 = outputs2;
        this.NO_OUTPUT = new Pair<A, B>(outputs.getNoOutput(), outputs2.getNoOutput());
    }

    public Pair<A, B> get(A a, B b) {
        if (a == this.outputs1.getNoOutput() && b == this.outputs2.getNoOutput()) {
            return this.NO_OUTPUT;
        }
        return new Pair<A, B>(a, b);
    }

    @Override
    public Pair<A, B> common(Pair<A, B> pair, Pair<A, B> pair2) {
        return this.get(this.outputs1.common(pair.output1, pair2.output1), this.outputs2.common(pair.output2, pair2.output2));
    }

    @Override
    public Pair<A, B> subtract(Pair<A, B> pair, Pair<A, B> pair2) {
        return this.get(this.outputs1.subtract(pair.output1, pair2.output1), this.outputs2.subtract(pair.output2, pair2.output2));
    }

    @Override
    public Pair<A, B> add(Pair<A, B> pair, Pair<A, B> pair2) {
        return this.get(this.outputs1.add(pair.output1, pair2.output1), this.outputs2.add(pair.output2, pair2.output2));
    }

    @Override
    public void write(Pair<A, B> pair, DataOutput dataOutput) throws IOException {
        this.outputs1.write(pair.output1, dataOutput);
        this.outputs2.write(pair.output2, dataOutput);
    }

    @Override
    public Pair<A, B> read(DataInput dataInput) throws IOException {
        A a = this.outputs1.read(dataInput);
        B b = this.outputs2.read(dataInput);
        return this.get(a, b);
    }

    @Override
    public Pair<A, B> getNoOutput() {
        return this.NO_OUTPUT;
    }

    @Override
    public String outputToString(Pair<A, B> pair) {
        return "<pair:" + this.outputs1.outputToString(pair.output1) + "," + this.outputs2.outputToString(pair.output2) + ">";
    }

    public static class Pair<A, B> {
        public final A output1;
        public final B output2;

        public Pair(A a, B b) {
            this.output1 = a;
            this.output2 = b;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.output1.equals(pair.output1) && this.output2.equals(pair.output2);
            }
            return false;
        }

        public int hashCode() {
            return this.output1.hashCode() + this.output2.hashCode();
        }
    }
}

