/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;

public class SortedVIntList
extends DocIdSet {
    static final int BITS2VINTLIST_SIZE = 8;
    private int size;
    private byte[] bytes;
    private int lastBytePos;
    private static final int VB1 = 127;
    private static final int BIT_SHIFT = 7;
    private final int MAX_BYTES_PER_INT = 5;

    public SortedVIntList(int ... nArray) {
        this(nArray, nArray.length);
    }

    public SortedVIntList(int[] nArray, int n) {
        SortedVIntListBuilder sortedVIntListBuilder = new SortedVIntListBuilder();
        for (int i = 0; i < n; ++i) {
            sortedVIntListBuilder.addInt(nArray[i]);
        }
        sortedVIntListBuilder.done();
    }

    public SortedVIntList(BitSet bitSet) {
        SortedVIntListBuilder sortedVIntListBuilder = new SortedVIntListBuilder();
        int n = bitSet.nextSetBit(0);
        while (n != -1) {
            sortedVIntListBuilder.addInt(n);
            n = bitSet.nextSetBit(n + 1);
        }
        sortedVIntListBuilder.done();
    }

    public SortedVIntList(DocIdSetIterator docIdSetIterator) throws IOException {
        int n;
        SortedVIntListBuilder sortedVIntListBuilder = new SortedVIntListBuilder();
        while ((n = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
            sortedVIntListBuilder.addInt(n);
        }
        sortedVIntListBuilder.done();
    }

    private void initBytes() {
        this.size = 0;
        this.bytes = new byte[128];
        this.lastBytePos = 0;
    }

    private void resizeBytes(int n) {
        if (n != this.bytes.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, 0, byArray, 0, this.lastBytePos);
            this.bytes = byArray;
        }
    }

    public int size() {
        return this.size;
    }

    public int getByteSize() {
        return this.bytes.length;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public DocIdSetIterator iterator() {
        return new DocIdSetIterator(){
            int bytePos = 0;
            int lastInt = 0;
            int doc = -1;

            private void advance() {
                byte by = SortedVIntList.this.bytes[this.bytePos++];
                this.lastInt += by & 0x7F;
                int n = 7;
                while ((by & 0xFFFFFF80) != 0) {
                    by = SortedVIntList.this.bytes[this.bytePos++];
                    this.lastInt += (by & 0x7F) << n;
                    n += 7;
                }
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                if (this.bytePos >= SortedVIntList.this.lastBytePos) {
                    this.doc = Integer.MAX_VALUE;
                } else {
                    this.advance();
                    this.doc = this.lastInt;
                }
                return this.doc;
            }

            @Override
            public int advance(int n) {
                while (this.bytePos < SortedVIntList.this.lastBytePos) {
                    this.advance();
                    if (this.lastInt < n) continue;
                    this.doc = this.lastInt;
                    return this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        };
    }

    private class SortedVIntListBuilder {
        private int lastInt = 0;

        SortedVIntListBuilder() {
            SortedVIntList.this.initBytes();
            this.lastInt = 0;
        }

        void addInt(int n) {
            int n2 = n - this.lastInt;
            if (n2 < 0) {
                throw new IllegalArgumentException("Input not sorted or first element negative.");
            }
            if (SortedVIntList.this.lastBytePos + 5 > SortedVIntList.this.bytes.length) {
                SortedVIntList.this.resizeBytes(ArrayUtil.oversize(SortedVIntList.this.lastBytePos + 5, 1));
            }
            while ((n2 & 0xFFFFFF80) != 0) {
                ((SortedVIntList)SortedVIntList.this).bytes[((SortedVIntList)SortedVIntList.this).lastBytePos++] = (byte)(n2 & 0x7F | 0xFFFFFF80);
                n2 >>>= 7;
            }
            ((SortedVIntList)SortedVIntList.this).bytes[((SortedVIntList)SortedVIntList.this).lastBytePos++] = (byte)n2;
            SortedVIntList.this.size++;
            this.lastInt = n;
        }

        void done() {
            SortedVIntList.this.resizeBytes(SortedVIntList.this.lastBytePos);
        }
    }
}

