/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;

public final class PagedBytes {
    private final List<byte[]> blocks = new ArrayList<byte[]>();
    private final List<Integer> blockEnd = new ArrayList<Integer>();
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private boolean didSkipBytes;
    private boolean frozen;
    private int upto;
    private byte[] currentBlock;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PagedBytes(int n) {
        this.blockSize = 1 << n;
        this.blockBits = n;
        this.blockMask = this.blockSize - 1;
        this.upto = this.blockSize;
    }

    public void copy(IndexInput indexInput, long l) throws IOException {
        while (l > 0L) {
            int n = this.blockSize - this.upto;
            if (n == 0) {
                if (this.currentBlock != null) {
                    this.blocks.add(this.currentBlock);
                    this.blockEnd.add(this.upto);
                }
                this.currentBlock = new byte[this.blockSize];
                this.upto = 0;
                n = this.blockSize;
            }
            if ((long)n < l) {
                indexInput.readBytes(this.currentBlock, this.upto, n, false);
                this.upto = this.blockSize;
                l -= (long)n;
                continue;
            }
            indexInput.readBytes(this.currentBlock, this.upto, (int)l, false);
            this.upto = (int)((long)this.upto + l);
            break;
        }
    }

    public void copy(BytesRef bytesRef) throws IOException {
        int n = bytesRef.length;
        int n2 = bytesRef.offset;
        while (n > 0) {
            int n3 = this.blockSize - this.upto;
            if (n3 == 0) {
                if (this.currentBlock != null) {
                    this.blocks.add(this.currentBlock);
                    this.blockEnd.add(this.upto);
                }
                this.currentBlock = new byte[this.blockSize];
                this.upto = 0;
                n3 = this.blockSize;
            }
            if (n3 < n) {
                System.arraycopy(bytesRef.bytes, n2, this.currentBlock, this.upto, n3);
                this.upto = this.blockSize;
                n -= n3;
                n2 += n3;
                continue;
            }
            System.arraycopy(bytesRef.bytes, n2, this.currentBlock, this.upto, n);
            this.upto += n;
            break;
        }
    }

    public void copy(BytesRef bytesRef, BytesRef bytesRef2) throws IOException {
        int n = this.blockSize - this.upto;
        if (bytesRef.length > n || this.currentBlock == null) {
            if (this.currentBlock != null) {
                this.blocks.add(this.currentBlock);
                this.blockEnd.add(this.upto);
                this.didSkipBytes = true;
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
            n = this.blockSize;
            assert (bytesRef.length <= this.blockSize);
        }
        bytesRef2.bytes = this.currentBlock;
        bytesRef2.offset = this.upto;
        bytesRef2.length = bytesRef.length;
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.currentBlock, this.upto, bytesRef.length);
        this.upto += bytesRef.length;
    }

    public Reader freeze(boolean bl) {
        if (this.frozen) {
            throw new IllegalStateException("already frozen");
        }
        if (this.didSkipBytes) {
            throw new IllegalStateException("cannot freeze when copy(BytesRef, BytesRef) was used");
        }
        if (bl && this.upto < this.blockSize) {
            byte[] byArray = new byte[this.upto];
            System.arraycopy(this.currentBlock, 0, byArray, 0, this.upto);
            this.currentBlock = byArray;
        }
        if (this.currentBlock == null) {
            this.currentBlock = EMPTY_BYTES;
        }
        this.blocks.add(this.currentBlock);
        this.blockEnd.add(this.upto);
        this.frozen = true;
        this.currentBlock = null;
        return new Reader(this);
    }

    public long getPointer() {
        if (this.currentBlock == null) {
            return 0L;
        }
        return (long)this.blocks.size() * (long)this.blockSize + (long)this.upto;
    }

    public long copyUsingLengthPrefix(BytesRef bytesRef) throws IOException {
        if (this.upto + bytesRef.length + 2 > this.blockSize) {
            if (bytesRef.length + 2 > this.blockSize) {
                throw new IllegalArgumentException("block size " + this.blockSize + " is too small to store length " + bytesRef.length + " bytes");
            }
            if (this.currentBlock != null) {
                this.blocks.add(this.currentBlock);
                this.blockEnd.add(this.upto);
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
        }
        long l = this.getPointer();
        if (bytesRef.length < 128) {
            this.currentBlock[this.upto++] = (byte)bytesRef.length;
        } else {
            this.currentBlock[this.upto++] = (byte)(0x80 | bytesRef.length >> 8);
            this.currentBlock[this.upto++] = (byte)(bytesRef.length & 0xFF);
        }
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.currentBlock, this.upto, bytesRef.length);
        this.upto += bytesRef.length;
        return l;
    }

    public PagedBytesDataInput getDataInput() {
        if (!this.frozen) {
            throw new IllegalStateException("must call freeze() before getDataInput");
        }
        return new PagedBytesDataInput();
    }

    public PagedBytesDataOutput getDataOutput() {
        if (this.frozen) {
            throw new IllegalStateException("cannot get DataOutput after freeze()");
        }
        return new PagedBytesDataOutput();
    }

    static /* synthetic */ byte[] access$602(PagedBytes pagedBytes, byte[] byArray) {
        pagedBytes.currentBlock = byArray;
        return byArray;
    }

    public final class PagedBytesDataOutput
    extends DataOutput {
        @Override
        public void writeByte(byte by) {
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.blocks.add(PagedBytes.this.currentBlock);
                    PagedBytes.this.blockEnd.add(PagedBytes.this.upto);
                }
                PagedBytes.access$602(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
            }
            ((PagedBytes)PagedBytes.this).currentBlock[((PagedBytes)PagedBytes.this).upto++] = by;
        }

        @Override
        public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            assert (byArray.length >= n + n2);
            if (n2 == 0) {
                return;
            }
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.blocks.add(PagedBytes.this.currentBlock);
                    PagedBytes.this.blockEnd.add(PagedBytes.this.upto);
                }
                PagedBytes.access$602(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
            }
            int n4 = n + n2;
            while (true) {
                n3 = n4 - n;
                int n5 = PagedBytes.this.blockSize - PagedBytes.this.upto;
                if (n5 >= n3) break;
                System.arraycopy(byArray, n, PagedBytes.this.currentBlock, PagedBytes.this.upto, n5);
                PagedBytes.this.blocks.add(PagedBytes.this.currentBlock);
                PagedBytes.this.blockEnd.add(PagedBytes.this.blockSize);
                PagedBytes.access$602(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
                n += n5;
            }
            System.arraycopy(byArray, n, PagedBytes.this.currentBlock, PagedBytes.this.upto, n3);
            PagedBytes.this.upto += n3;
        }

        public long getPosition() {
            if (PagedBytes.this.currentBlock == null) {
                return 0L;
            }
            return PagedBytes.this.blocks.size() * PagedBytes.this.blockSize + PagedBytes.this.upto;
        }
    }

    public final class PagedBytesDataInput
    extends DataInput {
        private int currentBlockIndex;
        private int currentBlockUpto;
        private byte[] currentBlock;

        PagedBytesDataInput() {
            this.currentBlock = (byte[])PagedBytes.this.blocks.get(0);
        }

        @Override
        public Object clone() {
            PagedBytesDataInput pagedBytesDataInput = PagedBytes.this.getDataInput();
            pagedBytesDataInput.setPosition(this.getPosition());
            return pagedBytesDataInput;
        }

        public long getPosition() {
            return this.currentBlockIndex * PagedBytes.this.blockSize + this.currentBlockUpto;
        }

        public void setPosition(long l) {
            this.currentBlockIndex = (int)(l >> PagedBytes.this.blockBits);
            this.currentBlock = (byte[])PagedBytes.this.blocks.get(this.currentBlockIndex);
            this.currentBlockUpto = (int)(l & (long)PagedBytes.this.blockMask);
        }

        @Override
        public byte readByte() {
            if (this.currentBlockUpto == PagedBytes.this.blockSize) {
                this.nextBlock();
            }
            return this.currentBlock[this.currentBlockUpto++];
        }

        @Override
        public void readBytes(byte[] byArray, int n, int n2) {
            int n3;
            int n4;
            assert (byArray.length >= n + n2);
            int n5 = n + n2;
            while ((n4 = PagedBytes.this.blockSize - this.currentBlockUpto) < (n3 = n5 - n)) {
                System.arraycopy(this.currentBlock, this.currentBlockUpto, byArray, n, n4);
                this.nextBlock();
                n += n4;
            }
            System.arraycopy(this.currentBlock, this.currentBlockUpto, byArray, n, n3);
            this.currentBlockUpto += n3;
        }

        private void nextBlock() {
            ++this.currentBlockIndex;
            this.currentBlockUpto = 0;
            this.currentBlock = (byte[])PagedBytes.this.blocks.get(this.currentBlockIndex);
        }
    }

    public static final class Reader
    implements Closeable {
        private final byte[][] blocks;
        private final int[] blockEnds;
        private final int blockBits;
        private final int blockMask;
        private final int blockSize;
        private final CloseableThreadLocal<byte[]> threadBuffers = new CloseableThreadLocal();

        public Reader(PagedBytes pagedBytes) {
            int n;
            this.blocks = new byte[pagedBytes.blocks.size()][];
            for (n = 0; n < this.blocks.length; ++n) {
                this.blocks[n] = (byte[])pagedBytes.blocks.get(n);
            }
            this.blockEnds = new int[this.blocks.length];
            for (n = 0; n < this.blockEnds.length; ++n) {
                this.blockEnds[n] = (Integer)pagedBytes.blockEnd.get(n);
            }
            this.blockBits = pagedBytes.blockBits;
            this.blockMask = pagedBytes.blockMask;
            this.blockSize = pagedBytes.blockSize;
        }

        public BytesRef fillSlice(BytesRef bytesRef, long l, int n) {
            assert (n >= 0) : "length=" + n;
            int n2 = (int)(l >> this.blockBits);
            int n3 = (int)(l & (long)this.blockMask);
            bytesRef.length = n;
            if (this.blockSize - n3 >= n) {
                bytesRef.bytes = this.blocks[n2];
                bytesRef.offset = n3;
            } else {
                byte[] byArray = this.threadBuffers.get();
                if (byArray == null) {
                    byArray = new byte[n];
                    this.threadBuffers.set(byArray);
                } else if (byArray.length < n) {
                    byArray = ArrayUtil.grow(byArray, n);
                    this.threadBuffers.set(byArray);
                }
                bytesRef.bytes = byArray;
                bytesRef.offset = 0;
                System.arraycopy(this.blocks[n2], n3, byArray, 0, this.blockSize - n3);
                System.arraycopy(this.blocks[1 + n2], 0, byArray, this.blockSize - n3, n - (this.blockSize - n3));
            }
            return bytesRef;
        }

        public BytesRef fill(BytesRef bytesRef, long l) {
            int n = (int)(l >> this.blockBits);
            bytesRef.bytes = this.blocks[n];
            byte[] byArray = bytesRef.bytes;
            int n2 = (int)(l & (long)this.blockMask);
            if ((byArray[n2] & 0x80) == 0) {
                bytesRef.length = byArray[n2];
                bytesRef.offset = n2 + 1;
            } else {
                bytesRef.length = (byArray[n2] & 0x7F) << 8 | byArray[1 + n2] & 0xFF;
                bytesRef.offset = n2 + 2;
                assert (bytesRef.length > 0);
            }
            return bytesRef;
        }

        public int fillAndGetIndex(BytesRef bytesRef, long l) {
            int n = (int)(l >> this.blockBits);
            bytesRef.bytes = this.blocks[n];
            byte[] byArray = bytesRef.bytes;
            int n2 = (int)(l & (long)this.blockMask);
            if ((byArray[n2] & 0x80) == 0) {
                bytesRef.length = byArray[n2];
                bytesRef.offset = n2 + 1;
            } else {
                bytesRef.length = (byArray[n2] & 0x7F) << 8 | byArray[1 + n2] & 0xFF;
                bytesRef.offset = n2 + 2;
                assert (bytesRef.length > 0);
            }
            return n;
        }

        public long fillAndGetStart(BytesRef bytesRef, long l) {
            int n = (int)(l >> this.blockBits);
            bytesRef.bytes = this.blocks[n];
            byte[] byArray = bytesRef.bytes;
            int n2 = (int)(l & (long)this.blockMask);
            if ((byArray[n2] & 0x80) == 0) {
                bytesRef.length = byArray[n2];
                bytesRef.offset = n2 + 1;
                l += 1L + (long)bytesRef.length;
            } else {
                bytesRef.length = (byArray[n2] & 0x7F) << 8 | byArray[1 + n2] & 0xFF;
                bytesRef.offset = n2 + 2;
                l += 2L + (long)bytesRef.length;
                assert (bytesRef.length > 0);
            }
            return l;
        }

        public BytesRef fillSliceWithPrefix(BytesRef bytesRef, long l) {
            int n;
            int n2 = (int)(l >> this.blockBits);
            byte[] byArray = this.blocks[n2];
            int n3 = (int)(l & (long)this.blockMask);
            if ((byArray[n3] & 0x80) == 0) {
                n = byArray[n3];
                ++n3;
            } else {
                n = (byArray[n3] & 0x7F) << 8 | byArray[1 + n3] & 0xFF;
                n3 += 2;
                assert (n > 0);
            }
            assert (n >= 0) : "length=" + n;
            bytesRef.length = n;
            if (this.blockSize - n3 >= n) {
                bytesRef.offset = n3;
                bytesRef.bytes = this.blocks[n2];
            } else {
                byte[] byArray2 = this.threadBuffers.get();
                if (byArray2 == null) {
                    byArray2 = new byte[n];
                    this.threadBuffers.set(byArray2);
                } else if (byArray2.length < n) {
                    byArray2 = ArrayUtil.grow(byArray2, n);
                    this.threadBuffers.set(byArray2);
                }
                bytesRef.bytes = byArray2;
                bytesRef.offset = 0;
                System.arraycopy(this.blocks[n2], n3, byArray2, 0, this.blockSize - n3);
                System.arraycopy(this.blocks[1 + n2], 0, byArray2, this.blockSize - n3, n - (this.blockSize - n3));
            }
            return bytesRef;
        }

        public byte[][] getBlocks() {
            return this.blocks;
        }

        public int[] getBlockEnds() {
            return this.blockEnds;
        }

        @Override
        public void close() {
            this.threadBuffers.close();
        }
    }
}

