/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class NumericUtils {
    public static final int PRECISION_STEP_DEFAULT = 4;
    public static final char SHIFT_START_LONG = ' ';
    public static final int BUF_SIZE_LONG = 11;
    public static final char SHIFT_START_INT = '`';
    public static final int BUF_SIZE_INT = 6;

    private NumericUtils() {
    }

    public static int longToPrefixCoded(long l, int n, char[] cArray) {
        if (n > 63 || n < 0) {
            throw new IllegalArgumentException("Illegal shift value, must be 0..63");
        }
        int n2 = (63 - n) / 7 + 1;
        int n3 = n2 + 1;
        cArray[0] = (char)(32 + n);
        long l2 = l ^ Long.MIN_VALUE;
        l2 >>>= n;
        while (n2 >= 1) {
            cArray[n2--] = (char)(l2 & 0x7FL);
            l2 >>>= 7;
        }
        return n3;
    }

    public static String longToPrefixCoded(long l, int n) {
        char[] cArray = new char[11];
        int n2 = NumericUtils.longToPrefixCoded(l, n, cArray);
        return new String(cArray, 0, n2);
    }

    public static String longToPrefixCoded(long l) {
        return NumericUtils.longToPrefixCoded(l, 0);
    }

    public static int intToPrefixCoded(int n, int n2, char[] cArray) {
        if (n2 > 31 || n2 < 0) {
            throw new IllegalArgumentException("Illegal shift value, must be 0..31");
        }
        int n3 = (31 - n2) / 7 + 1;
        int n4 = n3 + 1;
        cArray[0] = (char)(96 + n2);
        int n5 = n ^ Integer.MIN_VALUE;
        n5 >>>= n2;
        while (n3 >= 1) {
            cArray[n3--] = (char)(n5 & 0x7F);
            n5 >>>= 7;
        }
        return n4;
    }

    public static String intToPrefixCoded(int n, int n2) {
        char[] cArray = new char[6];
        int n3 = NumericUtils.intToPrefixCoded(n, n2, cArray);
        return new String(cArray, 0, n3);
    }

    public static String intToPrefixCoded(int n) {
        return NumericUtils.intToPrefixCoded(n, 0);
    }

    public static long prefixCodedToLong(String string) {
        int n = string.charAt(0) - 32;
        if (n > 63 || n < 0) {
            throw new NumberFormatException("Invalid shift value in prefixCoded string (is encoded value really a LONG?)");
        }
        long l = 0L;
        int n2 = string.length();
        for (int i = 1; i < n2; ++i) {
            l <<= 7;
            char c = string.charAt(i);
            if (c > '\u007f') {
                throw new NumberFormatException("Invalid prefixCoded numerical value representation (char " + Integer.toHexString(c) + " at position " + i + " is invalid)");
            }
            l |= (long)c;
        }
        return l << n ^ Long.MIN_VALUE;
    }

    public static int prefixCodedToInt(String string) {
        int n = string.charAt(0) - 96;
        if (n > 31 || n < 0) {
            throw new NumberFormatException("Invalid shift value in prefixCoded string (is encoded value really an INT?)");
        }
        int n2 = 0;
        int n3 = string.length();
        for (int i = 1; i < n3; ++i) {
            n2 <<= 7;
            char c = string.charAt(i);
            if (c > '\u007f') {
                throw new NumberFormatException("Invalid prefixCoded numerical value representation (char " + Integer.toHexString(c) + " at position " + i + " is invalid)");
            }
            n2 |= c;
        }
        return n2 << n ^ Integer.MIN_VALUE;
    }

    public static long doubleToSortableLong(double d) {
        long l = Double.doubleToLongBits(d);
        if (l < 0L) {
            l ^= Long.MAX_VALUE;
        }
        return l;
    }

    public static String doubleToPrefixCoded(double d) {
        return NumericUtils.longToPrefixCoded(NumericUtils.doubleToSortableLong(d));
    }

    public static double sortableLongToDouble(long l) {
        if (l < 0L) {
            l ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(l);
    }

    public static double prefixCodedToDouble(String string) {
        return NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(string));
    }

    public static int floatToSortableInt(float f) {
        int n = Float.floatToIntBits(f);
        if (n < 0) {
            n ^= Integer.MAX_VALUE;
        }
        return n;
    }

    public static String floatToPrefixCoded(float f) {
        return NumericUtils.intToPrefixCoded(NumericUtils.floatToSortableInt(f));
    }

    public static float sortableIntToFloat(int n) {
        if (n < 0) {
            n ^= Integer.MAX_VALUE;
        }
        return Float.intBitsToFloat(n);
    }

    public static float prefixCodedToFloat(String string) {
        return NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(string));
    }

    public static void splitLongRange(LongRangeBuilder longRangeBuilder, int n, long l, long l2) {
        NumericUtils.splitRange(longRangeBuilder, 64, n, l, l2);
    }

    public static void splitIntRange(IntRangeBuilder intRangeBuilder, int n, int n2, int n3) {
        NumericUtils.splitRange(intRangeBuilder, 32, n, n2, n3);
    }

    private static void splitRange(Object object, int n, int n2, long l, long l2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        if (l > l2) {
            return;
        }
        int n3 = 0;
        while (true) {
            boolean bl;
            long l3 = 1L << n3 + n2;
            long l4 = (1L << n2) - 1L << n3;
            boolean bl2 = (l & l4) != 0L;
            boolean bl3 = (l2 & l4) != l4;
            long l5 = (bl2 ? l + l3 : l) & (l4 ^ 0xFFFFFFFFFFFFFFFFL);
            long l6 = (bl3 ? l2 - l3 : l2) & (l4 ^ 0xFFFFFFFFFFFFFFFFL);
            boolean bl4 = l5 < l;
            boolean bl5 = bl = l6 > l2;
            if (n3 + n2 >= n || l5 > l6 || bl4 || bl) break;
            if (bl2) {
                NumericUtils.addRange(object, n, l, l | l4, n3);
            }
            if (bl3) {
                NumericUtils.addRange(object, n, l2 & (l4 ^ 0xFFFFFFFFFFFFFFFFL), l2, n3);
            }
            l = l5;
            l2 = l6;
            n3 += n2;
        }
        NumericUtils.addRange(object, n, l, l2, n3);
    }

    private static void addRange(Object object, int n, long l, long l2, int n2) {
        l2 |= (1L << n2) - 1L;
        switch (n) {
            case 64: {
                ((LongRangeBuilder)object).addRange(l, l2, n2);
                break;
            }
            case 32: {
                ((IntRangeBuilder)object).addRange((int)l, (int)l2, n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("valSize must be 32 or 64.");
            }
        }
    }

    public static abstract class IntRangeBuilder {
        public void addRange(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public void addRange(int n, int n2, int n3) {
            this.addRange(NumericUtils.intToPrefixCoded(n, n3), NumericUtils.intToPrefixCoded(n2, n3));
        }
    }

    public static abstract class LongRangeBuilder {
        public void addRange(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public void addRange(long l, long l2, int n) {
            this.addRange(NumericUtils.longToPrefixCoded(l, n), NumericUtils.longToPrefixCoded(l2, n));
        }
    }
}

