/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public final class IOUtils {
    public static final String UTF_8 = "UTF-8";
    public static final Charset CHARSET_UTF_8;
    private static final Method SUPPRESS_METHOD;

    private IOUtils() {
    }

    public static <E extends Exception> void closeWhileHandlingException(E e, Closeable ... closeableArray) throws E, IOException {
        Throwable throwable = null;
        for (Closeable closeable : closeableArray) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable2) {
                IOUtils.addSuppressed(e == null ? throwable : (Throwable)e, throwable2);
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        if (e != null) {
            throw e;
        }
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static <E extends Exception> void closeWhileHandlingException(E e, Iterable<Closeable> iterable) throws E, IOException {
        Throwable throwable = null;
        for (Closeable closeable : iterable) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable2) {
                IOUtils.addSuppressed(e == null ? throwable : (Throwable)e, throwable2);
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        if (e != null) {
            throw e;
        }
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static void close(Closeable ... closeableArray) throws IOException {
        Throwable throwable = null;
        for (Closeable closeable : closeableArray) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable2) {
                IOUtils.addSuppressed(throwable, throwable2);
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static void close(Iterable<? extends Closeable> iterable) throws IOException {
        Throwable throwable = null;
        for (Closeable closeable : iterable) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable2) {
                IOUtils.addSuppressed(throwable, throwable2);
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static void closeWhileHandlingException(Closeable ... closeableArray) throws IOException {
        for (Closeable closeable : closeableArray) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> iterable) throws IOException {
        for (Closeable closeable : iterable) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static final void addSuppressed(Throwable throwable, Throwable throwable2) {
        if (SUPPRESS_METHOD != null && throwable != null && throwable2 != null) {
            try {
                SUPPRESS_METHOD.invoke((Object)throwable, throwable2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Reader getDecodingReader(InputStream inputStream, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(inputStream, charsetDecoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(File file, Charset charset) throws IOException {
        Reader reader;
        block3: {
            FileInputStream fileInputStream = null;
            boolean bl = false;
            try {
                fileInputStream = new FileInputStream(file);
                Reader reader2 = IOUtils.getDecodingReader(fileInputStream, charset);
                bl = true;
                reader = reader2;
                if (bl) break block3;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    IOUtils.close(fileInputStream);
                }
                throw throwable;
            }
            IOUtils.close(fileInputStream);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(Class<?> clazz, String string, Charset charset) throws IOException {
        Reader reader;
        block3: {
            InputStream inputStream = null;
            boolean bl = false;
            try {
                inputStream = clazz.getResourceAsStream(string);
                Reader reader2 = IOUtils.getDecodingReader(inputStream, charset);
                bl = true;
                reader = reader2;
                if (bl) break block3;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    IOUtils.close(inputStream);
                }
                throw throwable;
            }
            IOUtils.close(inputStream);
        }
        return reader;
    }

    static {
        Method method;
        CHARSET_UTF_8 = Charset.forName(UTF_8);
        try {
            method = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (Exception exception) {
            method = null;
        }
        SUPPRESS_METHOD = method;
    }
}

