/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.LucenePackage;

public final class Constants {
    public static final String JAVA_VERSION;
    @Deprecated
    public static final boolean JAVA_1_1;
    @Deprecated
    public static final boolean JAVA_1_2;
    @Deprecated
    public static final boolean JAVA_1_3;
    public static final String OS_NAME;
    public static final boolean LINUX;
    public static final boolean WINDOWS;
    public static final boolean SUN_OS;
    public static final boolean MAC_OS_X;
    public static final String OS_ARCH;
    public static final String OS_VERSION;
    public static final String JAVA_VENDOR;
    public static final boolean JRE_IS_64BIT;
    public static final boolean JRE_IS_MINIMUM_JAVA6;
    public static final boolean JRE_IS_MINIMUM_JAVA7;
    public static final String LUCENE_MAIN_VERSION;
    public static final String LUCENE_VERSION;

    private Constants() {
    }

    private static String ident(String string) {
        return string.toString();
    }

    static {
        String string;
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_1_1 = JAVA_VERSION.startsWith("1.1.");
        JAVA_1_2 = JAVA_VERSION.startsWith("1.2.");
        JAVA_1_3 = JAVA_VERSION.startsWith("1.3.");
        OS_NAME = System.getProperty("os.name");
        LINUX = OS_NAME.startsWith("Linux");
        WINDOWS = OS_NAME.startsWith("Windows");
        SUN_OS = OS_NAME.startsWith("SunOS");
        MAC_OS_X = OS_NAME.startsWith("Mac OS X");
        OS_ARCH = System.getProperty("os.arch");
        OS_VERSION = System.getProperty("os.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        Object object = System.getProperty("sun.arch.data.model");
        JRE_IS_64BIT = object != null ? ((String)object).indexOf("64") != -1 : OS_ARCH != null && OS_ARCH.indexOf("64") != -1;
        boolean bl = true;
        try {
            String.class.getMethod("isEmpty", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        JRE_IS_MINIMUM_JAVA6 = bl;
        boolean bl2 = true;
        try {
            Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl2 = false;
        }
        JRE_IS_MINIMUM_JAVA7 = bl2;
        LUCENE_MAIN_VERSION = Constants.ident("3.5");
        object = LucenePackage.get();
        String string2 = string = object == null ? null : ((Package)object).getImplementationVersion();
        if (string == null) {
            string = LUCENE_MAIN_VERSION + "-SNAPSHOT";
        } else if (!string.startsWith(LUCENE_MAIN_VERSION)) {
            string = LUCENE_MAIN_VERSION + "-SNAPSHOT " + string;
        }
        LUCENE_VERSION = Constants.ident(string);
    }
}

