/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;

public final class CharsRef
implements Comparable<CharsRef>,
CharSequence {
    private static final char[] EMPTY_ARRAY = new char[0];
    public char[] chars;
    public int offset;
    public int length;
    private static final Comparator<CharsRef> utf16SortedAsUTF8SortOrder = new UTF16SortedAsUTF8Comparator();

    public CharsRef() {
        this(EMPTY_ARRAY, 0, 0);
    }

    public CharsRef(int n) {
        this.chars = new char[n];
    }

    public CharsRef(char[] cArray, int n, int n2) {
        assert (cArray != null);
        assert (cArray.length >= n + n2);
        this.chars = cArray;
        this.offset = n;
        this.length = n2;
    }

    public CharsRef(String string) {
        this.chars = string.toCharArray();
        this.offset = 0;
        this.length = this.chars.length;
    }

    public CharsRef(CharsRef charsRef) {
        this.copy(charsRef);
    }

    public Object clone() {
        return new CharsRef(this);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.offset + this.length;
        for (int i = this.offset; i < n2; ++i) {
            n = 31 * n + this.chars[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        CharSequence charSequence;
        if (this == object) {
            return true;
        }
        if (object instanceof CharsRef) {
            return this.charsEquals((CharsRef)object);
        }
        if (object instanceof CharSequence && this.length == (charSequence = (CharSequence)object).length()) {
            int n = this.length;
            int n2 = this.offset;
            int n3 = 0;
            while (n-- != 0) {
                if (this.chars[n2++] == charSequence.charAt(n3++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean charsEquals(CharsRef charsRef) {
        if (this.length == charsRef.length) {
            int n = charsRef.offset;
            char[] cArray = charsRef.chars;
            int n2 = this.offset + this.length;
            int n3 = this.offset;
            while (n3 < n2) {
                if (this.chars[n3] != cArray[n]) {
                    return false;
                }
                ++n3;
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(CharsRef charsRef) {
        if (this == charsRef) {
            return 0;
        }
        char[] cArray = this.chars;
        int n = this.offset;
        char[] cArray2 = charsRef.chars;
        int n2 = charsRef.offset;
        int n3 = n + Math.min(this.length, charsRef.length);
        while (n < n3) {
            char c;
            char c2;
            if ((c2 = cArray[n++]) > (c = cArray2[n2++])) {
                return 1;
            }
            if (c2 >= c) continue;
            return -1;
        }
        return this.length - charsRef.length;
    }

    public void copy(CharsRef charsRef) {
        this.chars = this.chars == null ? new char[charsRef.length] : ArrayUtil.grow(this.chars, charsRef.length);
        System.arraycopy(charsRef.chars, charsRef.offset, this.chars, 0, charsRef.length);
        this.length = charsRef.length;
        this.offset = 0;
    }

    public void grow(int n) {
        if (this.chars.length < n) {
            this.chars = ArrayUtil.grow(this.chars, n);
        }
    }

    public void copy(char[] cArray, int n, int n2) {
        this.grow(n2);
        System.arraycopy(cArray, n, this.chars, 0, n2);
        this.offset = 0;
        this.length = n2;
    }

    public void append(char[] cArray, int n, int n2) {
        int n3 = this.length + n2;
        this.grow(this.offset + n3);
        System.arraycopy(cArray, n, this.chars, this.offset + this.length, n2);
        this.length += n2;
    }

    @Override
    public String toString() {
        return new String(this.chars, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int n) {
        return this.chars[this.offset + n];
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return new CharsRef(this.chars, this.offset + n, this.offset + n2 - 1);
    }

    public static Comparator<CharsRef> getUTF16SortedAsUTF8Comparator() {
        return utf16SortedAsUTF8SortOrder;
    }

    private static class UTF16SortedAsUTF8Comparator
    implements Comparator<CharsRef> {
        private UTF16SortedAsUTF8Comparator() {
        }

        @Override
        public int compare(CharsRef charsRef, CharsRef charsRef2) {
            if (charsRef == charsRef2) {
                return 0;
            }
            char[] cArray = charsRef.chars;
            int n = charsRef.offset;
            char[] cArray2 = charsRef2.chars;
            int n2 = charsRef2.offset;
            int n3 = n + Math.min(charsRef.length, charsRef2.length);
            while (n < n3) {
                char c;
                char c2;
                if ((c2 = cArray[n++]) == (c = cArray2[n2++])) continue;
                if (c2 >= '\ud800' && c >= '\ud800') {
                    c2 = c2 >= '\ue000' ? (char)(c2 - 2048) : (char)(c2 + 8192);
                    c = c >= '\ue000' ? (char)(c - 2048) : (char)(c + 8192);
                }
                return c2 - c;
            }
            return charsRef.length - charsRef2.length;
        }
    }
}

