/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public final class ByteBlockPool {
    public static final int BYTE_BLOCK_SHIFT = 15;
    public static final int BYTE_BLOCK_SIZE = 32768;
    public static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;
    public byte[][] buffers = new byte[10][];
    int bufferUpto = -1;
    public int byteUpto = 32768;
    public byte[] buffer;
    public int byteOffset = Short.MIN_VALUE;
    private final Allocator allocator;
    public static final int[] nextLevelArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    public static final int[] levelSizeArray = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
    public static final int FIRST_LEVEL_SIZE = levelSizeArray[0];

    public ByteBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void dropBuffersAndReset() {
        if (this.bufferUpto != -1) {
            this.allocator.recycleByteBlocks(this.buffers, 0, 1 + this.bufferUpto);
            this.bufferUpto = -1;
            this.byteUpto = 32768;
            this.byteOffset = Short.MIN_VALUE;
            this.buffers = new byte[10][];
            this.buffer = null;
        }
    }

    public void reset() {
        if (this.bufferUpto != -1) {
            for (int i = 0; i < this.bufferUpto; ++i) {
                Arrays.fill(this.buffers[i], (byte)0);
            }
            Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
            if (this.bufferUpto > 0) {
                this.allocator.recycleByteBlocks(this.buffers, 1, 1 + this.bufferUpto);
            }
            this.bufferUpto = 0;
            this.byteUpto = 0;
            this.byteOffset = 0;
            this.buffer = this.buffers[0];
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            byte[][] byArrayArray = new byte[ArrayUtil.oversize(this.buffers.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.buffers, 0, byArrayArray, 0, this.buffers.length);
            this.buffers = byArrayArray;
        }
        byte[] byArray = this.allocator.getByteBlock();
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = byArray;
        ++this.bufferUpto;
        this.byteUpto = 0;
        this.byteOffset += 32768;
    }

    public int newSlice(int n) {
        if (this.byteUpto > 32768 - n) {
            this.nextBuffer();
        }
        int n2 = this.byteUpto;
        this.byteUpto += n;
        this.buffer[this.byteUpto - 1] = 16;
        return n2;
    }

    public int allocSlice(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xF;
        int n3 = nextLevelArray[n2];
        int n4 = levelSizeArray[n3];
        if (this.byteUpto > 32768 - n4) {
            this.nextBuffer();
        }
        int n5 = this.byteUpto;
        int n6 = n5 + this.byteOffset;
        this.byteUpto += n4;
        this.buffer[n5] = byArray[n - 3];
        this.buffer[n5 + 1] = byArray[n - 2];
        this.buffer[n5 + 2] = byArray[n - 1];
        byArray[n - 3] = (byte)(n6 >>> 24);
        byArray[n - 2] = (byte)(n6 >>> 16);
        byArray[n - 1] = (byte)(n6 >>> 8);
        byArray[n] = (byte)n6;
        this.buffer[this.byteUpto - 1] = (byte)(0x10 | n3);
        return n5 + 3;
    }

    public final BytesRef setBytesRef(BytesRef bytesRef, int n) {
        bytesRef.bytes = this.buffers[n >> 15];
        byte[] byArray = bytesRef.bytes;
        int n2 = n & Short.MAX_VALUE;
        if ((byArray[n2] & 0x80) == 0) {
            bytesRef.length = byArray[n2];
            bytesRef.offset = n2 + 1;
        } else {
            bytesRef.length = (byArray[n2] & 0x7F) + ((byArray[n2 + 1] & 0xFF) << 7);
            bytesRef.offset = n2 + 2;
        }
        assert (bytesRef.length >= 0);
        return bytesRef;
    }

    public final void copy(BytesRef bytesRef) {
        int n = bytesRef.length;
        int n2 = bytesRef.offset;
        int n3 = n + this.byteUpto - 32768;
        while (true) {
            if (n3 <= 0) {
                System.arraycopy(bytesRef.bytes, n2, this.buffer, this.byteUpto, n);
                this.byteUpto += n;
                break;
            }
            int n4 = n - n3;
            System.arraycopy(bytesRef.bytes, n2, this.buffer, this.byteUpto, n4);
            n2 += n4;
            n -= n4;
            this.nextBuffer();
            n3 -= 32768;
        }
    }

    public final void writePool(DataOutput dataOutput) throws IOException {
        int n = 0;
        for (int i = this.byteOffset; i > 0; i -= 32768) {
            dataOutput.writeBytes(this.buffers[n++], 32768);
        }
        dataOutput.writeBytes(this.buffers[n], this.byteUpto);
    }

    public static class DirectTrackingAllocator
    extends Allocator {
        private final AtomicLong bytesUsed;

        public DirectTrackingAllocator(AtomicLong atomicLong) {
            this(32768, atomicLong);
        }

        public DirectTrackingAllocator(int n, AtomicLong atomicLong) {
            super(n);
            this.bytesUsed = atomicLong;
        }

        @Override
        public byte[] getByteBlock() {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }

        @Override
        public void recycleByteBlocks(byte[][] byArray, int n, int n2) {
            this.bytesUsed.addAndGet(-((n2 - n) * this.blockSize));
            for (int i = n; i < n2; ++i) {
                byArray[i] = null;
            }
        }
    }

    public static final class DirectAllocator
    extends Allocator {
        public DirectAllocator() {
            this(32768);
        }

        public DirectAllocator(int n) {
            super(n);
        }

        @Override
        public void recycleByteBlocks(byte[][] byArray, int n, int n2) {
        }
    }

    public static abstract class Allocator {
        protected final int blockSize;

        public Allocator(int n) {
            this.blockSize = n;
        }

        public abstract void recycleByteBlocks(byte[][] var1, int var2, int var3);

        public void recycleByteBlocks(List<byte[]> list) {
            byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
            this.recycleByteBlocks(byArray, 0, byArray.length);
        }

        public byte[] getByteBlock() {
            return new byte[this.blockSize];
        }
    }
}

