/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class BitUtil {
    public static final byte[] ntzTable = new byte[]{8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    public static final byte[] nlzTable = new byte[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private BitUtil() {
    }

    public static int pop(long l) {
        l -= l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        l += l >>> 32;
        return (int)l & 0x7F;
    }

    public static long pop_array(long[] lArray, int n, int n2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        int n3;
        int n4 = n + n2;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        for (n3 = n; n3 <= n4 - 8; n3 += 8) {
            l7 = lArray[n3];
            l6 = lArray[n3 + 1];
            long l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 2];
            l6 = lArray[n3 + 3];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l3 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = lArray[n3 + 4];
            l6 = lArray[n3 + 5];
            l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 6];
            l6 = lArray[n3 + 7];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l2 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = l12 ^ l3;
            l = l12 & l3 | l7 & l2;
            l12 = l7 ^ l2;
            l9 += (long)BitUtil.pop(l);
        }
        if (n3 <= n4 - 4) {
            l = lArray[n3];
            l7 = lArray[n3 + 1];
            l6 = l10 ^ l;
            l5 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = lArray[n3 + 2];
            l7 = lArray[n3 + 3];
            l6 = l10 ^ l;
            l4 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = l11 ^ l5;
            l3 = l11 & l5 | l & l4;
            l11 = l ^ l4;
            l2 = l12 & l3;
            l12 ^= l3;
            l9 += (long)BitUtil.pop(l2);
            n3 += 4;
        }
        if (n3 <= n4 - 2) {
            l5 = lArray[n3];
            l4 = lArray[n3 + 1];
            l3 = l10 ^ l5;
            l2 = l10 & l5 | l3 & l4;
            l10 = l3 ^ l4;
            l = l11 & l2;
            l11 ^= l2;
            l7 = l12 & l;
            l12 ^= l;
            l9 += (long)BitUtil.pop(l7);
            n3 += 2;
        }
        if (n3 < n4) {
            l8 += (long)BitUtil.pop(lArray[n3]);
        }
        return l8 += (long)((BitUtil.pop(l12) << 2) + (BitUtil.pop(l11) << 1) + BitUtil.pop(l10)) + (l9 << 3);
    }

    public static long pop_intersect(long[] lArray, long[] lArray2, int n, int n2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        int n3;
        int n4 = n + n2;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        for (n3 = n; n3 <= n4 - 8; n3 += 8) {
            l7 = lArray[n3] & lArray2[n3];
            l6 = lArray[n3 + 1] & lArray2[n3 + 1];
            long l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 2] & lArray2[n3 + 2];
            l6 = lArray[n3 + 3] & lArray2[n3 + 3];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l3 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = lArray[n3 + 4] & lArray2[n3 + 4];
            l6 = lArray[n3 + 5] & lArray2[n3 + 5];
            l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 6] & lArray2[n3 + 6];
            l6 = lArray[n3 + 7] & lArray2[n3 + 7];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l2 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = l12 ^ l3;
            l = l12 & l3 | l7 & l2;
            l12 = l7 ^ l2;
            l9 += (long)BitUtil.pop(l);
        }
        if (n3 <= n4 - 4) {
            l = lArray[n3] & lArray2[n3];
            l7 = lArray[n3 + 1] & lArray2[n3 + 1];
            l6 = l10 ^ l;
            l5 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = lArray[n3 + 2] & lArray2[n3 + 2];
            l7 = lArray[n3 + 3] & lArray2[n3 + 3];
            l6 = l10 ^ l;
            l4 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = l11 ^ l5;
            l3 = l11 & l5 | l & l4;
            l11 = l ^ l4;
            l2 = l12 & l3;
            l12 ^= l3;
            l9 += (long)BitUtil.pop(l2);
            n3 += 4;
        }
        if (n3 <= n4 - 2) {
            l5 = lArray[n3] & lArray2[n3];
            l4 = lArray[n3 + 1] & lArray2[n3 + 1];
            l3 = l10 ^ l5;
            l2 = l10 & l5 | l3 & l4;
            l10 = l3 ^ l4;
            l = l11 & l2;
            l11 ^= l2;
            l7 = l12 & l;
            l12 ^= l;
            l9 += (long)BitUtil.pop(l7);
            n3 += 2;
        }
        if (n3 < n4) {
            l8 += (long)BitUtil.pop(lArray[n3] & lArray2[n3]);
        }
        return l8 += (long)((BitUtil.pop(l12) << 2) + (BitUtil.pop(l11) << 1) + BitUtil.pop(l10)) + (l9 << 3);
    }

    public static long pop_union(long[] lArray, long[] lArray2, int n, int n2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        int n3;
        int n4 = n + n2;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        for (n3 = n; n3 <= n4 - 8; n3 += 8) {
            l7 = lArray[n3] | lArray2[n3];
            l6 = lArray[n3 + 1] | lArray2[n3 + 1];
            long l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 2] | lArray2[n3 + 2];
            l6 = lArray[n3 + 3] | lArray2[n3 + 3];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l3 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = lArray[n3 + 4] | lArray2[n3 + 4];
            l6 = lArray[n3 + 5] | lArray2[n3 + 5];
            l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 6] | lArray2[n3 + 6];
            l6 = lArray[n3 + 7] | lArray2[n3 + 7];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l2 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = l12 ^ l3;
            l = l12 & l3 | l7 & l2;
            l12 = l7 ^ l2;
            l9 += (long)BitUtil.pop(l);
        }
        if (n3 <= n4 - 4) {
            l = lArray[n3] | lArray2[n3];
            l7 = lArray[n3 + 1] | lArray2[n3 + 1];
            l6 = l10 ^ l;
            l5 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = lArray[n3 + 2] | lArray2[n3 + 2];
            l7 = lArray[n3 + 3] | lArray2[n3 + 3];
            l6 = l10 ^ l;
            l4 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = l11 ^ l5;
            l3 = l11 & l5 | l & l4;
            l11 = l ^ l4;
            l2 = l12 & l3;
            l12 ^= l3;
            l9 += (long)BitUtil.pop(l2);
            n3 += 4;
        }
        if (n3 <= n4 - 2) {
            l5 = lArray[n3] | lArray2[n3];
            l4 = lArray[n3 + 1] | lArray2[n3 + 1];
            l3 = l10 ^ l5;
            l2 = l10 & l5 | l3 & l4;
            l10 = l3 ^ l4;
            l = l11 & l2;
            l11 ^= l2;
            l7 = l12 & l;
            l12 ^= l;
            l9 += (long)BitUtil.pop(l7);
            n3 += 2;
        }
        if (n3 < n4) {
            l8 += (long)BitUtil.pop(lArray[n3] | lArray2[n3]);
        }
        return l8 += (long)((BitUtil.pop(l12) << 2) + (BitUtil.pop(l11) << 1) + BitUtil.pop(l10)) + (l9 << 3);
    }

    public static long pop_andnot(long[] lArray, long[] lArray2, int n, int n2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        int n3;
        int n4 = n + n2;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        for (n3 = n; n3 <= n4 - 8; n3 += 8) {
            l7 = lArray[n3] & (lArray2[n3] ^ 0xFFFFFFFFFFFFFFFFL);
            l6 = lArray[n3 + 1] & (lArray2[n3 + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 2] & (lArray2[n3 + 2] ^ 0xFFFFFFFFFFFFFFFFL);
            l6 = lArray[n3 + 3] & (lArray2[n3 + 3] ^ 0xFFFFFFFFFFFFFFFFL);
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l3 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = lArray[n3 + 4] & (lArray2[n3 + 4] ^ 0xFFFFFFFFFFFFFFFFL);
            l6 = lArray[n3 + 5] & (lArray2[n3 + 5] ^ 0xFFFFFFFFFFFFFFFFL);
            l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 6] & (lArray2[n3 + 6] ^ 0xFFFFFFFFFFFFFFFFL);
            l6 = lArray[n3 + 7] & (lArray2[n3 + 7] ^ 0xFFFFFFFFFFFFFFFFL);
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l2 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = l12 ^ l3;
            l = l12 & l3 | l7 & l2;
            l12 = l7 ^ l2;
            l9 += (long)BitUtil.pop(l);
        }
        if (n3 <= n4 - 4) {
            l = lArray[n3] & (lArray2[n3] ^ 0xFFFFFFFFFFFFFFFFL);
            l7 = lArray[n3 + 1] & (lArray2[n3 + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            l6 = l10 ^ l;
            l5 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = lArray[n3 + 2] & (lArray2[n3 + 2] ^ 0xFFFFFFFFFFFFFFFFL);
            l7 = lArray[n3 + 3] & (lArray2[n3 + 3] ^ 0xFFFFFFFFFFFFFFFFL);
            l6 = l10 ^ l;
            l4 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = l11 ^ l5;
            l3 = l11 & l5 | l & l4;
            l11 = l ^ l4;
            l2 = l12 & l3;
            l12 ^= l3;
            l9 += (long)BitUtil.pop(l2);
            n3 += 4;
        }
        if (n3 <= n4 - 2) {
            l5 = lArray[n3] & (lArray2[n3] ^ 0xFFFFFFFFFFFFFFFFL);
            l4 = lArray[n3 + 1] & (lArray2[n3 + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            l3 = l10 ^ l5;
            l2 = l10 & l5 | l3 & l4;
            l10 = l3 ^ l4;
            l = l11 & l2;
            l11 ^= l2;
            l7 = l12 & l;
            l12 ^= l;
            l9 += (long)BitUtil.pop(l7);
            n3 += 2;
        }
        if (n3 < n4) {
            l8 += (long)BitUtil.pop(lArray[n3] & (lArray2[n3] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return l8 += (long)((BitUtil.pop(l12) << 2) + (BitUtil.pop(l11) << 1) + BitUtil.pop(l10)) + (l9 << 3);
    }

    public static long pop_xor(long[] lArray, long[] lArray2, int n, int n2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        int n3;
        int n4 = n + n2;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        for (n3 = n; n3 <= n4 - 8; n3 += 8) {
            l7 = lArray[n3] ^ lArray2[n3];
            l6 = lArray[n3 + 1] ^ lArray2[n3 + 1];
            long l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 2] ^ lArray2[n3 + 2];
            l6 = lArray[n3 + 3] ^ lArray2[n3 + 3];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l3 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = lArray[n3 + 4] ^ lArray2[n3 + 4];
            l6 = lArray[n3 + 5] ^ lArray2[n3 + 5];
            l13 = l10 ^ l7;
            l5 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = lArray[n3 + 6] ^ lArray2[n3 + 6];
            l6 = lArray[n3 + 7] ^ lArray2[n3 + 7];
            l13 = l10 ^ l7;
            l4 = l10 & l7 | l13 & l6;
            l10 = l13 ^ l6;
            l7 = l11 ^ l5;
            l2 = l11 & l5 | l7 & l4;
            l11 = l7 ^ l4;
            l7 = l12 ^ l3;
            l = l12 & l3 | l7 & l2;
            l12 = l7 ^ l2;
            l9 += (long)BitUtil.pop(l);
        }
        if (n3 <= n4 - 4) {
            l = lArray[n3] ^ lArray2[n3];
            l7 = lArray[n3 + 1] ^ lArray2[n3 + 1];
            l6 = l10 ^ l;
            l5 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = lArray[n3 + 2] ^ lArray2[n3 + 2];
            l7 = lArray[n3 + 3] ^ lArray2[n3 + 3];
            l6 = l10 ^ l;
            l4 = l10 & l | l6 & l7;
            l10 = l6 ^ l7;
            l = l11 ^ l5;
            l3 = l11 & l5 | l & l4;
            l11 = l ^ l4;
            l2 = l12 & l3;
            l12 ^= l3;
            l9 += (long)BitUtil.pop(l2);
            n3 += 4;
        }
        if (n3 <= n4 - 2) {
            l5 = lArray[n3] ^ lArray2[n3];
            l4 = lArray[n3 + 1] ^ lArray2[n3 + 1];
            l3 = l10 ^ l5;
            l2 = l10 & l5 | l3 & l4;
            l10 = l3 ^ l4;
            l = l11 & l2;
            l11 ^= l2;
            l7 = l12 & l;
            l12 ^= l;
            l9 += (long)BitUtil.pop(l7);
            n3 += 2;
        }
        if (n3 < n4) {
            l8 += (long)BitUtil.pop(lArray[n3] ^ lArray2[n3]);
        }
        return l8 += (long)((BitUtil.pop(l12) << 2) + (BitUtil.pop(l11) << 1) + BitUtil.pop(l10)) + (l9 << 3);
    }

    public static int ntz(long l) {
        int n = (int)l;
        int n2 = n & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2];
        }
        if (n != 0) {
            n2 = n >>> 8 & 0xFF;
            if (n2 != 0) {
                return ntzTable[n2] + 8;
            }
            n2 = n >>> 16 & 0xFF;
            if (n2 != 0) {
                return ntzTable[n2] + 16;
            }
            return ntzTable[n >>> 24] + 24;
        }
        int n3 = (int)(l >> 32);
        n2 = n3 & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2] + 32;
        }
        n2 = n3 >>> 8 & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2] + 40;
        }
        n2 = n3 >>> 16 & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2] + 48;
        }
        return ntzTable[n3 >>> 24] + 56;
    }

    public static int ntz(int n) {
        int n2 = n & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2];
        }
        n2 = n >>> 8 & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2] + 8;
        }
        n2 = n >>> 16 & 0xFF;
        if (n2 != 0) {
            return ntzTable[n2] + 16;
        }
        return ntzTable[n >>> 24] + 24;
    }

    public static int ntz2(long l) {
        int n = 0;
        int n2 = (int)l;
        if (n2 == 0) {
            n += 32;
            n2 = (int)(l >>> 32);
        }
        if ((n2 & 0xFFFF) == 0) {
            n += 16;
            n2 >>>= 16;
        }
        if ((n2 & 0xFF) == 0) {
            n += 8;
            n2 >>>= 8;
        }
        return ntzTable[n2 & 0xFF] + n;
    }

    public static int ntz3(long l) {
        int n = 1;
        int n2 = (int)l;
        if (n2 == 0) {
            n += 32;
            n2 = (int)(l >>> 32);
        }
        if ((n2 & 0xFFFF) == 0) {
            n += 16;
            n2 >>>= 16;
        }
        if ((n2 & 0xFF) == 0) {
            n += 8;
            n2 >>>= 8;
        }
        if ((n2 & 0xF) == 0) {
            n += 4;
            n2 >>>= 4;
        }
        if ((n2 & 3) == 0) {
            n += 2;
            n2 >>>= 2;
        }
        return n - (n2 & 1);
    }

    public static int nlz(long l) {
        int n = 0;
        int n2 = (int)(l >>> 32);
        if (n2 == 0) {
            n += 32;
            n2 = (int)l;
        }
        if ((n2 & 0xFFFF0000) == 0) {
            n += 16;
            n2 <<= 16;
        }
        if ((n2 & 0xFF000000) == 0) {
            n += 8;
            n2 <<= 8;
        }
        return n + nlzTable[n2 >>> 24];
    }

    public static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    public static boolean isPowerOfTwo(long l) {
        return (l & l - 1L) == 0L;
    }

    public static int nextHighestPowerOfTwo(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return ++n;
    }

    public static long nextHighestPowerOfTwo(long l) {
        --l;
        l |= l >> 1;
        l |= l >> 2;
        l |= l >> 4;
        l |= l >> 8;
        l |= l >> 16;
        l |= l >> 32;
        return ++l;
    }
}

