/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SorterTemplate;

public final class ArrayUtil {
    @Deprecated
    public ArrayUtil() {
    }

    public static int parseInt(char[] cArray) throws NumberFormatException {
        return ArrayUtil.parseInt(cArray, 0, cArray.length, 10);
    }

    public static int parseInt(char[] cArray, int n, int n2) throws NumberFormatException {
        return ArrayUtil.parseInt(cArray, n, n2, 10);
    }

    public static int parseInt(char[] cArray, int n, int n2, int n3) throws NumberFormatException {
        boolean bl;
        if (cArray == null || n3 < 2 || n3 > 36) {
            throw new NumberFormatException();
        }
        int n4 = 0;
        if (n2 == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl2 = bl = cArray[n + n4] == '-';
        if (bl && ++n4 == n2) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (bl) {
            ++n;
            --n2;
        }
        return ArrayUtil.parse(cArray, n, n2, n3, bl);
    }

    private static int parse(char[] cArray, int n, int n2, int n3, boolean bl) throws NumberFormatException {
        int n4 = Integer.MIN_VALUE / n3;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = Character.digit(cArray[i + n], n3);
            if (n6 == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (n4 > n5) {
                throw new NumberFormatException("Unable to parse");
            }
            int n7 = n5 * n3 - n6;
            if (n7 > n5) {
                throw new NumberFormatException("Unable to parse");
            }
            n5 = n7;
        }
        if (!bl && (n5 = -n5) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return n5;
    }

    public static int oversize(int n, int n2) {
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException("invalid array size " + n);
        }
        if (n == 0) {
            return 0;
        }
        int n4 = n >> 3;
        if (n4 < 3) {
            n4 = 3;
        }
        if ((n3 = n + n4) + 7 < 0) {
            return Integer.MAX_VALUE;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (n2) {
                case 4: {
                    return n3 + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return n3 + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return n3 + 7 & 0x7FFFFFF8;
                }
            }
            return n3;
        }
        switch (n2) {
            case 2: {
                return n3 + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return n3 + 3 & 0x7FFFFFFC;
            }
        }
        return n3;
    }

    public static int getShrinkSize(int n, int n2, int n3) {
        int n4 = ArrayUtil.oversize(n2, n3);
        if (n4 < n / 2) {
            return n4;
        }
        return n;
    }

    public static short[] grow(short[] sArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (sArray.length < n) {
            short[] sArray2 = new short[ArrayUtil.oversize(n, 2)];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    public static short[] grow(short[] sArray) {
        return ArrayUtil.grow(sArray, 1 + sArray.length);
    }

    public static float[] grow(float[] fArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (fArray.length < n) {
            float[] fArray2 = new float[ArrayUtil.oversize(n, 4)];
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            return fArray2;
        }
        return fArray;
    }

    public static float[] grow(float[] fArray) {
        return ArrayUtil.grow(fArray, 1 + fArray.length);
    }

    public static double[] grow(double[] dArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (dArray.length < n) {
            double[] dArray2 = new double[ArrayUtil.oversize(n, 8)];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }
        return dArray;
    }

    public static double[] grow(double[] dArray) {
        return ArrayUtil.grow(dArray, 1 + dArray.length);
    }

    public static short[] shrink(short[] sArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(sArray.length, n, 2);
        if (n2 != sArray.length) {
            short[] sArray2 = new short[n2];
            System.arraycopy(sArray, 0, sArray2, 0, n2);
            return sArray2;
        }
        return sArray;
    }

    public static int[] grow(int[] nArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (nArray.length < n) {
            int[] nArray2 = new int[ArrayUtil.oversize(n, 4)];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    public static int[] grow(int[] nArray) {
        return ArrayUtil.grow(nArray, 1 + nArray.length);
    }

    public static int[] shrink(int[] nArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(nArray.length, n, 4);
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            return nArray2;
        }
        return nArray;
    }

    public static long[] grow(long[] lArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (lArray.length < n) {
            long[] lArray2 = new long[ArrayUtil.oversize(n, 8)];
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            return lArray2;
        }
        return lArray;
    }

    public static long[] grow(long[] lArray) {
        return ArrayUtil.grow(lArray, 1 + lArray.length);
    }

    public static long[] shrink(long[] lArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(lArray.length, n, 8);
        if (n2 != lArray.length) {
            long[] lArray2 = new long[n2];
            System.arraycopy(lArray, 0, lArray2, 0, n2);
            return lArray2;
        }
        return lArray;
    }

    public static byte[] grow(byte[] byArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (byArray.length < n) {
            byte[] byArray2 = new byte[ArrayUtil.oversize(n, 1)];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] grow(byte[] byArray) {
        return ArrayUtil.grow(byArray, 1 + byArray.length);
    }

    public static byte[] shrink(byte[] byArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(byArray.length, n, 1);
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public static boolean[] grow(boolean[] blArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (blArray.length < n) {
            boolean[] blArray2 = new boolean[ArrayUtil.oversize(n, 1)];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            return blArray2;
        }
        return blArray;
    }

    public static boolean[] grow(boolean[] blArray) {
        return ArrayUtil.grow(blArray, 1 + blArray.length);
    }

    public static boolean[] shrink(boolean[] blArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(blArray.length, n, 1);
        if (n2 != blArray.length) {
            boolean[] blArray2 = new boolean[n2];
            System.arraycopy(blArray, 0, blArray2, 0, n2);
            return blArray2;
        }
        return blArray;
    }

    public static char[] grow(char[] cArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (cArray.length < n) {
            char[] cArray2 = new char[ArrayUtil.oversize(n, 2)];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            return cArray2;
        }
        return cArray;
    }

    public static char[] grow(char[] cArray) {
        return ArrayUtil.grow(cArray, 1 + cArray.length);
    }

    public static char[] shrink(char[] cArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(cArray.length, n, 2);
        if (n2 != cArray.length) {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            return cArray2;
        }
        return cArray;
    }

    public static int[][] grow(int[][] nArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (nArray.length < n) {
            int[][] nArrayArray = new int[ArrayUtil.oversize(n, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(nArray, 0, nArrayArray, 0, nArray.length);
            return nArrayArray;
        }
        return nArray;
    }

    public static int[][] grow(int[][] nArray) {
        return ArrayUtil.grow(nArray, 1 + nArray.length);
    }

    public static int[][] shrink(int[][] nArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(nArray.length, n, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (n2 != nArray.length) {
            int[][] nArrayArray = new int[n2][];
            System.arraycopy(nArray, 0, nArrayArray, 0, n2);
            return nArrayArray;
        }
        return nArray;
    }

    public static float[][] grow(float[][] fArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        if (fArray.length < n) {
            float[][] fArrayArray = new float[ArrayUtil.oversize(n, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(fArray, 0, fArrayArray, 0, fArray.length);
            return fArrayArray;
        }
        return fArray;
    }

    public static float[][] grow(float[][] fArray) {
        return ArrayUtil.grow(fArray, 1 + fArray.length);
    }

    public static float[][] shrink(float[][] fArray, int n) {
        assert (n >= 0) : "size must be positive (got " + n + "): likely integer overflow?";
        int n2 = ArrayUtil.getShrinkSize(fArray.length, n, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (n2 != fArray.length) {
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(fArray, 0, fArrayArray, 0, n2);
            return fArrayArray;
        }
        return fArray;
    }

    public static int hashCode(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            n3 = n3 * 31 + cArray[i];
        }
        return n3;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            n3 = n3 * 31 + byArray[i];
        }
        return n3;
    }

    public static boolean equals(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        if (n + n3 <= cArray.length && n2 + n3 <= cArray2.length) {
            for (int i = 0; i < n3; ++i) {
                if (cArray[n + i] == cArray2[n2 + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        if (n + n3 <= nArray.length && n2 + n3 <= nArray2.length) {
            for (int i = 0; i < n3; ++i) {
                if (nArray[n + i] == nArray2[n2 + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (int n2 : collection) {
            nArray[n++] = n2;
        }
        assert (n == nArray.length);
        return nArray;
    }

    private static <T> SorterTemplate getSorter(final T[] TArray, final Comparator<? super T> comparator) {
        return new SorterTemplate(){
            private T pivot;

            @Override
            protected void swap(int n, int n2) {
                Object object = TArray[n];
                TArray[n] = TArray[n2];
                TArray[n2] = object;
            }

            @Override
            protected int compare(int n, int n2) {
                return comparator.compare(TArray[n], TArray[n2]);
            }

            @Override
            protected void setPivot(int n) {
                this.pivot = TArray[n];
            }

            @Override
            protected int comparePivot(int n) {
                return comparator.compare(this.pivot, TArray[n]);
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getSorter(T[] TArray) {
        return new SorterTemplate((Comparable[])TArray){
            private T pivot;
            final /* synthetic */ Comparable[] val$a;
            {
                this.val$a = comparableArray;
            }

            @Override
            protected void swap(int n, int n2) {
                Comparable comparable = this.val$a[n];
                this.val$a[n] = this.val$a[n2];
                this.val$a[n2] = comparable;
            }

            @Override
            protected int compare(int n, int n2) {
                return this.val$a[n].compareTo(this.val$a[n2]);
            }

            @Override
            protected void setPivot(int n) {
                this.pivot = this.val$a[n];
            }

            @Override
            protected int comparePivot(int n) {
                return this.pivot.compareTo((Comparable)this.val$a[n]);
            }
        };
    }

    public static <T> void quickSort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayUtil.getSorter(TArray, comparator).quickSort(n, n2 - 1);
    }

    public static <T> void quickSort(T[] TArray, Comparator<? super T> comparator) {
        ArrayUtil.quickSort(TArray, 0, TArray.length, comparator);
    }

    public static <T extends Comparable<? super T>> void quickSort(T[] TArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayUtil.getSorter(TArray).quickSort(n, n2 - 1);
    }

    public static <T extends Comparable<? super T>> void quickSort(T[] TArray) {
        ArrayUtil.quickSort(TArray, (int)0, (int)TArray.length);
    }

    public static <T> void mergeSort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayUtil.getSorter(TArray, comparator).mergeSort(n, n2 - 1);
    }

    public static <T> void mergeSort(T[] TArray, Comparator<? super T> comparator) {
        ArrayUtil.mergeSort(TArray, 0, TArray.length, comparator);
    }

    public static <T extends Comparable<? super T>> void mergeSort(T[] TArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayUtil.getSorter(TArray).mergeSort(n, n2 - 1);
    }

    public static <T extends Comparable<? super T>> void mergeSort(T[] TArray) {
        ArrayUtil.mergeSort(TArray, (int)0, (int)TArray.length);
    }

    public static <T> void insertionSort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayUtil.getSorter(TArray, comparator).insertionSort(n, n2 - 1);
    }

    public static <T> void insertionSort(T[] TArray, Comparator<? super T> comparator) {
        ArrayUtil.insertionSort(TArray, 0, TArray.length, comparator);
    }

    public static <T extends Comparable<? super T>> void insertionSort(T[] TArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayUtil.getSorter(TArray).insertionSort(n, n2 - 1);
    }

    public static <T extends Comparable<? super T>> void insertionSort(T[] TArray) {
        ArrayUtil.insertionSort(TArray, (int)0, (int)TArray.length);
    }
}

