/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.store.RAMDirectory;

public class RAMFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ArrayList<byte[]> buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    protected long sizeInBytes;
    private long lastModified = System.currentTimeMillis();

    public RAMFile() {
    }

    RAMFile(RAMDirectory rAMDirectory) {
        this.directory = rAMDirectory;
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long l) {
        this.length = l;
    }

    public synchronized long getLastModified() {
        return this.lastModified;
    }

    protected synchronized void setLastModified(long l) {
        this.lastModified = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] addBuffer(int n) {
        byte[] byArray = this.newBuffer(n);
        RAMFile rAMFile = this;
        synchronized (rAMFile) {
            this.buffers.add(byArray);
            this.sizeInBytes += (long)n;
        }
        if (this.directory != null) {
            this.directory.sizeInBytes.getAndAdd(n);
        }
        return byArray;
    }

    protected final synchronized byte[] getBuffer(int n) {
        return this.buffers.get(n);
    }

    protected final synchronized int numBuffers() {
        return this.buffers.size();
    }

    protected byte[] newBuffer(int n) {
        return new byte[n];
    }

    public synchronized long getSizeInBytes() {
        return this.sizeInBytes;
    }
}

