/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class LockVerifyServer {
    private static String getTime(long l) {
        return "[" + (System.currentTimeMillis() - l) / 1000L + "s] ";
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.out.println("\nUsage: java org.apache.lucene.store.LockVerifyServer port\n");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[0]);
        ServerSocket serverSocket = new ServerSocket(n);
        serverSocket.setReuseAddress(true);
        System.out.println("\nReady on port " + n + "...");
        int n2 = 0;
        long l = System.currentTimeMillis();
        while (true) {
            Socket socket = serverSocket.accept();
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            boolean bl = false;
            if (n4 == 1) {
                if (n2 != 0) {
                    bl = true;
                    System.out.println(LockVerifyServer.getTime(l) + " ERROR: id " + n3 + " got lock, but " + n2 + " already holds the lock");
                }
                n2 = n3;
            } else if (n4 == 0) {
                if (n2 != n3) {
                    bl = true;
                    System.out.println(LockVerifyServer.getTime(l) + " ERROR: id " + n3 + " released the lock, but " + n2 + " is the one holding the lock");
                }
                n2 = 0;
            } else {
                throw new RuntimeException("unrecognized command " + n4);
            }
            System.out.print(".");
            if (bl) {
                outputStream.write(1);
            } else {
                outputStream.write(0);
            }
            outputStream.close();
            inputStream.close();
            socket.close();
        }
    }
}

