/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;

public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataInput(byte[] byArray) {
        this.reset(byArray);
    }

    public ByteArrayDataInput(byte[] byArray, int n, int n2) {
        this.reset(byArray, n, n2);
    }

    public ByteArrayDataInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] byArray) {
        this.reset(byArray, 0, byArray.length);
    }

    public int getPosition() {
        return this.pos;
    }

    public void reset(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.pos = n;
        this.limit = n + n2;
    }

    public boolean eof() {
        return this.pos == this.limit;
    }

    public void skipBytes(int n) {
        this.pos += n;
        assert (this.pos <= this.limit);
    }

    @Override
    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    @Override
    public int readInt() {
        assert (this.pos + 4 <= this.limit);
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    @Override
    public long readLong() {
        assert (this.pos + 8 <= this.limit);
        int n = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int n2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    @Override
    public int readVInt() {
        this.checkBounds();
        byte by = this.bytes[this.pos++];
        int n = by & 0x7F;
        int n2 = 7;
        while ((by & 0x80) != 0) {
            this.checkBounds();
            by = this.bytes[this.pos++];
            n |= (by & 0x7F) << n2;
            n2 += 7;
        }
        return n;
    }

    @Override
    public long readVLong() {
        this.checkBounds();
        byte by = this.bytes[this.pos++];
        long l = by & 0x7F;
        int n = 7;
        while ((by & 0x80) != 0) {
            this.checkBounds();
            by = this.bytes[this.pos++];
            l |= ((long)by & 0x7FL) << n;
            n += 7;
        }
        return l;
    }

    @Override
    public byte readByte() {
        this.checkBounds();
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) {
        assert (this.pos + n2 <= this.limit);
        System.arraycopy(this.bytes, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    private boolean checkBounds() {
        assert (this.pos < this.limit);
        return true;
    }
}

