/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanNearPayloadCheckQuery
extends SpanPositionCheckQuery {
    protected final Collection<byte[]> payloadToMatch;

    public SpanNearPayloadCheckQuery(SpanNearQuery spanNearQuery, Collection<byte[]> collection) {
        super(spanNearQuery);
        this.payloadToMatch = collection;
    }

    @Override
    protected SpanPositionCheckQuery.AcceptStatus acceptPosition(Spans spans) throws IOException {
        boolean bl = spans.isPayloadAvailable();
        if (bl) {
            Collection<byte[]> collection = spans.getPayload();
            if (collection.size() == this.payloadToMatch.size()) {
                int n = 0;
                block0: for (byte[] byArray : collection) {
                    for (byte[] byArray2 : this.payloadToMatch) {
                        if (!Arrays.equals(byArray, byArray2)) continue;
                        ++n;
                        continue block0;
                    }
                }
                if (n == this.payloadToMatch.size()) {
                    return SpanPositionCheckQuery.AcceptStatus.YES;
                }
                return SpanPositionCheckQuery.AcceptStatus.NO;
            }
            return SpanPositionCheckQuery.AcceptStatus.NO;
        }
        return SpanPositionCheckQuery.AcceptStatus.NO;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanPayCheck(");
        stringBuilder.append(this.match.toString(string));
        stringBuilder.append(", payloadRef: ");
        for (byte[] byArray : this.payloadToMatch) {
            ToStringUtils.byteArray(stringBuilder, byArray);
            stringBuilder.append(';');
        }
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        SpanNearPayloadCheckQuery spanNearPayloadCheckQuery = new SpanNearPayloadCheckQuery((SpanNearQuery)this.match.clone(), this.payloadToMatch);
        spanNearPayloadCheckQuery.setBoost(this.getBoost());
        return spanNearPayloadCheckQuery;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpanNearPayloadCheckQuery)) {
            return false;
        }
        SpanNearPayloadCheckQuery spanNearPayloadCheckQuery = (SpanNearPayloadCheckQuery)object;
        return ((Object)this.payloadToMatch).equals(spanNearPayloadCheckQuery.payloadToMatch) && this.match.equals(spanNearPayloadCheckQuery.match) && this.getBoost() == spanNearPayloadCheckQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = this.match.hashCode();
        n ^= n << 8 | n >>> 25;
        n ^= ((Object)this.payloadToMatch).hashCode();
        return n ^= Float.floatToRawIntBits(this.getBoost());
    }
}

