/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.PriorityQueue;

public class NearSpansUnordered
extends Spans {
    private SpanNearQuery query;
    private List<SpansCell> ordered = new ArrayList<SpansCell>();
    private Spans[] subSpans;
    private int slop;
    private SpansCell first;
    private SpansCell last;
    private int totalLength;
    private CellQueue queue;
    private SpansCell max;
    private boolean more = true;
    private boolean firstTime = true;

    public NearSpansUnordered(SpanNearQuery spanNearQuery, IndexReader indexReader) throws IOException {
        this.query = spanNearQuery;
        this.slop = spanNearQuery.getSlop();
        SpanQuery[] spanQueryArray = spanNearQuery.getClauses();
        this.queue = new CellQueue(spanQueryArray.length);
        this.subSpans = new Spans[spanQueryArray.length];
        for (int i = 0; i < spanQueryArray.length; ++i) {
            SpansCell spansCell = new SpansCell(spanQueryArray[i].getSpans(indexReader), i);
            this.ordered.add(spansCell);
            this.subSpans[i] = spansCell.spans;
        }
    }

    public Spans[] getSubSpans() {
        return this.subSpans;
    }

    @Override
    public boolean next() throws IOException {
        if (this.firstTime) {
            this.initList(true);
            this.listToQueue();
            this.firstTime = false;
        } else if (this.more) {
            if (this.min().next()) {
                this.queue.updateTop();
            } else {
                this.more = false;
            }
        }
        while (this.more) {
            boolean bl = false;
            if (this.min().doc() != this.max.doc()) {
                this.queueToList();
                bl = true;
            }
            while (this.more && this.first.doc() < this.last.doc()) {
                this.more = this.first.skipTo(this.last.doc());
                this.firstToLast();
                bl = true;
            }
            if (!this.more) {
                return false;
            }
            if (bl) {
                this.listToQueue();
                bl = false;
            }
            if (this.atMatch()) {
                return true;
            }
            this.more = this.min().next();
            if (!this.more) continue;
            this.queue.updateTop();
        }
        return false;
    }

    @Override
    public boolean skipTo(int n) throws IOException {
        if (this.firstTime) {
            this.initList(false);
            SpansCell spansCell = this.first;
            while (this.more && spansCell != null) {
                this.more = spansCell.skipTo(n);
                spansCell = spansCell.next;
            }
            if (this.more) {
                this.listToQueue();
            }
            this.firstTime = false;
        } else {
            while (this.more && this.min().doc() < n) {
                if (this.min().skipTo(n)) {
                    this.queue.updateTop();
                    continue;
                }
                this.more = false;
            }
        }
        return this.more && (this.atMatch() || this.next());
    }

    private SpansCell min() {
        return (SpansCell)this.queue.top();
    }

    @Override
    public int doc() {
        return this.min().doc();
    }

    @Override
    public int start() {
        return this.min().start();
    }

    @Override
    public int end() {
        return this.max.end();
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        SpansCell spansCell = this.first;
        while (spansCell != null) {
            if (spansCell.isPayloadAvailable()) {
                hashSet.addAll(spansCell.getPayload());
            }
            spansCell = spansCell.next;
        }
        return hashSet;
    }

    @Override
    public boolean isPayloadAvailable() {
        SpansCell spansCell = this.min();
        while (spansCell != null) {
            if (spansCell.isPayloadAvailable()) {
                return true;
            }
            spansCell = spansCell.next;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    private void initList(boolean bl) throws IOException {
        for (int i = 0; this.more && i < this.ordered.size(); ++i) {
            SpansCell spansCell = this.ordered.get(i);
            if (bl) {
                this.more = spansCell.next();
            }
            if (!this.more) continue;
            this.addToList(spansCell);
        }
    }

    private void addToList(SpansCell spansCell) throws IOException {
        if (this.last != null) {
            this.last.next = spansCell;
        } else {
            this.first = spansCell;
        }
        this.last = spansCell;
        spansCell.next = null;
    }

    private void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    private void queueToList() throws IOException {
        this.first = null;
        this.last = null;
        while (this.queue.top() != null) {
            this.addToList((SpansCell)this.queue.pop());
        }
    }

    private void listToQueue() {
        this.queue.clear();
        SpansCell spansCell = this.first;
        while (spansCell != null) {
            this.queue.add(spansCell);
            spansCell = spansCell.next;
        }
    }

    private boolean atMatch() {
        return this.min().doc() == this.max.doc() && this.max.end() - this.min().start() - this.totalLength <= this.slop;
    }

    private class SpansCell
    extends Spans {
        private Spans spans;
        private SpansCell next;
        private int length = -1;
        private int index;

        public SpansCell(Spans spans, int n) {
            this.spans = spans;
            this.index = n;
        }

        @Override
        public boolean next() throws IOException {
            return this.adjust(this.spans.next());
        }

        @Override
        public boolean skipTo(int n) throws IOException {
            return this.adjust(this.spans.skipTo(n));
        }

        private boolean adjust(boolean bl) {
            if (this.length != -1) {
                NearSpansUnordered.this.totalLength -= this.length;
            }
            if (bl) {
                this.length = this.end() - this.start();
                NearSpansUnordered.this.totalLength += this.length;
                if (NearSpansUnordered.this.max == null || this.doc() > NearSpansUnordered.this.max.doc() || this.doc() == NearSpansUnordered.this.max.doc() && this.end() > NearSpansUnordered.this.max.end()) {
                    NearSpansUnordered.this.max = this;
                }
            }
            NearSpansUnordered.this.more = bl;
            return bl;
        }

        @Override
        public int doc() {
            return this.spans.doc();
        }

        @Override
        public int start() {
            return this.spans.start();
        }

        @Override
        public int end() {
            return this.spans.end();
        }

        @Override
        public Collection<byte[]> getPayload() throws IOException {
            return new ArrayList<byte[]>(this.spans.getPayload());
        }

        @Override
        public boolean isPayloadAvailable() {
            return this.spans.isPayloadAvailable();
        }

        public String toString() {
            return this.spans.toString() + "#" + this.index;
        }
    }

    private class CellQueue
    extends PriorityQueue<SpansCell> {
        public CellQueue(int n) {
            this.initialize(n);
        }

        @Override
        protected final boolean lessThan(SpansCell spansCell, SpansCell spansCell2) {
            if (spansCell.doc() == spansCell2.doc()) {
                return NearSpansOrdered.docSpansOrdered(spansCell, spansCell2);
            }
            return spansCell.doc() < spansCell2.doc();
        }
    }
}

