/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class FieldMaskingSpanQuery
extends SpanQuery {
    private SpanQuery maskedQuery;
    private String field;

    public FieldMaskingSpanQuery(SpanQuery spanQuery, String string) {
        this.maskedQuery = spanQuery;
        this.field = string;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public SpanQuery getMaskedQuery() {
        return this.maskedQuery;
    }

    @Override
    public Spans getSpans(IndexReader indexReader) throws IOException {
        return this.maskedQuery.getSpans(indexReader);
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.maskedQuery.extractTerms(set);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return this.maskedQuery.createWeight(searcher);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        FieldMaskingSpanQuery fieldMaskingSpanQuery = null;
        SpanQuery spanQuery = (SpanQuery)this.maskedQuery.rewrite(indexReader);
        if (spanQuery != this.maskedQuery) {
            fieldMaskingSpanQuery = (FieldMaskingSpanQuery)this.clone();
            fieldMaskingSpanQuery.maskedQuery = spanQuery;
        }
        if (fieldMaskingSpanQuery != null) {
            return fieldMaskingSpanQuery;
        }
        return this;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mask(");
        stringBuilder.append(this.maskedQuery.toString(string));
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        stringBuilder.append(" as ");
        stringBuilder.append(this.field);
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FieldMaskingSpanQuery)) {
            return false;
        }
        FieldMaskingSpanQuery fieldMaskingSpanQuery = (FieldMaskingSpanQuery)object;
        return this.getField().equals(fieldMaskingSpanQuery.getField()) && this.getBoost() == fieldMaskingSpanQuery.getBoost() && this.getMaskedQuery().equals(fieldMaskingSpanQuery.getMaskedQuery());
    }

    @Override
    public int hashCode() {
        return this.getMaskedQuery().hashCode() ^ this.getField().hashCode() ^ Float.floatToRawIntBits(this.getBoost());
    }
}

