/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class WildcardTermEnum
extends FilteredTermEnum {
    final Term searchTerm;
    final String field;
    final String text;
    final String pre;
    final int preLen;
    boolean endEnum = false;
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';

    public WildcardTermEnum(IndexReader indexReader, Term term) throws IOException {
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        String string = this.searchTerm.text();
        int n = string.indexOf(42);
        int n2 = string.indexOf(63);
        int n3 = n;
        if (n3 == -1) {
            n3 = n2;
        } else if (n2 >= 0) {
            n3 = Math.min(n3, n2);
        }
        this.pre = n3 != -1 ? this.searchTerm.text().substring(0, n3) : "";
        this.preLen = this.pre.length();
        this.text = string.substring(this.preLen);
        this.setEnum(indexReader.terms(new Term(this.searchTerm.field(), this.pre)));
    }

    @Override
    protected final boolean termCompare(Term term) {
        String string;
        if (this.field == term.field() && (string = term.text()).startsWith(this.pre)) {
            return WildcardTermEnum.wildcardEquals(this.text, 0, string, this.preLen);
        }
        this.endEnum = true;
        return false;
    }

    @Override
    public float difference() {
        return 1.0f;
    }

    @Override
    public final boolean endEnum() {
        return this.endEnum;
    }

    public static final boolean wildcardEquals(String string, int n, String string2, int n2) {
        int n3 = n;
        int n4 = n2;
        while (true) {
            int n5;
            boolean bl;
            boolean bl2 = n4 >= string2.length();
            boolean bl3 = bl = n3 >= string.length();
            if (bl2) {
                n5 = 1;
                int n6 = n3;
                while (n6 < string.length() && n5 != 0) {
                    char c = string.charAt(n6);
                    if (c != '?' && c != '*') {
                        n5 = 0;
                        continue;
                    }
                    if (c == '?') {
                        return false;
                    }
                    ++n6;
                }
                if (n5 != 0) {
                    return true;
                }
            }
            if (bl2 || bl) break;
            if (string.charAt(n3) != '?') {
                if (string.charAt(n3) == '*') {
                    while (n3 < string.length() && string.charAt(n3) == '*') {
                        ++n3;
                    }
                    for (n5 = string2.length(); n5 >= n4; --n5) {
                        if (!WildcardTermEnum.wildcardEquals(string, n3, string2, n5)) continue;
                        return true;
                    }
                    break;
                }
                if (string.charAt(n3) != string2.charAt(n4)) break;
            }
            ++n3;
            ++n4;
        }
        return false;
    }
}

