/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

public class TopDocs
implements Serializable {
    public int totalHits;
    public ScoreDoc[] scoreDocs;
    private float maxScore;

    public float getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(float f) {
        this.maxScore = f;
    }

    TopDocs(int n, ScoreDoc[] scoreDocArray) {
        this(n, scoreDocArray, Float.NaN);
    }

    public TopDocs(int n, ScoreDoc[] scoreDocArray, float f) {
        this.totalHits = n;
        this.scoreDocs = scoreDocArray;
        this.maxScore = f;
    }

    public static TopDocs merge(Sort sort, int n, TopDocs[] topDocsArray) throws IOException {
        PriorityQueue priorityQueue = sort == null ? new ScoreMergeSortQueue(topDocsArray) : new MergeSortQueue(sort, topDocsArray);
        int n2 = 0;
        int n3 = 0;
        float f = Float.MIN_VALUE;
        for (int i = 0; i < topDocsArray.length; ++i) {
            TopDocs topDocs = topDocsArray[i];
            if (topDocs.scoreDocs == null || topDocs.scoreDocs.length <= 0) continue;
            n2 += topDocs.totalHits;
            n3 += topDocs.scoreDocs.length;
            priorityQueue.add(new ShardRef(i));
            f = Math.max(f, topDocs.getMaxScore());
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[Math.min(n, n3)];
        for (int i = 0; i < scoreDocArray.length; ++i) {
            assert (priorityQueue.size() > 0);
            ShardRef shardRef = (ShardRef)priorityQueue.pop();
            ScoreDoc scoreDoc = topDocsArray[shardRef.shardIndex].scoreDocs[shardRef.hitIndex++];
            scoreDoc.shardIndex = shardRef.shardIndex;
            scoreDocArray[i] = scoreDoc;
            if (shardRef.hitIndex >= topDocsArray[shardRef.shardIndex].scoreDocs.length) continue;
            priorityQueue.add(shardRef);
        }
        if (sort == null) {
            return new TopDocs(n2, scoreDocArray, f);
        }
        return new TopFieldDocs(n2, scoreDocArray, sort.getSort(), f);
    }

    private static class MergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;
        final FieldComparator[] comparators;
        final int[] reverseMul;

        public MergeSortQueue(Sort sort, TopDocs[] topDocsArray) throws IOException {
            this.initialize(topDocsArray.length);
            this.shardHits = new ScoreDoc[topDocsArray.length][];
            for (int i = 0; i < topDocsArray.length; ++i) {
                ScoreDoc[] scoreDocArray = topDocsArray[i].scoreDocs;
                if (scoreDocArray == null) continue;
                this.shardHits[i] = scoreDocArray;
                for (int j = 0; j < scoreDocArray.length; ++j) {
                    ScoreDoc scoreDoc = scoreDocArray[j];
                    if (!(scoreDoc instanceof FieldDoc)) {
                        throw new IllegalArgumentException("shard " + i + " was not sorted by the provided Sort (expected FieldDoc but got ScoreDoc)");
                    }
                    FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                    if (fieldDoc.fields != null) continue;
                    throw new IllegalArgumentException("shard " + i + " did not set sort field values (FieldDoc.fields is null); you must pass fillFields=true to IndexSearcher.search on each shard");
                }
            }
            SortField[] sortFieldArray = sort.getSort();
            this.comparators = new FieldComparator[sortFieldArray.length];
            this.reverseMul = new int[sortFieldArray.length];
            for (int i = 0; i < sortFieldArray.length; ++i) {
                SortField sortField = sortFieldArray[i];
                this.comparators[i] = sortField.getComparator(1, i);
                this.reverseMul[i] = sortField.getReverse() ? -1 : 1;
            }
        }

        @Override
        public boolean lessThan(ShardRef shardRef, ShardRef shardRef2) {
            assert (shardRef != shardRef2);
            FieldDoc fieldDoc = (FieldDoc)this.shardHits[shardRef.shardIndex][shardRef.hitIndex];
            FieldDoc fieldDoc2 = (FieldDoc)this.shardHits[shardRef2.shardIndex][shardRef2.hitIndex];
            for (int i = 0; i < this.comparators.length; ++i) {
                FieldComparator fieldComparator = this.comparators[i];
                int n = this.reverseMul[i] * fieldComparator.compareValues(fieldDoc.fields[i], fieldDoc2.fields[i]);
                if (n == 0) continue;
                return n < 0;
            }
            if (shardRef.shardIndex < shardRef2.shardIndex) {
                return true;
            }
            if (shardRef.shardIndex > shardRef2.shardIndex) {
                return false;
            }
            assert (shardRef.hitIndex != shardRef2.hitIndex);
            return shardRef.hitIndex < shardRef2.hitIndex;
        }
    }

    private static class ScoreMergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;

        public ScoreMergeSortQueue(TopDocs[] topDocsArray) {
            this.initialize(topDocsArray.length);
            this.shardHits = new ScoreDoc[topDocsArray.length][];
            for (int i = 0; i < topDocsArray.length; ++i) {
                this.shardHits[i] = topDocsArray[i].scoreDocs;
            }
        }

        @Override
        public boolean lessThan(ShardRef shardRef, ShardRef shardRef2) {
            assert (shardRef != shardRef2);
            float f = this.shardHits[shardRef.shardIndex][shardRef.hitIndex].score;
            float f2 = this.shardHits[shardRef2.shardIndex][shardRef2.hitIndex].score;
            if (f < f2) {
                return false;
            }
            if (f > f2) {
                return true;
            }
            if (shardRef.shardIndex < shardRef2.shardIndex) {
                return true;
            }
            if (shardRef.shardIndex > shardRef2.shardIndex) {
                return false;
            }
            assert (shardRef.hitIndex != shardRef2.hitIndex);
            return shardRef.hitIndex < shardRef2.hitIndex;
        }
    }

    private static class ShardRef {
        final int shardIndex;
        int hitIndex;

        public ShardRef(int n) {
            this.shardIndex = n;
        }

        public String toString() {
            return "ShardRef(shardIndex=" + this.shardIndex + " hitIndex=" + this.hitIndex + ")";
        }
    }
}

