/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermCollectingRewrite;
import org.apache.lucene.search.TermQuery;

public abstract class ScoringRewrite<Q extends Query>
extends TermCollectingRewrite<Q> {
    public static final ScoringRewrite<BooleanQuery> SCORING_BOOLEAN_QUERY_REWRITE = new ScoringRewrite<BooleanQuery>(){

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery booleanQuery, Term term, float f) {
            TermQuery termQuery = new TermQuery(term);
            termQuery.setBoost(f);
            booleanQuery.add(termQuery, BooleanClause.Occur.SHOULD);
        }

        protected Object readResolve() {
            return SCORING_BOOLEAN_QUERY_REWRITE;
        }
    };
    public static final MultiTermQuery.RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = new MultiTermQuery.RewriteMethod(){

        @Override
        public Query rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
            BooleanQuery booleanQuery = SCORING_BOOLEAN_QUERY_REWRITE.rewrite(indexReader, multiTermQuery);
            if (booleanQuery.clauses().isEmpty()) {
                return booleanQuery;
            }
            ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(booleanQuery);
            constantScoreQuery.setBoost(multiTermQuery.getBoost());
            return constantScoreQuery;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;
        }
    };

    public Q rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
        Object q = this.getTopLevelQuery();
        int[] nArray = new int[1];
        this.collectTerms(indexReader, multiTermQuery, new TermCollectingRewrite.TermCollector((Query)q, multiTermQuery, nArray){
            final /* synthetic */ Query val$result;
            final /* synthetic */ MultiTermQuery val$query;
            final /* synthetic */ int[] val$size;
            {
                this.val$result = query;
                this.val$query = multiTermQuery;
                this.val$size = nArray;
            }

            @Override
            public boolean collect(Term term, float f) throws IOException {
                ScoringRewrite.this.addClause(this.val$result, term, this.val$query.getBoost() * f);
                this.val$size[0] = this.val$size[0] + 1;
                return true;
            }
        });
        multiTermQuery.incTotalNumberOfTerms(nArray[0]);
        return q;
    }
}

