/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.util.ArrayUtil;

public class QueryTermVector
implements TermFreqVector {
    private String[] terms = new String[0];
    private int[] termFreqs = new int[0];

    @Override
    public String getField() {
        return null;
    }

    public QueryTermVector(String[] stringArray) {
        this.processTerms(stringArray);
    }

    public QueryTermVector(String string, Analyzer analyzer) {
        if (analyzer != null) {
            TokenStream tokenStream;
            try {
                tokenStream = analyzer.reusableTokenStream("", new StringReader(string));
            }
            catch (IOException iOException) {
                tokenStream = null;
            }
            if (tokenStream != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    boolean bl = false;
                    tokenStream.reset();
                    CharTermAttribute charTermAttribute = tokenStream.addAttribute(CharTermAttribute.class);
                    bl = tokenStream.incrementToken();
                    while (bl) {
                        arrayList.add(charTermAttribute.toString());
                        bl = tokenStream.incrementToken();
                    }
                    this.processTerms(arrayList.toArray(new String[arrayList.size()]));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void processTerms(String[] stringArray) {
        if (stringArray != null) {
            int n;
            ArrayUtil.quickSort((Comparable[])stringArray);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray.length);
            ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(stringArray.length);
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                Integer n3 = (Integer)hashMap.get(string);
                if (n3 == null) {
                    hashMap.put(string, n2++);
                    arrayList.add(string);
                    arrayList2.add(1);
                    continue;
                }
                Integer n4 = (Integer)arrayList2.get(n3);
                arrayList2.set(n3, n4 + 1);
            }
            this.terms = arrayList.toArray(this.terms);
            this.termFreqs = new int[arrayList2.size()];
            n = 0;
            for (Integer n3 : arrayList2) {
                this.termFreqs[n++] = n3;
            }
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.terms[i]).append('/').append(this.termFreqs[i]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public int size() {
        return this.terms.length;
    }

    @Override
    public String[] getTerms() {
        return this.terms;
    }

    @Override
    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    @Override
    public int indexOf(String string) {
        int n = Arrays.binarySearch(this.terms, string);
        return n >= 0 ? n : -1;
    }

    @Override
    public int[] indexesOf(String[] stringArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.indexOf(stringArray[i]);
        }
        return nArray;
    }
}

