/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;

final class PhrasePositions {
    int doc;
    int position;
    int count;
    int offset;
    final int ord;
    TermPositions tp;
    PhrasePositions next;
    PhrasePositions nextRepeating;

    PhrasePositions(TermPositions termPositions, int n, int n2) {
        this.tp = termPositions;
        this.offset = n;
        this.ord = n2;
    }

    final boolean next() throws IOException {
        if (!this.tp.next()) {
            this.tp.close();
            this.doc = Integer.MAX_VALUE;
            return false;
        }
        this.doc = this.tp.doc();
        this.position = 0;
        return true;
    }

    final boolean skipTo(int n) throws IOException {
        if (!this.tp.skipTo(n)) {
            this.tp.close();
            this.doc = Integer.MAX_VALUE;
            return false;
        }
        this.doc = this.tp.doc();
        this.position = 0;
        return true;
    }

    final void firstPosition() throws IOException {
        this.count = this.tp.freq();
        this.nextPosition();
    }

    final boolean nextPosition() throws IOException {
        if (this.count-- > 0) {
            this.position = this.tp.nextPosition() - this.offset;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "d:" + this.doc + " o:" + this.offset + " p:" + this.position + " c:" + this.count;
        if (this.nextRepeating != null) {
            string = string + " rpt[ " + this.nextRepeating + " ]";
        }
        return string;
    }
}

