/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class MatchAllDocsQuery
extends Query {
    private final String normsField;

    public MatchAllDocsQuery() {
        this(null);
    }

    public MatchAllDocsQuery(String string) {
        this.normsField = string;
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new MatchAllDocsWeight(searcher);
    }

    @Override
    public void extractTerms(Set<Term> set) {
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*:*");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MatchAllDocsQuery)) {
            return false;
        }
        MatchAllDocsQuery matchAllDocsQuery = (MatchAllDocsQuery)object;
        return this.getBoost() == matchAllDocsQuery.getBoost();
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ 0x1AA71190;
    }

    private class MatchAllDocsWeight
    extends Weight {
        private Similarity similarity;
        private float queryWeight;
        private float queryNorm;

        public MatchAllDocsWeight(Searcher searcher) {
            this.similarity = searcher.getSimilarity();
        }

        public String toString() {
            return "weight(" + MatchAllDocsQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return MatchAllDocsQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() {
            this.queryWeight = MatchAllDocsQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            return new MatchAllScorer(indexReader, this.similarity, this, MatchAllDocsQuery.this.normsField != null ? indexReader.norms(MatchAllDocsQuery.this.normsField) : null);
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) {
            ComplexExplanation complexExplanation = new ComplexExplanation(true, this.getValue(), "MatchAllDocsQuery, product of:");
            if (MatchAllDocsQuery.this.getBoost() != 1.0f) {
                complexExplanation.addDetail(new Explanation(MatchAllDocsQuery.this.getBoost(), "boost"));
            }
            complexExplanation.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            return complexExplanation;
        }
    }

    private class MatchAllScorer
    extends Scorer {
        final TermDocs termDocs;
        final float score;
        final byte[] norms;
        private int doc;

        MatchAllScorer(IndexReader indexReader, Similarity similarity, Weight weight, byte[] byArray) throws IOException {
            super(similarity, weight);
            this.doc = -1;
            this.termDocs = indexReader.termDocs(null);
            this.score = weight.getValue();
            this.norms = byArray;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.termDocs.next() ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        @Override
        public float score() {
            return this.norms == null ? this.score : this.score * this.getSimilarity().decodeNormValue(this.norms[this.docID()]);
        }

        @Override
        public int advance(int n) throws IOException {
            this.doc = this.termDocs.skipTo(n) ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }
    }
}

