/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

class FieldDocSortedHitQueue
extends PriorityQueue<FieldDoc> {
    volatile SortField[] fields = null;
    volatile Collator[] collators = null;
    volatile FieldComparator[] comparators = null;

    FieldDocSortedHitQueue(int n) {
        this.initialize(n);
    }

    void setFields(SortField[] sortFieldArray) throws IOException {
        this.fields = sortFieldArray;
        this.collators = this.hasCollators(sortFieldArray);
        this.comparators = new FieldComparator[sortFieldArray.length];
        for (int i = 0; i < sortFieldArray.length; ++i) {
            this.comparators[i] = sortFieldArray[i].getComparator(1, i);
        }
    }

    SortField[] getFields() {
        return this.fields;
    }

    private Collator[] hasCollators(SortField[] sortFieldArray) {
        if (sortFieldArray == null) {
            return null;
        }
        Collator[] collatorArray = new Collator[sortFieldArray.length];
        for (int i = 0; i < sortFieldArray.length; ++i) {
            Locale locale = sortFieldArray[i].getLocale();
            if (locale == null) continue;
            collatorArray[i] = Collator.getInstance(locale);
        }
        return collatorArray;
    }

    @Override
    protected final boolean lessThan(FieldDoc fieldDoc, FieldDoc fieldDoc2) {
        int n = this.fields.length;
        int n2 = 0;
        for (int i = 0; i < n && n2 == 0; ++i) {
            int n3 = this.fields[i].getType();
            if (n3 == 3) {
                String string = (String)fieldDoc.fields[i];
                String string2 = (String)fieldDoc2.fields[i];
                n2 = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : (this.fields[i].getLocale() == null ? string.compareTo(string2) : this.collators[i].compare(string, string2)));
            } else {
                n2 = this.comparators[i].compareValues(fieldDoc.fields[i], fieldDoc2.fields[i]);
            }
            if (!this.fields[i].getReverse()) continue;
            n2 = -n2;
        }
        if (n2 == 0) {
            return fieldDoc.doc > fieldDoc2.doc;
        }
        return n2 > 0;
    }
}

