/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class FieldCacheTermsFilter
extends Filter {
    private String field;
    private String[] terms;

    public FieldCacheTermsFilter(String string, String ... stringArray) {
        this.field = string;
        this.terms = stringArray;
    }

    public FieldCache getFieldCache() {
        return FieldCache.DEFAULT;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        return new FieldCacheTermsFilterDocIdSet(this.getFieldCache().getStringIndex(indexReader, this.field));
    }

    protected class FieldCacheTermsFilterDocIdSet
    extends DocIdSet {
        private FieldCache.StringIndex fcsi;
        private FixedBitSet bits;

        public FieldCacheTermsFilterDocIdSet(FieldCache.StringIndex stringIndex) {
            this.fcsi = stringIndex;
            this.bits = new FixedBitSet(this.fcsi.lookup.length);
            for (int i = 0; i < FieldCacheTermsFilter.this.terms.length; ++i) {
                int n = this.fcsi.binarySearchLookup(FieldCacheTermsFilter.this.terms[i]);
                if (n <= 0) continue;
                this.bits.set(n);
            }
        }

        @Override
        public DocIdSetIterator iterator() {
            return new FieldCacheTermsFilterDocIdSetIterator();
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        protected class FieldCacheTermsFilterDocIdSetIterator
        extends DocIdSetIterator {
            private int doc = -1;

            protected FieldCacheTermsFilterDocIdSetIterator() {
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                try {
                    while (!FieldCacheTermsFilterDocIdSet.this.bits.get(((FieldCacheTermsFilterDocIdSet)FieldCacheTermsFilterDocIdSet.this).fcsi.order[++this.doc])) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }

            @Override
            public int advance(int n) {
                try {
                    this.doc = n;
                    while (!FieldCacheTermsFilterDocIdSet.this.bits.get(((FieldCacheTermsFilterDocIdSet)FieldCacheTermsFilterDocIdSet.this).fcsi.order[this.doc])) {
                        ++this.doc;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }
        }
    }
}

