/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ScorerDocQueue;

class DisjunctionSumScorer
extends Scorer {
    private final int nrScorers;
    protected final List<Scorer> subScorers;
    private final int minimumNrMatchers;
    private ScorerDocQueue scorerDocQueue;
    private int currentDoc = -1;
    protected int nrMatchers = -1;
    private double currentScore = Double.NaN;

    public DisjunctionSumScorer(Weight weight, List<Scorer> list, int n) throws IOException {
        super(weight);
        this.nrScorers = list.size();
        if (n <= 0) {
            throw new IllegalArgumentException("Minimum nr of matchers must be positive");
        }
        if (this.nrScorers <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.minimumNrMatchers = n;
        this.subScorers = list;
        this.initScorerDocQueue();
    }

    public DisjunctionSumScorer(Weight weight, List<Scorer> list) throws IOException {
        this(weight, list, 1);
    }

    private void initScorerDocQueue() throws IOException {
        this.scorerDocQueue = new ScorerDocQueue(this.nrScorers);
        for (Scorer scorer : this.subScorers) {
            if (scorer.nextDoc() == Integer.MAX_VALUE) continue;
            this.scorerDocQueue.insert(scorer);
        }
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        while (this.nextDoc() != Integer.MAX_VALUE) {
            collector.collect(this.currentDoc);
        }
    }

    @Override
    protected boolean score(Collector collector, int n, int n2) throws IOException {
        collector.setScorer(this);
        while (this.currentDoc < n) {
            collector.collect(this.currentDoc);
            if (this.nextDoc() != Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.scorerDocQueue.size() < this.minimumNrMatchers || !this.advanceAfterCurrent()) {
            this.currentDoc = Integer.MAX_VALUE;
        }
        return this.currentDoc;
    }

    protected boolean advanceAfterCurrent() throws IOException {
        do {
            this.currentDoc = this.scorerDocQueue.topDoc();
            this.currentScore = this.scorerDocQueue.topScore();
            this.nrMatchers = 1;
            while ((this.scorerDocQueue.topNextAndAdjustElsePop() || this.scorerDocQueue.size() != 0) && this.scorerDocQueue.topDoc() == this.currentDoc) {
                this.currentScore += (double)this.scorerDocQueue.topScore();
                ++this.nrMatchers;
            }
            if (this.nrMatchers < this.minimumNrMatchers) continue;
            return true;
        } while (this.scorerDocQueue.size() >= this.minimumNrMatchers);
        return false;
    }

    @Override
    public float score() throws IOException {
        return (float)this.currentScore;
    }

    @Override
    public int docID() {
        return this.currentDoc;
    }

    public int nrMatchers() {
        return this.nrMatchers;
    }

    @Override
    public int advance(int n) throws IOException {
        if (this.scorerDocQueue.size() < this.minimumNrMatchers) {
            this.currentDoc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (n <= this.currentDoc) {
            return this.currentDoc;
        }
        do {
            if (this.scorerDocQueue.topDoc() < n) continue;
            return this.advanceAfterCurrent() ? this.currentDoc : (this.currentDoc = Integer.MAX_VALUE);
        } while (this.scorerDocQueue.topSkipToAndAdjustElsePop(n) || this.scorerDocQueue.size() >= this.minimumNrMatchers);
        this.currentDoc = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }
}

