/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class BooleanScorer2
extends Scorer {
    private final List<Scorer> requiredScorers;
    private final List<Scorer> optionalScorers;
    private final List<Scorer> prohibitedScorers;
    private final Coordinator coordinator;
    private final Scorer countingSumScorer;
    private final int minNrShouldMatch;
    private int doc = -1;

    public BooleanScorer2(Weight weight, boolean bl, Similarity similarity, int n, List<Scorer> list, List<Scorer> list2, List<Scorer> list3, int n2) throws IOException {
        super(weight);
        if (n < 0) {
            throw new IllegalArgumentException("Minimum number of optional scorers should not be negative");
        }
        this.coordinator = new Coordinator();
        this.minNrShouldMatch = n;
        this.coordinator.maxCoord = n2;
        this.optionalScorers = list3;
        this.requiredScorers = list;
        this.prohibitedScorers = list2;
        this.coordinator.init(similarity, bl);
        this.countingSumScorer = this.makeCountingSumScorer(bl, similarity);
    }

    private Scorer countingDisjunctionSumScorer(List<Scorer> list, int n) throws IOException {
        return new DisjunctionSumScorer(this.weight, list, n){
            private int lastScoredDoc;
            private float lastDocScore;
            {
                this.lastScoredDoc = -1;
                this.lastDocScore = Float.NaN;
            }

            @Override
            public float score() throws IOException {
                int n = this.docID();
                if (n >= this.lastScoredDoc) {
                    if (n > this.lastScoredDoc) {
                        this.lastDocScore = super.score();
                        this.lastScoredDoc = n;
                    }
                    ((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers += this.nrMatchers;
                }
                return this.lastDocScore;
            }
        };
    }

    private Scorer countingConjunctionSumScorer(boolean bl, Similarity similarity, List<Scorer> list) throws IOException {
        final int n = list.size();
        return new ConjunctionScorer(this.weight, bl ? 1.0f : similarity.coord(list.size(), list.size()), list){
            private int lastScoredDoc;
            private float lastDocScore;
            {
                super(weight, f, collection);
                this.lastScoredDoc = -1;
                this.lastDocScore = Float.NaN;
            }

            @Override
            public float score() throws IOException {
                int n2 = this.docID();
                if (n2 >= this.lastScoredDoc) {
                    if (n2 > this.lastScoredDoc) {
                        this.lastDocScore = super.score();
                        this.lastScoredDoc = n2;
                    }
                    ((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers += n;
                }
                return this.lastDocScore;
            }
        };
    }

    private Scorer dualConjunctionSumScorer(boolean bl, Similarity similarity, Scorer scorer, Scorer scorer2) throws IOException {
        return new ConjunctionScorer(this.weight, bl ? 1.0f : similarity.coord(2, 2), scorer, scorer2);
    }

    private Scorer makeCountingSumScorer(boolean bl, Similarity similarity) throws IOException {
        return this.requiredScorers.size() == 0 ? this.makeCountingSumScorerNoReq(bl, similarity) : this.makeCountingSumScorerSomeReq(bl, similarity);
    }

    private Scorer makeCountingSumScorerNoReq(boolean bl, Similarity similarity) throws IOException {
        int n;
        int n2 = n = this.minNrShouldMatch < 1 ? 1 : this.minNrShouldMatch;
        Scorer scorer = this.optionalScorers.size() > n ? this.countingDisjunctionSumScorer(this.optionalScorers, n) : (this.optionalScorers.size() == 1 ? new SingleMatchScorer(this.optionalScorers.get(0)) : this.countingConjunctionSumScorer(bl, similarity, this.optionalScorers));
        return this.addProhibitedScorers(scorer);
    }

    private Scorer makeCountingSumScorerSomeReq(boolean bl, Similarity similarity) throws IOException {
        Scorer scorer;
        if (this.optionalScorers.size() == this.minNrShouldMatch) {
            ArrayList<Scorer> arrayList = new ArrayList<Scorer>(this.requiredScorers);
            arrayList.addAll(this.optionalScorers);
            return this.addProhibitedScorers(this.countingConjunctionSumScorer(bl, similarity, arrayList));
        }
        Scorer scorer2 = scorer = this.requiredScorers.size() == 1 ? new SingleMatchScorer(this.requiredScorers.get(0)) : this.countingConjunctionSumScorer(bl, similarity, this.requiredScorers);
        if (this.minNrShouldMatch > 0) {
            return this.addProhibitedScorers(this.dualConjunctionSumScorer(bl, similarity, scorer, this.countingDisjunctionSumScorer(this.optionalScorers, this.minNrShouldMatch)));
        }
        return new ReqOptSumScorer(this.addProhibitedScorers(scorer), this.optionalScorers.size() == 1 ? new SingleMatchScorer(this.optionalScorers.get(0)) : this.countingDisjunctionSumScorer(this.optionalScorers, 1));
    }

    private Scorer addProhibitedScorers(Scorer scorer) throws IOException {
        return this.prohibitedScorers.size() == 0 ? scorer : new ReqExclScorer(scorer, this.prohibitedScorers.size() == 1 ? this.prohibitedScorers.get(0) : new DisjunctionSumScorer(this.weight, this.prohibitedScorers));
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        while ((this.doc = this.countingSumScorer.nextDoc()) != Integer.MAX_VALUE) {
            collector.collect(this.doc);
        }
    }

    @Override
    protected boolean score(Collector collector, int n, int n2) throws IOException {
        this.doc = n2;
        collector.setScorer(this);
        while (this.doc < n) {
            collector.collect(this.doc);
            this.doc = this.countingSumScorer.nextDoc();
        }
        return this.doc != Integer.MAX_VALUE;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        this.doc = this.countingSumScorer.nextDoc();
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        this.coordinator.nrMatchers = 0;
        float f = this.countingSumScorer.score();
        return f * this.coordinator.coordFactors[this.coordinator.nrMatchers];
    }

    @Override
    public float freq() {
        return this.coordinator.nrMatchers;
    }

    @Override
    public int advance(int n) throws IOException {
        this.doc = this.countingSumScorer.advance(n);
        return this.doc;
    }

    @Override
    protected void visitSubScorers(Query query, BooleanClause.Occur occur, Scorer.ScorerVisitor<Query, Query, Scorer> scorerVisitor) {
        super.visitSubScorers(query, occur, scorerVisitor);
        Query query2 = this.weight.getQuery();
        for (Scorer scorer : this.optionalScorers) {
            scorer.visitSubScorers(query2, BooleanClause.Occur.SHOULD, scorerVisitor);
        }
        for (Scorer scorer : this.prohibitedScorers) {
            scorer.visitSubScorers(query2, BooleanClause.Occur.MUST_NOT, scorerVisitor);
        }
        for (Scorer scorer : this.requiredScorers) {
            scorer.visitSubScorers(query2, BooleanClause.Occur.MUST, scorerVisitor);
        }
    }

    private class SingleMatchScorer
    extends Scorer {
        private Scorer scorer;
        private int lastScoredDoc;
        private float lastDocScore;

        SingleMatchScorer(Scorer scorer) {
            super(scorer.weight);
            this.lastScoredDoc = -1;
            this.lastDocScore = Float.NaN;
            this.scorer = scorer;
        }

        @Override
        public float score() throws IOException {
            int n = this.docID();
            if (n >= this.lastScoredDoc) {
                if (n > this.lastScoredDoc) {
                    this.lastDocScore = this.scorer.score();
                    this.lastScoredDoc = n;
                }
                ++((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers;
            }
            return this.lastDocScore;
        }

        @Override
        public int docID() {
            return this.scorer.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        @Override
        public int advance(int n) throws IOException {
            return this.scorer.advance(n);
        }
    }

    private class Coordinator {
        float[] coordFactors = null;
        int maxCoord = 0;
        int nrMatchers;

        private Coordinator() {
        }

        void init(Similarity similarity, boolean bl) {
            this.coordFactors = new float[BooleanScorer2.this.optionalScorers.size() + BooleanScorer2.this.requiredScorers.size() + 1];
            for (int i = 0; i < this.coordFactors.length; ++i) {
                this.coordFactors[i] = bl ? 1.0f : similarity.coord(i, this.maxCoord);
            }
        }
    }
}

