/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class BooleanScorer
extends Scorer {
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable();
    private final float[] coordFactors;
    private final int minNrShouldMatch;
    private int end;
    private Bucket current;
    private int doc = -1;
    private static final int PROHIBITED_MASK = 1;

    BooleanScorer(Weight weight, boolean bl, Similarity similarity, int n, List<Scorer> list, List<Scorer> list2, int n2) throws IOException {
        super(weight);
        this.minNrShouldMatch = n;
        if (list != null && list.size() > 0) {
            for (Scorer scorer : list) {
                if (scorer.nextDoc() == Integer.MAX_VALUE) continue;
                this.scorers = new SubScorer(scorer, false, false, this.bucketTable.newCollector(0), this.scorers);
            }
        }
        if (list2 != null && list2.size() > 0) {
            for (Scorer scorer : list2) {
                if (scorer.nextDoc() == Integer.MAX_VALUE) continue;
                this.scorers = new SubScorer(scorer, false, true, this.bucketTable.newCollector(1), this.scorers);
            }
        }
        this.coordFactors = new float[list.size() + 1];
        for (int i = 0; i < this.coordFactors.length; ++i) {
            this.coordFactors[i] = bl ? 1.0f : similarity.coord(i, n2);
        }
    }

    @Override
    protected boolean score(Collector collector, int n, int n2) throws IOException {
        boolean bl;
        assert (n2 == -1);
        BucketScorer bucketScorer = new BucketScorer(this.weight);
        collector.setScorer(bucketScorer);
        do {
            this.bucketTable.first = null;
            while (this.current != null) {
                if ((this.current.bits & 1) == 0) {
                    if (this.current.doc >= n) {
                        Bucket bucket = this.current;
                        this.current = this.current.next;
                        bucket.next = this.bucketTable.first;
                        this.bucketTable.first = bucket;
                        continue;
                    }
                    if (this.current.coord >= this.minNrShouldMatch) {
                        bucketScorer.score = this.current.score * this.coordFactors[this.current.coord];
                        bucketScorer.doc = this.current.doc;
                        bucketScorer.freq = this.current.coord;
                        collector.collect(this.current.doc);
                    }
                }
                this.current = this.current.next;
            }
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                return true;
            }
            bl = false;
            this.end += 2048;
            SubScorer subScorer = this.scorers;
            while (subScorer != null) {
                int n3 = subScorer.scorer.docID();
                if (n3 != Integer.MAX_VALUE) {
                    bl |= subScorer.scorer.score(subScorer.collector, this.end, n3);
                }
                subScorer = subScorer.next;
            }
            this.current = this.bucketTable.first;
        } while (this.current != null || bl);
        return false;
    }

    @Override
    public int advance(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int docID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextDoc() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float score() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void score(Collector collector) throws IOException {
        this.score(collector, Integer.MAX_VALUE, -1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("boolean(");
        SubScorer subScorer = this.scorers;
        while (subScorer != null) {
            stringBuilder.append(subScorer.scorer.toString());
            stringBuilder.append(" ");
            subScorer = subScorer.next;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    protected void visitSubScorers(Query query, BooleanClause.Occur occur, Scorer.ScorerVisitor<Query, Query, Scorer> scorerVisitor) {
        super.visitSubScorers(query, occur, scorerVisitor);
        Query query2 = this.weight.getQuery();
        SubScorer subScorer = this.scorers;
        while (subScorer != null) {
            occur = !subScorer.prohibited ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST_NOT;
            subScorer.scorer.visitSubScorers(query2, occur, scorerVisitor);
            subScorer = subScorer.next;
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean prohibited;
        public Collector collector;
        public SubScorer next;

        public SubScorer(Scorer scorer, boolean bl, boolean bl2, Collector collector, SubScorer subScorer) throws IOException {
            if (bl) {
                throw new IllegalArgumentException("this scorer cannot handle required=true");
            }
            this.scorer = scorer;
            this.prohibited = bl2;
            this.collector = collector;
            this.next = subScorer;
        }
    }

    static final class BucketTable {
        public static final int SIZE = 2048;
        public static final int MASK = 2047;
        final Bucket[] buckets = new Bucket[2048];
        Bucket first = null;

        public BucketTable() {
            for (int i = 0; i < 2048; ++i) {
                this.buckets[i] = new Bucket();
            }
        }

        public Collector newCollector(int n) {
            return new BooleanScorerCollector(n, this);
        }

        public int size() {
            return 2048;
        }
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    private static final class BucketScorer
    extends Scorer {
        float score;
        int doc = Integer.MAX_VALUE;
        int freq;

        public BucketScorer(Weight weight) {
            super(weight);
        }

        @Override
        public int advance(int n) throws IOException {
            return Integer.MAX_VALUE;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public float freq() {
            return this.freq;
        }

        @Override
        public int nextDoc() throws IOException {
            return Integer.MAX_VALUE;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }
    }

    private static final class BooleanScorerCollector
    extends Collector {
        private BucketTable bucketTable;
        private int mask;
        private Scorer scorer;

        public BooleanScorerCollector(int n, BucketTable bucketTable) {
            this.mask = n;
            this.bucketTable = bucketTable;
        }

        @Override
        public void collect(int n) throws IOException {
            BucketTable bucketTable = this.bucketTable;
            int n2 = n & 0x7FF;
            Bucket bucket = bucketTable.buckets[n2];
            if (bucket.doc != n) {
                bucket.doc = n;
                bucket.score = this.scorer.score();
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = bucketTable.first;
                bucketTable.first = bucket;
            } else {
                bucket.score += this.scorer.score();
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) {
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

