/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class MultiFieldQueryParser
extends QueryParser {
    protected String[] fields;
    protected Map<String, Float> boosts;

    public MultiFieldQueryParser(Version version, String[] stringArray, Analyzer analyzer, Map<String, Float> map) {
        this(version, stringArray, analyzer);
        this.boosts = map;
    }

    public MultiFieldQueryParser(Version version, String[] stringArray, Analyzer analyzer) {
        super(version, null, analyzer);
        this.fields = stringArray;
    }

    @Override
    protected Query getFieldQuery(String string, String string2, int n) throws ParseException {
        if (string == null) {
            ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                Float f;
                Query query = super.getFieldQuery(this.fields[i], string2, true);
                if (query == null) continue;
                if (this.boosts != null && (f = this.boosts.get(this.fields[i])) != null) {
                    query.setBoost(f.floatValue());
                }
                this.applySlop(query, n);
                arrayList.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(arrayList, true);
        }
        Query query = super.getFieldQuery(string, string2, true);
        this.applySlop(query, n);
        return query;
    }

    private void applySlop(Query query, int n) {
        if (query instanceof PhraseQuery) {
            ((PhraseQuery)query).setSlop(n);
        } else if (query instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)query).setSlop(n);
        }
    }

    @Override
    protected Query getFieldQuery(String string, String string2, boolean bl) throws ParseException {
        if (string == null) {
            ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                Float f;
                Query query = super.getFieldQuery(this.fields[i], string2, bl);
                if (query == null) continue;
                if (this.boosts != null && (f = this.boosts.get(this.fields[i])) != null) {
                    query.setBoost(f.floatValue());
                }
                arrayList.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(arrayList, true);
        }
        Query query = super.getFieldQuery(string, string2, bl);
        return query;
    }

    @Override
    protected Query getFuzzyQuery(String string, String string2, float f) throws ParseException {
        if (string == null) {
            ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                arrayList.add(new BooleanClause(this.getFuzzyQuery(this.fields[i], string2, f), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(arrayList, true);
        }
        return super.getFuzzyQuery(string, string2, f);
    }

    @Override
    protected Query getPrefixQuery(String string, String string2) throws ParseException {
        if (string == null) {
            ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                arrayList.add(new BooleanClause(this.getPrefixQuery(this.fields[i], string2), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(arrayList, true);
        }
        return super.getPrefixQuery(string, string2);
    }

    @Override
    protected Query getWildcardQuery(String string, String string2) throws ParseException {
        if (string == null) {
            ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                arrayList.add(new BooleanClause(this.getWildcardQuery(this.fields[i], string2), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(arrayList, true);
        }
        return super.getWildcardQuery(string, string2);
    }

    @Override
    protected Query getRangeQuery(String string, String string2, String string3, boolean bl) throws ParseException {
        if (string == null) {
            ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                arrayList.add(new BooleanClause(this.getRangeQuery(this.fields[i], string2, string3, bl), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(arrayList, true);
        }
        return super.getRangeQuery(string, string2, string3, bl);
    }

    public static Query parse(Version version, String[] stringArray, String[] stringArray2, Analyzer analyzer) throws ParseException {
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (int i = 0; i < stringArray2.length; ++i) {
            QueryParser queryParser = new QueryParser(version, stringArray2[i], analyzer);
            Query query = queryParser.parse(stringArray[i]);
            if (query == null || query instanceof BooleanQuery && ((BooleanQuery)query).getClauses().length <= 0) continue;
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    public static Query parse(Version version, String string, String[] stringArray, BooleanClause.Occur[] occurArray, Analyzer analyzer) throws ParseException {
        if (stringArray.length != occurArray.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (int i = 0; i < stringArray.length; ++i) {
            QueryParser queryParser = new QueryParser(version, stringArray[i], analyzer);
            Query query = queryParser.parse(string);
            if (query == null || query instanceof BooleanQuery && ((BooleanQuery)query).getClauses().length <= 0) continue;
            booleanQuery.add(query, occurArray[i]);
        }
        return booleanQuery;
    }

    public static Query parse(Version version, String[] stringArray, String[] stringArray2, BooleanClause.Occur[] occurArray, Analyzer analyzer) throws ParseException {
        if (stringArray.length != stringArray2.length || stringArray.length != occurArray.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (int i = 0; i < stringArray2.length; ++i) {
            QueryParser queryParser = new QueryParser(version, stringArray2[i], analyzer);
            Query query = queryParser.parse(stringArray[i]);
            if (query == null || query instanceof BooleanQuery && ((BooleanQuery)query).getClauses().length <= 0) continue;
            booleanQuery.add(query, occurArray[i]);
        }
        return booleanQuery;
    }
}

