/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.CharBlockPool;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IntBlockPool;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.util.SorterTemplate;

final class TermsHashPerField
extends InvertedDocConsumerPerField {
    final TermsHashConsumerPerField consumer;
    final TermsHashPerField nextPerField;
    final TermsHashPerThread perThread;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    CharTermAttribute termAtt;
    final CharBlockPool charPool;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    final int streamCount;
    final int numPostingInt;
    final FieldInfo fieldInfo;
    boolean postingsCompacted;
    int numPostings;
    private int postingsHashSize = 4;
    private int postingsHashHalfSize = this.postingsHashSize / 2;
    private int postingsHashMask = this.postingsHashSize - 1;
    private int[] postingsHash;
    ParallelPostingsArray postingsArray;
    private boolean doCall;
    private boolean doNextCall;
    int[] intUptos;
    int intUptoStart;

    public TermsHashPerField(DocInverterPerField docInverterPerField, TermsHashPerThread termsHashPerThread, TermsHashPerThread termsHashPerThread2, FieldInfo fieldInfo) {
        this.perThread = termsHashPerThread;
        this.intPool = termsHashPerThread.intPool;
        this.charPool = termsHashPerThread.charPool;
        this.bytePool = termsHashPerThread.bytePool;
        this.docState = termsHashPerThread.docState;
        this.postingsHash = new int[this.postingsHashSize];
        Arrays.fill(this.postingsHash, -1);
        this.bytesUsed(this.postingsHashSize * 4);
        this.fieldState = docInverterPerField.fieldState;
        this.consumer = termsHashPerThread.consumer.addField(this, fieldInfo);
        this.initPostingsArray();
        this.streamCount = this.consumer.getStreamCount();
        this.numPostingInt = 2 * this.streamCount;
        this.fieldInfo = fieldInfo;
        this.nextPerField = termsHashPerThread2 != null ? (TermsHashPerField)termsHashPerThread2.addField(docInverterPerField, fieldInfo) : null;
    }

    private void initPostingsArray() {
        this.postingsArray = this.consumer.createPostingsArray(2);
        this.bytesUsed(this.postingsArray.size * this.postingsArray.bytesPerPosting());
    }

    private void bytesUsed(long l) {
        if (this.perThread.termsHash.trackAllocations) {
            this.perThread.termsHash.docWriter.bytesUsed(l);
        }
    }

    void shrinkHash(int n) {
        assert (this.postingsCompacted || this.numPostings == 0);
        if (4 != this.postingsHash.length) {
            long l = this.postingsHash.length;
            this.postingsHash = new int[4];
            this.bytesUsed((4L - l) * 4L);
            Arrays.fill(this.postingsHash, -1);
            this.postingsHashSize = 4;
            this.postingsHashHalfSize = 2;
            this.postingsHashMask = 3;
        }
        if (this.postingsArray != null) {
            this.bytesUsed(-this.postingsArray.bytesPerPosting() * this.postingsArray.size);
            this.postingsArray = null;
        }
    }

    public void reset() {
        if (!this.postingsCompacted) {
            this.compactPostings();
        }
        assert (this.numPostings <= this.postingsHash.length);
        if (this.numPostings > 0) {
            Arrays.fill(this.postingsHash, 0, this.numPostings, -1);
            this.numPostings = 0;
        }
        this.postingsCompacted = false;
        if (this.nextPerField != null) {
            this.nextPerField.reset();
        }
    }

    @Override
    public synchronized void abort() {
        this.reset();
        if (this.nextPerField != null) {
            this.nextPerField.abort();
        }
    }

    private final void growParallelPostingsArray() {
        int n = this.postingsArray.size;
        this.postingsArray = this.postingsArray.grow();
        this.bytesUsed(this.postingsArray.bytesPerPosting() * (this.postingsArray.size - n));
    }

    public void initReader(ByteSliceReader byteSliceReader, int n, int n2) {
        assert (n2 < this.streamCount);
        int n3 = this.postingsArray.intStarts[n];
        int[] nArray = this.intPool.buffers[n3 >> 13];
        int n4 = n3 & 0x1FFF;
        byteSliceReader.init(this.bytePool, this.postingsArray.byteStarts[n] + n2 * ByteBlockPool.FIRST_LEVEL_SIZE, nArray[n4 + n2]);
    }

    private void compactPostings() {
        int n = 0;
        for (int i = 0; i < this.postingsHashSize; ++i) {
            if (this.postingsHash[i] == -1) continue;
            if (n < i) {
                this.postingsHash[n] = this.postingsHash[i];
                this.postingsHash[i] = -1;
            }
            ++n;
        }
        assert (n == this.numPostings) : "upto=" + n + " numPostings=" + this.numPostings;
        this.postingsCompacted = true;
    }

    public int[] sortPostings() {
        this.compactPostings();
        final int[] nArray = this.postingsHash;
        new SorterTemplate(){
            private int pivotTerm;
            private int pivotBufPos;
            private char[] pivotBuf;

            @Override
            protected void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
            }

            @Override
            protected int compare(int n, int n2) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                if (n3 == n4) {
                    return 0;
                }
                int n5 = TermsHashPerField.this.postingsArray.textStarts[n3];
                int n6 = TermsHashPerField.this.postingsArray.textStarts[n4];
                char[] cArray = TermsHashPerField.this.charPool.buffers[n5 >> 14];
                int n7 = n5 & 0x3FFF;
                char[] cArray2 = TermsHashPerField.this.charPool.buffers[n6 >> 14];
                int n8 = n6 & 0x3FFF;
                return this.comparePostings(cArray, n7, cArray2, n8);
            }

            @Override
            protected void setPivot(int n) {
                this.pivotTerm = nArray[n];
                int n2 = TermsHashPerField.this.postingsArray.textStarts[this.pivotTerm];
                this.pivotBuf = TermsHashPerField.this.charPool.buffers[n2 >> 14];
                this.pivotBufPos = n2 & 0x3FFF;
            }

            @Override
            protected int comparePivot(int n) {
                int n2 = nArray[n];
                if (this.pivotTerm == n2) {
                    return 0;
                }
                int n3 = TermsHashPerField.this.postingsArray.textStarts[n2];
                char[] cArray = TermsHashPerField.this.charPool.buffers[n3 >> 14];
                int n4 = n3 & 0x3FFF;
                return this.comparePostings(this.pivotBuf, this.pivotBufPos, cArray, n4);
            }

            private int comparePostings(char[] cArray, int n, char[] cArray2, int n2) {
                char c;
                assert (cArray != cArray2 || n != n2);
                while (true) {
                    char c2;
                    if ((c = cArray[n++]) == (c2 = cArray2[n2++])) continue;
                    if ('\uffff' == c2) {
                        return 1;
                    }
                    if ('\uffff' == c) {
                        return -1;
                    }
                    return c - c2;
                    assert (c != '\uffff');
                }
            }
        }.quickSort(0, this.numPostings - 1);
        return nArray;
    }

    private boolean postingEquals(int n, char[] cArray, int n2) {
        int n3 = this.postingsArray.textStarts[n];
        char[] cArray2 = this.perThread.charPool.buffers[n3 >> 14];
        assert (cArray2 != null);
        int n4 = n3 & 0x3FFF;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != cArray2[n4]) {
                return false;
            }
            ++n4;
        }
        return '\uffff' == cArray2[n4];
    }

    @Override
    void start(Fieldable fieldable) {
        this.termAtt = this.fieldState.attributeSource.addAttribute(CharTermAttribute.class);
        this.consumer.start(fieldable);
        if (this.nextPerField != null) {
            this.nextPerField.start(fieldable);
        }
    }

    @Override
    boolean start(Fieldable[] fieldableArray, int n) throws IOException {
        this.doCall = this.consumer.start(fieldableArray, n);
        if (this.postingsArray == null) {
            this.initPostingsArray();
        }
        if (this.nextPerField != null) {
            this.doNextCall = this.nextPerField.start(fieldableArray, n);
        }
        return this.doCall || this.doNextCall;
    }

    public void add(int n) throws IOException {
        int n2;
        int n3 = n;
        int n4 = n3 & this.postingsHashMask;
        assert (!this.postingsCompacted);
        int n5 = this.postingsHash[n4];
        if (n5 != -1 && this.postingsArray.textStarts[n5] != n) {
            n2 = (n3 >> 8) + n3 | 1;
            while ((n5 = this.postingsHash[n4 = (n3 += n2) & this.postingsHashMask]) != -1 && this.postingsArray.textStarts[n5] != n) {
            }
        }
        if (n5 == -1) {
            if ((n5 = this.numPostings++) >= this.postingsArray.size) {
                this.growParallelPostingsArray();
            }
            assert (n5 >= 0);
            this.postingsArray.textStarts[n5] = n;
            assert (this.postingsHash[n4] == -1);
            this.postingsHash[n4] = n5;
            if (this.numPostings == this.postingsHashHalfSize) {
                this.rehashPostings(2 * this.postingsHashSize);
            }
            if (this.numPostingInt + this.intPool.intUpto > 8192) {
                this.intPool.nextBuffer();
            }
            if (32768 - this.bytePool.byteUpto < this.numPostingInt * ByteBlockPool.FIRST_LEVEL_SIZE) {
                this.bytePool.nextBuffer();
            }
            this.intUptos = this.intPool.buffer;
            this.intUptoStart = this.intPool.intUpto;
            this.intPool.intUpto += this.streamCount;
            this.postingsArray.intStarts[n5] = this.intUptoStart + this.intPool.intOffset;
            for (n2 = 0; n2 < this.streamCount; ++n2) {
                int n6 = this.bytePool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
                this.intUptos[this.intUptoStart + n2] = n6 + this.bytePool.byteOffset;
            }
            this.postingsArray.byteStarts[n5] = this.intUptos[this.intUptoStart];
            this.consumer.newTerm(n5);
        } else {
            n2 = this.postingsArray.intStarts[n5];
            this.intUptos = this.intPool.buffers[n2 >> 13];
            this.intUptoStart = n2 & 0x1FFF;
            this.consumer.addTerm(n5);
        }
    }

    @Override
    void add() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        assert (!this.postingsCompacted);
        char[] cArray = this.termAtt.buffer();
        int n5 = n4 = this.termAtt.length();
        int n6 = 0;
        while (n5 > 0) {
            if ((n3 = cArray[--n5]) >= 56320 && n3 <= 57343) {
                if (0 == n5) {
                    cArray[n5] = 65533;
                    n3 = 65533;
                } else {
                    n2 = cArray[n5 - 1];
                    if (n2 >= 55296 && n2 <= 56319) {
                        n6 = (n6 * 31 + n3) * 31 + n2;
                        --n5;
                        continue;
                    }
                    cArray[n5] = 65533;
                    n3 = 65533;
                }
            } else if (n3 >= 55296 && (n3 <= 56319 || n3 == 65535)) {
                cArray[n5] = 65533;
                n3 = 65533;
            }
            n6 = n6 * 31 + n3;
        }
        n3 = n6 & this.postingsHashMask;
        n2 = this.postingsHash[n3];
        if (n2 != -1 && !this.postingEquals(n2, cArray, n4)) {
            n = (n6 >> 8) + n6 | 1;
            while ((n2 = this.postingsHash[n3 = (n6 += n) & this.postingsHashMask]) != -1 && !this.postingEquals(n2, cArray, n4)) {
            }
        }
        if (n2 == -1) {
            n = 1 + n4;
            if (n + this.charPool.charUpto > 16384) {
                if (n > 16384) {
                    if (this.docState.maxTermPrefix == null) {
                        this.docState.maxTermPrefix = new String(cArray, 0, 30);
                    }
                    this.consumer.skippingLongTerm();
                    return;
                }
                this.charPool.nextBuffer();
            }
            if ((n2 = this.numPostings++) >= this.postingsArray.size) {
                this.growParallelPostingsArray();
            }
            assert (n2 != -1);
            char[] cArray2 = this.charPool.buffer;
            int n7 = this.charPool.charUpto;
            this.postingsArray.textStarts[n2] = n7 + this.charPool.charOffset;
            this.charPool.charUpto += n;
            System.arraycopy(cArray, 0, cArray2, n7, n4);
            cArray2[n7 + n4] = 65535;
            assert (this.postingsHash[n3] == -1);
            this.postingsHash[n3] = n2;
            if (this.numPostings == this.postingsHashHalfSize) {
                this.rehashPostings(2 * this.postingsHashSize);
                this.bytesUsed(2 * this.numPostings * 4);
            }
            if (this.numPostingInt + this.intPool.intUpto > 8192) {
                this.intPool.nextBuffer();
            }
            if (32768 - this.bytePool.byteUpto < this.numPostingInt * ByteBlockPool.FIRST_LEVEL_SIZE) {
                this.bytePool.nextBuffer();
            }
            this.intUptos = this.intPool.buffer;
            this.intUptoStart = this.intPool.intUpto;
            this.intPool.intUpto += this.streamCount;
            this.postingsArray.intStarts[n2] = this.intUptoStart + this.intPool.intOffset;
            for (int i = 0; i < this.streamCount; ++i) {
                int n8 = this.bytePool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
                this.intUptos[this.intUptoStart + i] = n8 + this.bytePool.byteOffset;
            }
            this.postingsArray.byteStarts[n2] = this.intUptos[this.intUptoStart];
            this.consumer.newTerm(n2);
        } else {
            n = this.postingsArray.intStarts[n2];
            this.intUptos = this.intPool.buffers[n >> 13];
            this.intUptoStart = n & 0x1FFF;
            this.consumer.addTerm(n2);
        }
        if (this.doNextCall) {
            this.nextPerField.add(this.postingsArray.textStarts[n2]);
        }
    }

    void writeByte(int n, byte by) {
        int n2 = this.intUptos[this.intUptoStart + n];
        byte[] byArray = this.bytePool.buffers[n2 >> 15];
        assert (byArray != null);
        int n3 = n2 & Short.MAX_VALUE;
        if (byArray[n3] != 0) {
            n3 = this.bytePool.allocSlice(byArray, n3);
            byArray = this.bytePool.buffer;
            this.intUptos[this.intUptoStart + n] = n3 + this.bytePool.byteOffset;
        }
        byArray[n3] = by;
        int n4 = this.intUptoStart + n;
        this.intUptos[n4] = this.intUptos[n4] + 1;
    }

    public void writeBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            this.writeByte(n, byArray[i]);
        }
    }

    void writeVInt(int n, int n2) {
        assert (n < this.streamCount);
        while ((n2 & 0xFFFFFF80) != 0) {
            this.writeByte(n, (byte)(n2 & 0x7F | 0x80));
            n2 >>>= 7;
        }
        this.writeByte(n, (byte)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void finish() throws IOException {
        try {
            this.consumer.finish();
        }
        finally {
            if (this.nextPerField != null) {
                this.nextPerField.finish();
            }
        }
    }

    void rehashPostings(int n) {
        int n2 = n - 1;
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < this.postingsHashSize; ++i) {
            int n3;
            int n4;
            int n5;
            int n6 = this.postingsHash[i];
            if (n6 == -1) continue;
            if (this.perThread.primary) {
                n5 = this.postingsArray.textStarts[n6];
                n4 = n5 & 0x3FFF;
                char[] cArray = this.charPool.buffers[n5 >> 14];
                int n7 = n4;
                while (cArray[n7] != '\uffff') {
                    ++n7;
                }
                n3 = 0;
                while (n7 > n4) {
                    n3 = n3 * 31 + cArray[--n7];
                }
            } else {
                n3 = this.postingsArray.textStarts[n6];
            }
            n5 = n3 & n2;
            assert (n5 >= 0);
            if (nArray[n5] != -1) {
                n4 = (n3 >> 8) + n3 | 1;
                while (nArray[n5 = (n3 += n4) & n2] != -1) {
                }
            }
            nArray[n5] = n6;
        }
        this.postingsHashMask = n2;
        this.postingsHash = nArray;
        this.postingsHashSize = n;
        this.postingsHashHalfSize = n >> 1;
    }
}

