/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.ParallelArrayTermVectorMapper;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOUtils;

class TermVectorsReader
implements Cloneable,
Closeable {
    static final int FORMAT_VERSION = 2;
    static final int FORMAT_VERSION2 = 3;
    static final int FORMAT_UTF8_LENGTH_IN_BYTES = 4;
    static final int FORMAT_CURRENT = 4;
    static final int FORMAT_SIZE = 4;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 1;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 2;
    private FieldInfos fieldInfos;
    private IndexInput tvx;
    private IndexInput tvd;
    private IndexInput tvf;
    private int size;
    private int numTotalDocs;
    private int docStoreOffset;
    private final int format;

    TermVectorsReader(Directory directory, String string, FieldInfos fieldInfos) throws CorruptIndexException, IOException {
        this(directory, string, fieldInfos, 1024);
    }

    TermVectorsReader(Directory directory, String string, FieldInfos fieldInfos, int n) throws CorruptIndexException, IOException {
        this(directory, string, fieldInfos, n, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermVectorsReader(Directory directory, String string, FieldInfos fieldInfos, int n, int n2, int n3) throws CorruptIndexException, IOException {
        boolean bl = false;
        try {
            String string2 = IndexFileNames.segmentFileName(string, "tvx");
            this.tvx = directory.openInput(string2, n);
            this.format = this.checkValidFormat(string2, this.tvx);
            String string3 = IndexFileNames.segmentFileName(string, "tvd");
            this.tvd = directory.openInput(string3, n);
            int n4 = this.checkValidFormat(string3, this.tvd);
            string3 = IndexFileNames.segmentFileName(string, "tvf");
            this.tvf = directory.openInput(string3, n);
            int n5 = this.checkValidFormat(string3, this.tvf);
            assert (this.format == n4);
            assert (this.format == n5);
            if (this.format >= 3) {
                this.numTotalDocs = (int)(this.tvx.length() >> 4);
            } else {
                assert ((this.tvx.length() - 4L) % 8L == 0L);
                this.numTotalDocs = (int)(this.tvx.length() >> 3);
            }
            if (-1 == n2) {
                this.docStoreOffset = 0;
                this.size = this.numTotalDocs;
                assert (n3 == 0 || this.numTotalDocs == n3);
            } else {
                this.docStoreOffset = n2;
                this.size = n3;
                assert (this.numTotalDocs >= n3 + n2) : "numTotalDocs=" + this.numTotalDocs + " size=" + n3 + " docStoreOffset=" + n2;
            }
            this.fieldInfos = fieldInfos;
            bl = true;
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
    }

    IndexInput getTvdStream() {
        return this.tvd;
    }

    IndexInput getTvfStream() {
        return this.tvf;
    }

    private final void seekTvx(int n) throws IOException {
        if (this.format < 3) {
            this.tvx.seek((long)(n + this.docStoreOffset) * 8L + 4L);
        } else {
            this.tvx.seek((long)(n + this.docStoreOffset) * 16L + 4L);
        }
    }

    boolean canReadRawDocs() {
        return this.format >= 4;
    }

    final void rawDocs(int[] nArray, int[] nArray2, int n, int n2) throws IOException {
        if (this.tvx == null) {
            Arrays.fill(nArray, 0);
            Arrays.fill(nArray2, 0);
            return;
        }
        if (this.format < 3) {
            throw new IllegalStateException("cannot read raw docs with older term vector formats");
        }
        this.seekTvx(n);
        long l = this.tvx.readLong();
        this.tvd.seek(l);
        long l2 = this.tvx.readLong();
        this.tvf.seek(l2);
        long l3 = l;
        long l4 = l2;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.docStoreOffset + n + i + 1;
            assert (n3 <= this.numTotalDocs);
            if (n3 < this.numTotalDocs) {
                l = this.tvx.readLong();
                l2 = this.tvx.readLong();
            } else {
                l = this.tvd.length();
                l2 = this.tvf.length();
                assert (i == n2 - 1);
            }
            nArray[i] = (int)(l - l3);
            nArray2[i] = (int)(l2 - l4);
            l3 = l;
            l4 = l2;
        }
    }

    private int checkValidFormat(String string, IndexInput indexInput) throws CorruptIndexException, IOException {
        int n = indexInput.readInt();
        if (n > 4) {
            throw new IndexFormatTooNewException(indexInput, n, 1, 4);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.tvx, this.tvd, this.tvf);
    }

    int size() {
        return this.size;
    }

    public void get(int n, String string, TermVectorMapper termVectorMapper) throws IOException {
        if (this.tvx != null) {
            int n2 = this.fieldInfos.fieldNumber(string);
            this.seekTvx(n);
            long l = this.tvx.readLong();
            this.tvd.seek(l);
            int n3 = this.tvd.readVInt();
            int n4 = 0;
            int n5 = -1;
            for (int i = 0; i < n3; ++i) {
                n4 = this.format >= 2 ? this.tvd.readVInt() : (n4 += this.tvd.readVInt());
                if (n4 != n2) continue;
                n5 = i;
            }
            if (n5 != -1) {
                long l2 = this.format >= 3 ? this.tvx.readLong() : this.tvd.readVLong();
                for (int i = 1; i <= n5; ++i) {
                    l2 += this.tvd.readVLong();
                }
                termVectorMapper.setDocumentNumber(n);
                this.readTermVector(string, l2, termVectorMapper);
            }
        }
    }

    TermFreqVector get(int n, String string) throws IOException {
        ParallelArrayTermVectorMapper parallelArrayTermVectorMapper = new ParallelArrayTermVectorMapper();
        this.get(n, string, parallelArrayTermVectorMapper);
        return parallelArrayTermVectorMapper.materializeVector();
    }

    private final String[] readFields(int n) throws IOException {
        int n2 = 0;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            n2 = this.format >= 2 ? this.tvd.readVInt() : (n2 += this.tvd.readVInt());
            stringArray[i] = this.fieldInfos.fieldName(n2);
        }
        return stringArray;
    }

    private final long[] readTvfPointers(int n) throws IOException {
        long l = this.format >= 3 ? this.tvx.readLong() : this.tvd.readVLong();
        long[] lArray = new long[n];
        lArray[0] = l;
        for (int i = 1; i < n; ++i) {
            lArray[i] = l += this.tvd.readVLong();
        }
        return lArray;
    }

    TermFreqVector[] get(int n) throws IOException {
        SegmentTermVector[] segmentTermVectorArray = null;
        if (this.tvx != null) {
            this.seekTvx(n);
            long l = this.tvx.readLong();
            this.tvd.seek(l);
            int n2 = this.tvd.readVInt();
            if (n2 != 0) {
                String[] stringArray = this.readFields(n2);
                long[] lArray = this.readTvfPointers(n2);
                segmentTermVectorArray = this.readTermVectors(n, stringArray, lArray);
            }
        }
        return segmentTermVectorArray;
    }

    public void get(int n, TermVectorMapper termVectorMapper) throws IOException {
        if (this.tvx != null) {
            this.seekTvx(n);
            long l = this.tvx.readLong();
            this.tvd.seek(l);
            int n2 = this.tvd.readVInt();
            if (n2 != 0) {
                String[] stringArray = this.readFields(n2);
                long[] lArray = this.readTvfPointers(n2);
                termVectorMapper.setDocumentNumber(n);
                this.readTermVectors(stringArray, lArray, termVectorMapper);
            }
        }
    }

    private SegmentTermVector[] readTermVectors(int n, String[] stringArray, long[] lArray) throws IOException {
        SegmentTermVector[] segmentTermVectorArray = new SegmentTermVector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ParallelArrayTermVectorMapper parallelArrayTermVectorMapper = new ParallelArrayTermVectorMapper();
            parallelArrayTermVectorMapper.setDocumentNumber(n);
            this.readTermVector(stringArray[i], lArray[i], parallelArrayTermVectorMapper);
            segmentTermVectorArray[i] = (SegmentTermVector)parallelArrayTermVectorMapper.materializeVector();
        }
        return segmentTermVectorArray;
    }

    private void readTermVectors(String[] stringArray, long[] lArray, TermVectorMapper termVectorMapper) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.readTermVector(stringArray[i], lArray[i], termVectorMapper);
        }
    }

    private void readTermVector(String string, long l, TermVectorMapper termVectorMapper) throws IOException {
        byte[] byArray;
        char[] cArray;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        this.tvf.seek(l);
        int n2 = this.tvf.readVInt();
        if (n2 == 0) {
            return;
        }
        if (this.format >= 2) {
            n = this.tvf.readByte();
            bl3 = (n & 1) != 0;
            bl2 = (n & 2) != 0;
        } else {
            this.tvf.readVInt();
            bl3 = false;
            bl2 = false;
        }
        termVectorMapper.setExpectations(string, n2, bl2, bl3);
        n = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = bl = this.format < 4;
        if (bl) {
            cArray = new char[10];
            byArray = null;
        } else {
            cArray = null;
            byArray = new byte[20];
        }
        for (int i = 0; i < n2; ++i) {
            int n5;
            String string2;
            n = this.tvf.readVInt();
            n3 = this.tvf.readVInt();
            n4 = n + n3;
            if (bl) {
                if (cArray.length < n4) {
                    cArray = ArrayUtil.grow(cArray, n4);
                }
                this.tvf.readChars(cArray, n, n3);
                string2 = new String(cArray, 0, n4);
            } else {
                if (byArray.length < n4) {
                    byArray = ArrayUtil.grow(byArray, n4);
                }
                this.tvf.readBytes(byArray, n, n3);
                string2 = new String(byArray, 0, n4, "UTF-8");
            }
            int n6 = this.tvf.readVInt();
            int[] nArray = null;
            if (bl3) {
                if (!termVectorMapper.isIgnoringPositions()) {
                    nArray = new int[n6];
                    int n7 = 0;
                    for (n5 = 0; n5 < n6; ++n5) {
                        nArray[n5] = n7 + this.tvf.readVInt();
                        n7 = nArray[n5];
                    }
                } else {
                    for (int j = 0; j < n6; ++j) {
                        this.tvf.readVInt();
                    }
                }
            }
            TermVectorOffsetInfo[] termVectorOffsetInfoArray = null;
            if (bl2) {
                if (!termVectorMapper.isIgnoringOffsets()) {
                    termVectorOffsetInfoArray = new TermVectorOffsetInfo[n6];
                    n5 = 0;
                    for (int j = 0; j < n6; ++j) {
                        int n8 = n5 + this.tvf.readVInt();
                        int n9 = n8 + this.tvf.readVInt();
                        termVectorOffsetInfoArray[j] = new TermVectorOffsetInfo(n8, n9);
                        n5 = n9;
                    }
                } else {
                    for (n5 = 0; n5 < n6; ++n5) {
                        this.tvf.readVInt();
                        this.tvf.readVInt();
                    }
                }
            }
            termVectorMapper.map(string2, n6, termVectorOffsetInfoArray, nArray);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        TermVectorsReader termVectorsReader = (TermVectorsReader)super.clone();
        if (this.tvx != null && this.tvd != null && this.tvf != null) {
            termVectorsReader.tvx = (IndexInput)this.tvx.clone();
            termVectorsReader.tvd = (IndexInput)this.tvd.clone();
            termVectorsReader.tvf = (IndexInput)this.tvf.clone();
        }
        return termVectorsReader;
    }
}

