/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Arrays;
import org.apache.lucene.index.TermFreqVector;

class SegmentTermVector
implements TermFreqVector {
    private String field;
    private String[] terms;
    private int[] termFreqs;

    SegmentTermVector(String string, String[] stringArray, int[] nArray) {
        this.field = string;
        this.terms = stringArray;
        this.termFreqs = nArray;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append(this.field).append(": ");
        if (this.terms != null) {
            for (int i = 0; i < this.terms.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.terms[i]).append('/').append(this.termFreqs[i]);
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public int size() {
        return this.terms == null ? 0 : this.terms.length;
    }

    @Override
    public String[] getTerms() {
        return this.terms;
    }

    @Override
    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    @Override
    public int indexOf(String string) {
        if (this.terms == null) {
            return -1;
        }
        int n = Arrays.binarySearch(this.terms, string);
        return n >= 0 ? n : -1;
    }

    @Override
    public int[] indexesOf(String[] stringArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.indexOf(stringArray[n + i]);
        }
        return nArray;
    }
}

