/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Serializable;
import org.apache.lucene.util.ArrayUtil;

public class Payload
implements Serializable,
Cloneable {
    protected byte[] data;
    protected int offset;
    protected int length;

    public Payload() {
    }

    public Payload(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public Payload(byte[] byArray, int n, int n2) {
        if (n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException();
        }
        this.data = byArray;
        this.offset = n;
        this.length = n2;
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray.length);
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.length = n2;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int n) {
        if (0 <= n && n < this.length) {
            return this.data[this.offset + n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, this.offset, byArray, 0, this.length);
        return byArray;
    }

    public void copyTo(byte[] byArray, int n) {
        if (this.length > byArray.length + n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.data, this.offset, byArray, n, this.length);
    }

    public Object clone() {
        try {
            Payload payload = (Payload)super.clone();
            if (this.offset == 0 && this.length == this.data.length) {
                payload.data = (byte[])this.data.clone();
            } else {
                payload.data = this.toByteArray();
                payload.offset = 0;
            }
            return payload;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Payload) {
            Payload payload = (Payload)object;
            if (this.length == payload.length) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data[this.offset + i] == payload.data[payload.offset + i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ArrayUtil.hashCode(this.data, this.offset, this.offset + this.length);
    }
}

