/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;

public class MultipleTermPositions
implements TermPositions {
    private int _doc;
    private int _freq;
    private TermPositionsQueue _termPositionsQueue;
    private IntQueue _posList;

    public MultipleTermPositions(IndexReader indexReader, Term[] termArray) throws IOException {
        LinkedList<TermPositions> linkedList = new LinkedList<TermPositions>();
        for (int i = 0; i < termArray.length; ++i) {
            linkedList.add(indexReader.termPositions(termArray[i]));
        }
        this._termPositionsQueue = new TermPositionsQueue(linkedList);
        this._posList = new IntQueue();
    }

    @Override
    public final boolean next() throws IOException {
        if (this._termPositionsQueue.size() == 0) {
            return false;
        }
        this._posList.clear();
        this._doc = this._termPositionsQueue.peek().doc();
        do {
            TermPositions termPositions = this._termPositionsQueue.peek();
            for (int i = 0; i < termPositions.freq(); ++i) {
                this._posList.add(termPositions.nextPosition());
            }
            if (termPositions.next()) {
                this._termPositionsQueue.updateTop();
                continue;
            }
            this._termPositionsQueue.pop();
            termPositions.close();
        } while (this._termPositionsQueue.size() > 0 && this._termPositionsQueue.peek().doc() == this._doc);
        this._posList.sort();
        this._freq = this._posList.size();
        return true;
    }

    @Override
    public final int nextPosition() {
        return this._posList.next();
    }

    @Override
    public final boolean skipTo(int n) throws IOException {
        while (this._termPositionsQueue.peek() != null && n > this._termPositionsQueue.peek().doc()) {
            TermPositions termPositions = (TermPositions)this._termPositionsQueue.pop();
            if (termPositions.skipTo(n)) {
                this._termPositionsQueue.add(termPositions);
                continue;
            }
            termPositions.close();
        }
        return this.next();
    }

    @Override
    public final int doc() {
        return this._doc;
    }

    @Override
    public final int freq() {
        return this._freq;
    }

    @Override
    public final void close() throws IOException {
        while (this._termPositionsQueue.size() > 0) {
            ((TermPositions)this._termPositionsQueue.pop()).close();
        }
    }

    @Override
    public void seek(Term term) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(TermEnum termEnum) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(int[] nArray, int[] nArray2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPayloadLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getPayload(byte[] byArray, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPayloadAvailable() {
        return false;
    }

    private static final class IntQueue {
        private int _arraySize = 16;
        private int _index = 0;
        private int _lastIndex = 0;
        private int[] _array = new int[this._arraySize];

        private IntQueue() {
        }

        final void add(int n) {
            if (this._lastIndex == this._arraySize) {
                this.growArray();
            }
            this._array[this._lastIndex++] = n;
        }

        final int next() {
            return this._array[this._index++];
        }

        final void sort() {
            Arrays.sort(this._array, this._index, this._lastIndex);
        }

        final void clear() {
            this._index = 0;
            this._lastIndex = 0;
        }

        final int size() {
            return this._lastIndex - this._index;
        }

        private void growArray() {
            this._array = ArrayUtil.grow(this._array, this._arraySize + 1);
            this._arraySize = this._array.length;
        }
    }

    private static final class TermPositionsQueue
    extends PriorityQueue<TermPositions> {
        TermPositionsQueue(List<TermPositions> list) throws IOException {
            this.initialize(list.size());
            for (TermPositions termPositions : list) {
                if (!termPositions.next()) continue;
                this.add(termPositions);
            }
        }

        final TermPositions peek() {
            return (TermPositions)this.top();
        }

        @Override
        public final boolean lessThan(TermPositions termPositions, TermPositions termPositions2) {
            return termPositions.doc() < termPositions2.doc();
        }
    }
}

