/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.regex.Pattern;

public final class IndexFileNames {
    public static final String SEGMENTS = "segments";
    public static final String SEGMENTS_GEN = "segments.gen";
    public static final String DELETABLE = "deletable";
    public static final String NORMS_EXTENSION = "nrm";
    public static final String FREQ_EXTENSION = "frq";
    public static final String PROX_EXTENSION = "prx";
    public static final String TERMS_EXTENSION = "tis";
    public static final String TERMS_INDEX_EXTENSION = "tii";
    public static final String FIELDS_INDEX_EXTENSION = "fdx";
    public static final String FIELDS_EXTENSION = "fdt";
    public static final String VECTORS_FIELDS_EXTENSION = "tvf";
    public static final String VECTORS_DOCUMENTS_EXTENSION = "tvd";
    public static final String VECTORS_INDEX_EXTENSION = "tvx";
    public static final String COMPOUND_FILE_EXTENSION = "cfs";
    public static final String COMPOUND_FILE_STORE_EXTENSION = "cfx";
    public static final String DELETES_EXTENSION = "del";
    public static final String FIELD_INFOS_EXTENSION = "fnm";
    public static final String PLAIN_NORMS_EXTENSION = "f";
    public static final String SEPARATE_NORMS_EXTENSION = "s";
    public static final String GEN_EXTENSION = "gen";
    public static final String[] INDEX_EXTENSIONS = new String[]{"cfs", "fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "del", "tvx", "tvd", "tvf", "gen", "nrm", "cfx"};
    public static final String[] INDEX_EXTENSIONS_IN_COMPOUND_FILE = new String[]{"fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "tvx", "tvd", "tvf", "nrm"};
    public static final String[] STORE_INDEX_EXTENSIONS = new String[]{"tvx", "tvf", "tvd", "fdx", "fdt"};
    public static final String[] NON_STORE_INDEX_EXTENSIONS = new String[]{"fnm", "frq", "prx", "tis", "tii", "nrm"};
    public static final String[] COMPOUND_EXTENSIONS = new String[]{"fnm", "frq", "prx", "fdx", "fdt", "tii", "tis"};
    public static final String[] VECTOR_EXTENSIONS = new String[]{"tvx", "tvd", "tvf"};

    public static final String fileNameFromGeneration(String string, String string2, long l) {
        if (l == -1L) {
            return null;
        }
        if (l == 0L) {
            return IndexFileNames.segmentFileName(string, string2);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6 + string2.length()).append(string).append('_').append(Long.toString(l, 36));
        if (string2.length() > 0) {
            stringBuilder.append('.').append(string2);
        }
        return stringBuilder.toString();
    }

    public static final boolean isDocStoreFile(String string) {
        if (string.endsWith(COMPOUND_FILE_STORE_EXTENSION)) {
            return true;
        }
        for (String string2 : STORE_INDEX_EXTENSIONS) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static final String segmentFileName(String string, String string2) {
        if (string2.length() > 0) {
            return new StringBuilder(string.length() + 1 + string2.length()).append(string).append('.').append(string2).toString();
        }
        return string;
    }

    public static final boolean matchesExtension(String string, String string2) {
        return string.endsWith("." + string2);
    }

    public static final String stripSegmentName(String string) {
        int n = string.indexOf(95, 1);
        if (n == -1) {
            n = string.indexOf(46);
        }
        if (n != -1) {
            string = string.substring(n);
        }
        return string;
    }

    public static boolean isSeparateNormsFile(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return Pattern.matches("s[0-9]+", string2);
    }
}

