/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import org.apache.lucene.index.IndexFileNames;

public class IndexFileNameFilter
implements FilenameFilter {
    private static IndexFileNameFilter singleton = new IndexFileNameFilter();
    private HashSet<String> extensions = new HashSet();
    private HashSet<String> extensionsInCFS;

    private IndexFileNameFilter() {
        for (String string : IndexFileNames.INDEX_EXTENSIONS) {
            this.extensions.add(string);
        }
        this.extensionsInCFS = new HashSet();
        for (String string : IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE) {
            this.extensionsInCFS.add(string);
        }
    }

    @Override
    public boolean accept(File file, String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(1 + n);
            if (this.extensions.contains(string2)) {
                return true;
            }
            if (string2.startsWith("f") && string2.matches("f\\d+")) {
                return true;
            }
            if (string2.startsWith("s") && string2.matches("s\\d+")) {
                return true;
            }
        } else {
            if (string.equals("deletable")) {
                return true;
            }
            if (string.startsWith("segments")) {
                return true;
            }
        }
        return false;
    }

    public boolean isCFSFile(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(1 + n);
            if (this.extensionsInCFS.contains(string2)) {
                return true;
            }
            if (string2.startsWith("f") && string2.matches("f\\d+")) {
                return true;
            }
        }
        return false;
    }

    public static IndexFileNameFilter getFilter() {
        return singleton;
    }
}

