/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.BufferedDeletes;
import org.apache.lucene.index.BufferedDeletesStream;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

class FrozenBufferedDeletes {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms terms;
    int termCount;
    final Query[] queries;
    final int[] queryLimits;
    final int bytesUsed;
    final int numTermDeletes;
    final long gen;

    public FrozenBufferedDeletes(BufferedDeletes bufferedDeletes, long l) {
        Comparable[] comparableArray = bufferedDeletes.terms.keySet().toArray(new Term[bufferedDeletes.terms.size()]);
        this.termCount = comparableArray.length;
        ArrayUtil.mergeSort((Comparable[])comparableArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable comparable : comparableArray) {
            builder.add((Term)comparable);
        }
        this.terms = builder.finish();
        this.queries = new Query[bufferedDeletes.queries.size()];
        this.queryLimits = new int[bufferedDeletes.queries.size()];
        int n = 0;
        for (Map.Entry<Query, Integer> entry : bufferedDeletes.queries.entrySet()) {
            this.queries[n] = entry.getKey();
            this.queryLimits[n] = entry.getValue();
            ++n;
        }
        this.bytesUsed = (int)this.terms.getSizeInBytes() + this.queries.length * BYTES_PER_DEL_QUERY;
        this.numTermDeletes = bufferedDeletes.numTermDeletes.get();
        this.gen = l;
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                return FrozenBufferedDeletes.this.terms.iterator();
            }
        };
    }

    public Iterable<BufferedDeletesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedDeletesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedDeletesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedDeletesStream.QueryAndLimit>(){
                    private int upto;

                    @Override
                    public boolean hasNext() {
                        return this.upto < FrozenBufferedDeletes.this.queries.length;
                    }

                    @Override
                    public BufferedDeletesStream.QueryAndLimit next() {
                        BufferedDeletesStream.QueryAndLimit queryAndLimit = new BufferedDeletesStream.QueryAndLimit(FrozenBufferedDeletes.this.queries[this.upto], FrozenBufferedDeletes.this.queryLimits[this.upto]);
                        ++this.upto;
                        return queryAndLimit;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        String string = "";
        if (this.numTermDeletes != 0) {
            string = string + " " + this.numTermDeletes + " deleted terms (unique count=" + this.termCount + ")";
        }
        if (this.queries.length != 0) {
            string = string + " " + this.queries.length + " deleted queries";
        }
        if (this.bytesUsed != 0) {
            string = string + " bytesUsed=" + this.bytesUsed;
        }
        return string;
    }

    boolean any() {
        return this.termCount > 0 || this.queries.length > 0;
    }
}

